/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.card.statistic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.card.statistic.StatisticCardData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex.IndexRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex.IndexSetting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class StatisticCard
extends BaseMobileComponent {
    private static final long serialVersionUID = -5989369735247963065L;
    public static final String COMPONENT_TYPE = "STATISTIC_CARD";
    private String title;
    private String dataTipMessage;
    private String desc;
    private List<StatisticCardData> data = new ArrayList(4);
    private Integer count = 0;

    public void addStatisticCardData(StatisticCardData statisticCardData) {
        this.data.add(statisticCardData);
        this.count = this.data.size();
    }

    public void removeStatisticCardData(StatisticCardData statisticCardData) {
        this.data.remove(statisticCardData);
        this.count = this.data.size();
    }

    public static StatisticCard create(String locale, AgileDataIntermediateDataItem statisticDataItem) {
        List<IndexSetting> indexSettings;
        StatisticCard statisticCard = new StatisticCard();
        IndexRenderSetting indexRender = statisticDataItem.getMobileDSLIndexRender();
        if (indexRender != null) {
            if (StringUtils.isNotEmpty((CharSequence)indexRender.getIndexTitle())) {
                statisticCard.setTitle(indexRender.getIndexTitle().trim());
            }
            if (StringUtils.isNotEmpty((CharSequence)statisticDataItem.getDataTipMessage())) {
                statisticCard.setDataTipMessage(statisticDataItem.getDataTipMessage().trim());
            }
        }
        if (CollectionUtils.isEmpty(indexSettings = Optional.ofNullable(statisticDataItem.getMobileDSLIndexRender()).map(IndexRenderSetting::getIndexSetting).orElse(Collections.emptyList()))) {
            return statisticCard;
        }
        indexSettings.forEach(indexSetting -> statisticCard.addStatisticCardData(new StatisticCardData().setName(indexSetting.getActualTitle(statisticDataItem)).setValue(indexSetting.getActualValue(statisticDataItem)).setBusinessType(indexSetting.getBusinessType()).setDescription(indexSetting.getDescription()).setDecimal(indexSetting.getDecimal()).setPercent(indexSetting.getPercent()).setUnit(indexSetting.getUnit()).setDecimalRule(indexSetting.getDecimalRule()).setDimensionData(indexSetting.getDimensionData()).setMeasurementData(indexSetting.getMeasurementData())));
        return statisticCard;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDataTipMessage() {
        return this.dataTipMessage;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<StatisticCardData> getData() {
        return this.data;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDataTipMessage(String dataTipMessage) {
        this.dataTipMessage = dataTipMessage;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setData(List<StatisticCardData> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticCard)) {
            return false;
        }
        StatisticCard other = (StatisticCard)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$dataTipMessage = this.getDataTipMessage();
        String other$dataTipMessage = other.getDataTipMessage();
        if (this$dataTipMessage == null ? other$dataTipMessage != null : !this$dataTipMessage.equals(other$dataTipMessage)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticCard;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $dataTipMessage = this.getDataTipMessage();
        result = result * 59 + ($dataTipMessage == null ? 43 : $dataTipMessage.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "StatisticCard(title=" + this.getTitle() + ", dataTipMessage=" + this.getDataTipMessage() + ", desc=" + this.getDesc() + ", data=" + this.getData() + ", count=" + this.getCount() + ")";
    }
}

