/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.approval.ApprovalActionNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="attachmentParamAnalyzer")
public class AttachmentParamAnalyzer
implements ComponentParamAnalyzer<Attachment, UiBotAttachment> {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentParamAnalyzer.class);
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public String getComponentType() {
        return "ATTACHMENT";
    }

    public Class<Attachment> getSubmitParamType() {
        return Attachment.class;
    }

    public UiBotAttachment analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Attachment)) {
            logger.debug("submitParam is not instanceof Attachment component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return UiBotAttachment.createEmpty();
        }
        Attachment attachment = (Attachment)submitParam;
        UiBotAttachment uiBotAttachment = attachment.parseToUiBotAttachment(attachment, this.digiwinDmcProxyService);
        uiBotAttachment.filterNotDelete();
        return uiBotAttachment;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        Boolean isTaskEngine;
        JSONObject action = apiRequest.getRawData().getJSONObject("action");
        if (null == action) {
            return;
        }
        PcUiBotSubmitAction submitAction = (PcUiBotSubmitAction)JsonUtil.objectToJavaObject((Object)action, PcUiBotSubmitAction.class);
        PcUiBotSubmitExecuteContext executeContext = submitAction.getExecuteContext();
        if (null != executeContext && BooleanUtils.isNotTrue((Boolean)(isTaskEngine = executeContext.getIsTaskEngine()))) {
            pageData.put((Object)pageDataKey, null);
        }
        if (!CollectionUtils.isEmpty((Collection)submitAction.getAttachActions())) {
            PcUiBotSubmitAction attachActions = (PcUiBotSubmitAction)submitAction.getAttachActions().get(0);
            String serviceId = Optional.ofNullable(attachActions.getServiceId()).map(PcUiBotActionServiceId::getName).orElse("");
            boolean flag = this.isShowAttachment(attachActions.getCategory(), serviceId);
            if (!flag) {
                pageData.put((Object)pageDataKey, null);
            }
        } else {
            String serviceId = Optional.ofNullable(submitAction.getServiceId()).map(PcUiBotActionServiceId::getName).orElse("");
            boolean flag = this.isShowAttachment(submitAction.getCategory(), serviceId);
            if (!flag) {
                pageData.put((Object)pageDataKey, null);
            }
        }
    }

    private boolean isShowAttachment(String category, String serviceId) {
        return "TaskEngine".equals(category) && Lists.newArrayList((Object[])new String[]{"reexecute", "disagree", "agree"}).contains(serviceId) || "workflow".equals(category) && Lists.newArrayList((Object[])new String[]{ApprovalActionNameEnum.WORKFLOW_ACT_RETURN.getValue()}).contains(serviceId);
    }
}

