/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.ocr;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.component.input.ocr.InputOcr;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InputOcrParamAnalyzer
implements ComponentParamAnalyzer<InputOcr, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(InputOcrParamAnalyzer.class);
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public String getComponentType() {
        return "INPUT_OCR";
    }

    public Class<InputOcr> getSubmitParamType() {
        return InputOcr.class;
    }

    public Map<String, Object> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputOcr)) {
            logger.debug("submitParam is not instanceof InputOcr component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return Collections.emptyMap();
        }
        InputOcr inputOcr = (InputOcr)submitParam;
        HashMap<String, Object> params = new HashMap<String, Object>();
        List ocrDataList = inputOcr.getDataList();
        for (OcrData ocrData : ocrDataList) {
            params.put(ocrData.getMobileField(), ocrData.getFieldValue() == null ? "" : ocrData.getFieldValue());
        }
        Attachment attachment = new Attachment();
        attachment.setRawData(((InputOcr)submitParam).getRawData());
        attachment.setFileList(((InputOcr)submitParam).getFileList());
        attachment.setFileMaxSize(new FileMaxSize(((InputOcr)submitParam).getMaxSize()));
        attachment.setTitle(((InputOcr)submitParam).getTitle());
        attachment.setType(((InputOcr)submitParam).getType());
        UiBotAttachment uiBotAttachment = attachment.parseToUiBotAttachment(attachment, this.digiwinDmcProxyService);
        uiBotAttachment.filterNotDelete();
        if (inputOcr.getCardType() == 0) {
            params.put(inputOcr.getSchema(), uiBotAttachment);
        } else if (inputOcr.getCardType() == 1) {
            params.put(inputOcr.getSchema(), uiBotAttachment);
        }
        return params;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

