/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.list.card.Card;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.service.impl.ProjectServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import java.util.ArrayList;
import java.util.List;

public class CardCategory
extends BaseMobileComponent {
    private static final long serialVersionUID = -4709320522075057722L;
    public static final String COMPONENT_TYPE = "CARD_LIST_CATEGORY";
    private List<Card> cardList;
    private String categoryName;

    public static List<CardCategory> getByProjects(List<DigiwinAtmcProject> teamProjects, ProjectFilterService projectFilterService, ProjectServiceImpl projectServiceImpl, List<ProjectServiceImpl.ProjectAndDoingTask> filteredProjectAndDoingTaskList, String locale, String iamUserToken, String userId, String tenantId) {
        ArrayList<CardCategory> cardCategoryList = new ArrayList<CardCategory>();
        CardCategory abnormalCardCategory = new CardCategory();
        abnormalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f/\u5f02\u5e38"));
        ArrayList abnormalCardList = new ArrayList();
        abnormalCardCategory.setCardList(abnormalCardList);
        CardCategory normalCardCategory = new CardCategory();
        normalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5e38"));
        ArrayList normalCardList = new ArrayList();
        normalCardCategory.setCardList(normalCardList);
        if (!filteredProjectAndDoingTaskList.isEmpty()) {
            for (ProjectServiceImpl.ProjectAndDoingTask projectAndDoingTask : filteredProjectAndDoingTaskList) {
                DigiwinAtmcProject project = projectAndDoingTask.getProject();
                DigiwinAtmcTask doingTask = projectAndDoingTask.getTask();
                if (projectFilterService.isCenterConsoleProject(project, tenantId)) {
                    projectServiceImpl.handleCenterConsoleProject(project, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, true);
                    continue;
                }
                if (projectFilterService.isStandardProject(project, tenantId)) {
                    projectServiceImpl.handleStandardProject(project, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, true);
                    continue;
                }
                if (projectFilterService.isSystemCloudHouseKeeper(project, tenantId)) {
                    projectServiceImpl.handleSystemCloudKeeperProject(project, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, true);
                    continue;
                }
                projectServiceImpl.handleCurrentlyNotSupportedProject(project, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, true);
            }
        }
        if (!abnormalCardList.isEmpty()) {
            cardCategoryList.add(abnormalCardCategory);
        }
        if (!normalCardList.isEmpty()) {
            cardCategoryList.add(normalCardCategory);
        }
        return cardCategoryList;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public List<Card> getCardList() {
        return this.cardList;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCardList(List<Card> cardList) {
        this.cardList = cardList;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardCategory)) {
            return false;
        }
        CardCategory other = (CardCategory)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$cardList = this.getCardList();
        List other$cardList = other.getCardList();
        if (this$cardList == null ? other$cardList != null : !((Object)this$cardList).equals(other$cardList)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        return !(this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CardCategory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $cardList = this.getCardList();
        result = result * 59 + ($cardList == null ? 43 : ((Object)$cardList).hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        return result;
    }

    public String toString() {
        return "CardCategory(cardList=" + this.getCardList() + ", categoryName=" + this.getCategoryName() + ")";
    }
}

