/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.list.card.DataTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public enum SystemFilterEnum {
    TASK_TYPE("type", "\u4efb\u52a1\u7c7b\u578b", DataTypeEnum.SELECT.getName(), Collections.emptyMap()),
    TASK_OTHERTASKINFO("otherTaskInfo", "\u4efb\u52a1\u6765\u6e90", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_FLOW_MAP),
    TASK_READ_STATUS("readStatus", "\u9605\u8bfb\u72b6\u6001", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_READ_STATUS_MAP),
    TASK_STATUS("status", "\u4efb\u52a1\u72b6\u6001", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_STATUS_MAP),
    TASK_DATE_RANGE("dateRange", "\u5b8c\u6210\u65f6\u95f4", DataTypeEnum.DATE.getName(), Collections.emptyMap());

    private String type;
    private String name;
    private String dataType;
    private Map<String, String> options;

    public Map<String, String> getOptions(String locale) {
        if (CollectionUtils.isEmpty((Map)this.options)) {
            return this.options;
        }
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        LinkedHashMap<String, String> localeMap = new LinkedHashMap<String, String>();
        this.options.entrySet().stream().forEach(entry -> localeMap.put((String)entry.getKey(), localeService.getLanguageValue(locale, (String)entry.getValue())));
        return localeMap;
    }

    private SystemFilterEnum(String type, String name, String dataType, Map<String, String> options) {
        this.type = type;
        this.name = name;
        this.dataType = dataType;
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

