/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.multi;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="multiFunctionParamAnalyzer")
public class MultiFunctionParamAnalyzer
implements ComponentParamAnalyzer<MultiFunctionList, Map> {
    private static final Logger logger = LoggerFactory.getLogger(MultiFunctionParamAnalyzer.class);
    @Autowired
    private LocaleService localeService;

    public String getComponentType() {
        return "MULTI_FUNCTION_LIST";
    }

    public Class<MultiFunctionList> getSubmitParamType() {
        return MultiFunctionList.class;
    }

    public Map<String, Object> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof MultiFunctionList)) {
            logger.debug("submitParam is not instanceof MultiFunctionList component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return Collections.emptyMap();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        MultiFunctionList multiFunctionList = (MultiFunctionList)submitParam;
        params.put("selectIdList", multiFunctionList.getSelectIdList());
        params.put("selectDetailList", multiFunctionList.getSelectDetailList());
        return params;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)pageDataKey), MultiFunctionList.class);
        multiFunctionList.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), multiFunctionList.getTitle()));
        multiFunctionList.setRawData(apiRequest.getRawData());
        pageData.put((Object)pageDataKey, (Object)multiFunctionList);
    }
}

