/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.mapaddress;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import java.util.HashMap;
import java.util.Map;

public class MapAddress
extends BaseMobileComponent {
    private static final long serialVersionUID = -8184903183383750876L;
    public static final String COMPONENT_TYPE = "MAP_ADDRESS";
    private String title;
    private String schema;
    private String startAddress;
    private String endAddress;
    private Map<String, Object> rawData;

    public static MapAddress create(String schema, DigiwinTransportResponse transportMainInfo, LocaleService localeService, String locale) {
        MapAddress mapAddress = new MapAddress();
        mapAddress.setSchema(schema);
        mapAddress.setStartAddress(transportMainInfo.getDeliveryAddress());
        mapAddress.setEndAddress(transportMainInfo.getReceiptAddress());
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        rawData.put("showPrompt", false);
        if (StrUtil.equals((CharSequence)transportMainInfo.getElectronicFenceStatus(), (CharSequence)"1")) {
            if (StrUtil.equals((CharSequence)transportMainInfo.getArrivalStatus(), (CharSequence)"0")) {
                rawData.put("showPrompt", true);
                rawData.put("name", localeService.getLanguageValue(locale, "\u5373\u5c06\u5230\u8fbe,\u70b9\u51fb\u67e5\u770b\u5165\u5382\u6307\u5f15>>"));
                rawData.put("currentLongitude", transportMainInfo.getCurrentLongitude());
                rawData.put("currentLatitude", transportMainInfo.getCurrentLatitude());
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_FACTORY_GUIDE.toString());
                action.setJumpPageTitle(localeService.getLanguageValue(locale, "\u5165\u5382\u6307\u5f15"));
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                HashMap<String, String> detailRawData = new HashMap<String, String>(1);
                detailRawData.put("transportNo", transportMainInfo.getTransportNo());
                action.setRawData(detailRawData);
                rawData.put("action", action);
            } else if (StrUtil.equals((CharSequence)transportMainInfo.getArrivalStatus(), (CharSequence)"1")) {
                rawData.put("showPrompt", true);
                rawData.put("name", localeService.getLanguageValue(locale, "\u5df2\u5230\u8fbe,\u70b9\u51fb\u67e5\u770b\u5165\u5382\u51ed\u8bc1>>"));
                rawData.put("currentLongitude", transportMainInfo.getCurrentLongitude());
                rawData.put("currentLatitude", transportMainInfo.getCurrentLatitude());
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_FACTORY_VOUCHER.toString());
                action.setJumpPageTitle(localeService.getLanguageValue(locale, "\u5165\u5382\u51ed\u8bc1"));
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_AND_SUBMIT.getValue());
                HashMap<String, String> detailRawData = new HashMap<String, String>(1);
                detailRawData.put("transportNo", transportMainInfo.getTransportNo());
                action.setRawData(detailRawData);
                rawData.put("action", action);
            }
        }
        mapAddress.setRawData(rawData);
        return mapAddress;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getStartAddress() {
        return this.startAddress;
    }

    public String getEndAddress() {
        return this.endAddress;
    }

    public Map<String, Object> getRawData() {
        return this.rawData;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setStartAddress(String startAddress) {
        this.startAddress = startAddress;
    }

    public void setEndAddress(String endAddress) {
        this.endAddress = endAddress;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapAddress)) {
            return false;
        }
        MapAddress other = (MapAddress)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$startAddress = this.getStartAddress();
        String other$startAddress = other.getStartAddress();
        if (this$startAddress == null ? other$startAddress != null : !this$startAddress.equals(other$startAddress)) {
            return false;
        }
        String this$endAddress = this.getEndAddress();
        String other$endAddress = other.getEndAddress();
        if (this$endAddress == null ? other$endAddress != null : !this$endAddress.equals(other$endAddress)) {
            return false;
        }
        Map this$rawData = this.getRawData();
        Map other$rawData = other.getRawData();
        return !(this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $startAddress = this.getStartAddress();
        result = result * 59 + ($startAddress == null ? 43 : $startAddress.hashCode());
        String $endAddress = this.getEndAddress();
        result = result * 59 + ($endAddress == null ? 43 : $endAddress.hashCode());
        Map $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        return result;
    }

    public String toString() {
        return "MapAddress(title=" + this.getTitle() + ", schema=" + this.getSchema() + ", startAddress=" + this.getStartAddress() + ", endAddress=" + this.getEndAddress() + ", rawData=" + this.getRawData() + ")";
    }

    public MapAddress(String title, String schema, String startAddress, String endAddress, Map<String, Object> rawData) {
        this.title = title;
        this.schema = schema;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.rawData = rawData;
    }

    public MapAddress() {
    }
}

