/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.BasePageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component(value="pageDescProjectCCBuilder")
public class PageDescProjectCCBuilder
extends BasePageDescBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PageDescProjectCCBuilder.class);

    public String getBuilderDetailType() {
        return "task_Project_Center_Console_progressTrack";
    }

    public PageDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<PageDesc> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        Assert.notNull((Object)args, (String)"args must not null");
        Assert.notEmpty((Object[])args, (String)"args must have value");
        Assert.isInstanceOf(PccProjectInfo.class, (Object)args[0], (String)"args[0] must be instance of DigiwinAtdmProjectInfo");
        Assert.isInstanceOf(DigiwinAtmcPanel.class, (Object)args[1], (String)"args[1] must be instance of DigiwinAtmcPanel");
        PccProjectInfo projectInfo = (PccProjectInfo)args[0];
        DigiwinAtmcPanel atmcPanel = (DigiwinAtmcPanel)args[1];
        String title = projectInfo.getProjectName();
        String projectTimeDistance = ProjectStringUtil.getProjectCCProjectDateDistanceString((String)locale, (PccProjectInfo)projectInfo);
        String projectSourceInfo = ProjectStringUtil.getProjectSourceInfoString((String)locale, (DigiwinAtmcPanel)atmcPanel);
        String projectInitiatorInfo = ProjectStringUtil.getProjectInitiatorInfoString((String)locale, (DigiwinAtmcPanel)atmcPanel);
        PageDesc pageDesc = new PageDesc(title);
        if (StringUtils.hasLength((String)projectTimeDistance)) {
            pageDesc.addContent(super.getProjectTimeDistanceIconData(), projectTimeDistance, PageDescContentTypeEnum.NORMAL.getValue());
        }
        if (StringUtils.hasLength((String)projectSourceInfo)) {
            pageDesc.addContent(super.getProjectSourceInfoIconData(), projectSourceInfo, PageDescContentTypeEnum.NORMAL.getValue());
        }
        if (StringUtils.hasLength((String)projectInitiatorInfo)) {
            pageDesc.addContent(super.getProjectInitiatorInfoIconData(), projectInitiatorInfo, PageDescContentTypeEnum.NORMAL.getValue());
        }
        return pageDesc;
    }
}

