/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.BaseCustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainerJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabRefreshConfig;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabRefreshTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class CustomTab
extends BaseCustomTab<CustomTabContentContainer> {
    private static final long serialVersionUID = -1198145227690928415L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB";
    @JsonDeserialize(contentUsing=CustomTabContentContainerJsonDeserializer.class)
    private List<CustomTabContentContainer> content = new ArrayList();
    private String id;
    private Integer alignmentType = CustomTabControllerTabAlignEnum.CENTER.getValue();
    private Integer refreshType = CustomTabRefreshTypeEnum.NO_REFRESH.getMode();
    private CustomTabRefreshConfig refreshConfig;
    private Integer scrollMode = CustomTabScrollModeEnum.TAB_SCROLL.getMode();
    private Integer style = 1;
    private Boolean isSelected = false;
    private Integer defaultSelected = 0;
    private String backgroundColor;
    private Integer unHandleCount;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public CustomTab() {
    }

    public CustomTab(String name) {
        super(name);
    }

    public CustomTab(String name, String desc) {
        super(name, desc);
    }

    public void addCustomTabContentContainer(CustomTabContentContainer container) {
        if (null != container) {
            this.content.add(container);
        }
    }

    public void updateRefreshConfigParam(String iamUserToken, String locale, String clientId, String tenantId, String pageId, Map<String, Object> rawData) {
        if (this.refreshType != null && !this.refreshType.equals(CustomTabScrollModeEnum.TAB_SCROLL.getMode())) {
            String configuredUrl = this.refreshConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + clientId + "&tenantId=" + tenantId;
            this.refreshConfig.setIamUserToken(iamUserToken).setLocale(locale).setClientId(clientId).setTenantId(tenantId).setRequestUrl(newUrl).setPageId(pageId).setRawData(rawData);
        }
    }

    public static void fillSupportTab(ApiRequest apiRequest, CustomTab customTab, List<WoOpReportInfo> woOpReportInfoList) {
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
        DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService = (DigiwinKnowledgeMapsProxyService)SpringContextHolder.getBean(DigiwinKnowledgeMapsProxyService.class);
        Map variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), Collections.singletonList("taskNameField"));
        String taskNameField = Optional.ofNullable(variableListSimpleMap).map(e -> MapUtils.getString((Map)e, (Object)"taskNameField")).orElse("");
        Map woOpReportInfoListByWoNoAndOpNo = woOpReportInfoList.stream().collect(Collectors.groupingBy(e -> {
            if ("2".equals(taskNameField)) {
                return e.getProjectNo();
            }
            if ("3".equals(taskNameField)) {
                return e.getPlanLotNo();
            }
            return e.getWoNo();
        }, LinkedHashMap::new, Collectors.groupingBy(WoOpReportInfo::getOpNo, LinkedHashMap::new, Collectors.toList())));
        List retractableList = Retractable.buildRetractable((ApiRequest)apiRequest, (LocaleService)localeService, (Map)woOpReportInfoListByWoNoAndOpNo, (String)taskNameField, null);
        List customTabContentContainerList = retractableList.stream().map(retractable -> {
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setContentCmptType("RETRACYABLE");
            customTabContentContainer.setData(retractable);
            return customTabContentContainer;
        }).collect(Collectors.toList());
        customTab.setContent(customTabContentContainerList);
        customTab.setName(localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + woOpReportInfoList.size() + ")");
    }

    public List<CustomTabContentContainer> getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public Integer getAlignmentType() {
        return this.alignmentType;
    }

    public Integer getRefreshType() {
        return this.refreshType;
    }

    public CustomTabRefreshConfig getRefreshConfig() {
        return this.refreshConfig;
    }

    public Integer getScrollMode() {
        return this.scrollMode;
    }

    public Integer getStyle() {
        return this.style;
    }

    public Boolean getIsSelected() {
        return this.isSelected;
    }

    public Integer getDefaultSelected() {
        return this.defaultSelected;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public Integer getUnHandleCount() {
        return this.unHandleCount;
    }

    @JsonDeserialize(contentUsing=CustomTabContentContainerJsonDeserializer.class)
    public void setContent(List<CustomTabContentContainer> content) {
        this.content = content;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlignmentType(Integer alignmentType) {
        this.alignmentType = alignmentType;
    }

    public void setRefreshType(Integer refreshType) {
        this.refreshType = refreshType;
    }

    public void setRefreshConfig(CustomTabRefreshConfig refreshConfig) {
        this.refreshConfig = refreshConfig;
    }

    public void setScrollMode(Integer scrollMode) {
        this.scrollMode = scrollMode;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setDefaultSelected(Integer defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setUnHandleCount(Integer unHandleCount) {
        this.unHandleCount = unHandleCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTab)) {
            return false;
        }
        CustomTab other = (CustomTab)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$alignmentType = this.getAlignmentType();
        Integer other$alignmentType = other.getAlignmentType();
        if (this$alignmentType == null ? other$alignmentType != null : !((Object)this$alignmentType).equals(other$alignmentType)) {
            return false;
        }
        Integer this$refreshType = this.getRefreshType();
        Integer other$refreshType = other.getRefreshType();
        if (this$refreshType == null ? other$refreshType != null : !((Object)this$refreshType).equals(other$refreshType)) {
            return false;
        }
        Integer this$scrollMode = this.getScrollMode();
        Integer other$scrollMode = other.getScrollMode();
        if (this$scrollMode == null ? other$scrollMode != null : !((Object)this$scrollMode).equals(other$scrollMode)) {
            return false;
        }
        Integer this$style = this.getStyle();
        Integer other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        Boolean this$isSelected = this.getIsSelected();
        Boolean other$isSelected = other.getIsSelected();
        if (this$isSelected == null ? other$isSelected != null : !((Object)this$isSelected).equals(other$isSelected)) {
            return false;
        }
        Integer this$defaultSelected = this.getDefaultSelected();
        Integer other$defaultSelected = other.getDefaultSelected();
        if (this$defaultSelected == null ? other$defaultSelected != null : !((Object)this$defaultSelected).equals(other$defaultSelected)) {
            return false;
        }
        Integer this$unHandleCount = this.getUnHandleCount();
        Integer other$unHandleCount = other.getUnHandleCount();
        if (this$unHandleCount == null ? other$unHandleCount != null : !((Object)this$unHandleCount).equals(other$unHandleCount)) {
            return false;
        }
        List this$content = this.getContent();
        List other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        CustomTabRefreshConfig this$refreshConfig = this.getRefreshConfig();
        CustomTabRefreshConfig other$refreshConfig = other.getRefreshConfig();
        if (this$refreshConfig == null ? other$refreshConfig != null : !this$refreshConfig.equals(other$refreshConfig)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTab;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $alignmentType = this.getAlignmentType();
        result = result * 59 + ($alignmentType == null ? 43 : ((Object)$alignmentType).hashCode());
        Integer $refreshType = this.getRefreshType();
        result = result * 59 + ($refreshType == null ? 43 : ((Object)$refreshType).hashCode());
        Integer $scrollMode = this.getScrollMode();
        result = result * 59 + ($scrollMode == null ? 43 : ((Object)$scrollMode).hashCode());
        Integer $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        Boolean $isSelected = this.getIsSelected();
        result = result * 59 + ($isSelected == null ? 43 : ((Object)$isSelected).hashCode());
        Integer $defaultSelected = this.getDefaultSelected();
        result = result * 59 + ($defaultSelected == null ? 43 : ((Object)$defaultSelected).hashCode());
        Integer $unHandleCount = this.getUnHandleCount();
        result = result * 59 + ($unHandleCount == null ? 43 : ((Object)$unHandleCount).hashCode());
        List $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        CustomTabRefreshConfig $refreshConfig = this.getRefreshConfig();
        result = result * 59 + ($refreshConfig == null ? 43 : $refreshConfig.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        return result;
    }

    public String toString() {
        return "CustomTab(content=" + this.getContent() + ", id=" + this.getId() + ", alignmentType=" + this.getAlignmentType() + ", refreshType=" + this.getRefreshType() + ", refreshConfig=" + this.getRefreshConfig() + ", scrollMode=" + this.getScrollMode() + ", style=" + this.getStyle() + ", isSelected=" + this.getIsSelected() + ", defaultSelected=" + this.getDefaultSelected() + ", backgroundColor=" + this.getBackgroundColor() + ", unHandleCount=" + this.getUnHandleCount() + ")";
    }
}

