/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.webview;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewButtonTipConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class Webview
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = -5538834550678950525L;
    public static final String COMPONENT_TYPE = "WEBVIEW";
    private Integer sizeMode;
    private String title;
    private String url;
    private List<BottomButtonDigiwinAthena> buttonList = new ArrayList(1);
    private WebviewButtonTipConfig buttonTipConfig;
    private Integer widthMode;
    private Double aspectRatio;
    private Boolean verticalScroll = false;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void initSetting(String locale) {
        super.initSetting(locale);
        if (null != this.buttonTipConfig) {
            String configedTipConfig = this.buttonTipConfig.getText();
            this.buttonTipConfig.setText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)configedTipConfig));
        }
    }

    public BottomButtonDigiwinAthena createLeftSlipOpenWindowButton() {
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        buttonDigiwinAthena.setAction(action);
        buttonDigiwinAthena.setIconData(Integer.valueOf(59119));
        return buttonDigiwinAthena;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value) && "PWD_RTP_InquiryReply".equals(executeContext.getTmActivityId())) {
            String onlineDrawingFormat = StringUtil.valueOf((Object)UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)"inquiry_info.graph_info.online_drawing_format", (String)"online_drawing_format"));
            if ("2".equals(onlineDrawingFormat)) {
                value = AppContext.getApiUrlSetting().getMuiUrl() + "/graph-viewer?online_drawing_format=" + onlineDrawingFormat + "&cad_url=" + value;
            } else {
                try {
                    String[] parts = value.split("/");
                    String fileName = parts[parts.length - 1].split("\\.")[0];
                    value = AppContext.getApiUrlSetting().getDmcUrl().replace("dmc-hw-test", "dmc-test") + "/api/dmc/v2/file/" + parts[parts.length - 4] + "/online/preview/" + fileName;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.url = value;
        this.buttonList.add(this.createLeftSlipOpenWindowButton());
    }

    public Integer getSizeMode() {
        return this.sizeMode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public List<BottomButtonDigiwinAthena> getButtonList() {
        return this.buttonList;
    }

    public WebviewButtonTipConfig getButtonTipConfig() {
        return this.buttonTipConfig;
    }

    public Integer getWidthMode() {
        return this.widthMode;
    }

    public Double getAspectRatio() {
        return this.aspectRatio;
    }

    public Boolean getVerticalScroll() {
        return this.verticalScroll;
    }

    public void setSizeMode(Integer sizeMode) {
        this.sizeMode = sizeMode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setButtonList(List<BottomButtonDigiwinAthena> buttonList) {
        this.buttonList = buttonList;
    }

    public void setButtonTipConfig(WebviewButtonTipConfig buttonTipConfig) {
        this.buttonTipConfig = buttonTipConfig;
    }

    public void setWidthMode(Integer widthMode) {
        this.widthMode = widthMode;
    }

    public void setAspectRatio(Double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void setVerticalScroll(Boolean verticalScroll) {
        this.verticalScroll = verticalScroll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Webview)) {
            return false;
        }
        Webview other = (Webview)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$sizeMode = this.getSizeMode();
        Integer other$sizeMode = other.getSizeMode();
        if (this$sizeMode == null ? other$sizeMode != null : !((Object)this$sizeMode).equals(other$sizeMode)) {
            return false;
        }
        Integer this$widthMode = this.getWidthMode();
        Integer other$widthMode = other.getWidthMode();
        if (this$widthMode == null ? other$widthMode != null : !((Object)this$widthMode).equals(other$widthMode)) {
            return false;
        }
        Double this$aspectRatio = this.getAspectRatio();
        Double other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !((Object)this$aspectRatio).equals(other$aspectRatio)) {
            return false;
        }
        Boolean this$verticalScroll = this.getVerticalScroll();
        Boolean other$verticalScroll = other.getVerticalScroll();
        if (this$verticalScroll == null ? other$verticalScroll != null : !((Object)this$verticalScroll).equals(other$verticalScroll)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List this$buttonList = this.getButtonList();
        List other$buttonList = other.getButtonList();
        if (this$buttonList == null ? other$buttonList != null : !((Object)this$buttonList).equals(other$buttonList)) {
            return false;
        }
        WebviewButtonTipConfig this$buttonTipConfig = this.getButtonTipConfig();
        WebviewButtonTipConfig other$buttonTipConfig = other.getButtonTipConfig();
        return !(this$buttonTipConfig == null ? other$buttonTipConfig != null : !this$buttonTipConfig.equals(other$buttonTipConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Webview;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sizeMode = this.getSizeMode();
        result = result * 59 + ($sizeMode == null ? 43 : ((Object)$sizeMode).hashCode());
        Integer $widthMode = this.getWidthMode();
        result = result * 59 + ($widthMode == null ? 43 : ((Object)$widthMode).hashCode());
        Double $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : ((Object)$aspectRatio).hashCode());
        Boolean $verticalScroll = this.getVerticalScroll();
        result = result * 59 + ($verticalScroll == null ? 43 : ((Object)$verticalScroll).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List $buttonList = this.getButtonList();
        result = result * 59 + ($buttonList == null ? 43 : ((Object)$buttonList).hashCode());
        WebviewButtonTipConfig $buttonTipConfig = this.getButtonTipConfig();
        result = result * 59 + ($buttonTipConfig == null ? 43 : $buttonTipConfig.hashCode());
        return result;
    }

    public String toString() {
        return "Webview(sizeMode=" + this.getSizeMode() + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ", buttonList=" + this.getButtonList() + ", buttonTipConfig=" + this.getButtonTipConfig() + ", widthMode=" + this.getWidthMode() + ", aspectRatio=" + this.getAspectRatio() + ", verticalScroll=" + this.getVerticalScroll() + ")";
    }
}

