/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.layout.analyzer;

import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeight;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="layoutAnalyzerWeightReader")
public class LayoutAnalyzerWeightReader {
    private static final Logger log = LoggerFactory.getLogger(LayoutAnalyzerWeightReader.class);
    private List<LayoutAnalyzerWeight> layoutAnalyzerWeightList = Collections.synchronizedList(new ArrayList());

    public LayoutAnalyzerWeight getMaxWeight() {
        return this.getMaxWeight(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LayoutAnalyzerWeight getMaxWeight(boolean basedOnAugmentedIntelligence) {
        if (CollectionUtils.isEmpty((Collection)this.layoutAnalyzerWeightList)) {
            Class<LayoutAnalyzerWeightReader> clazz = LayoutAnalyzerWeightReader.class;
            // MONITORENTER : com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeightReader.class
            if (CollectionUtils.isEmpty((Collection)this.layoutAnalyzerWeightList)) {
                this.layoutAnalyzerWeightList = new ArrayList(LayoutAnalyzerTypeEnum.values().length);
                if (!basedOnAugmentedIntelligence) {
                    this.layoutAnalyzerWeightList.add(new LayoutAnalyzerWeight().setLayoutAnalyzerTypeEnum(LayoutAnalyzerTypeEnum.BIZ_DATA_TYPE).setWeight(LayoutAnalyzerWeight.MAX_WEIGHT));
                    this.layoutAnalyzerWeightList.add(new LayoutAnalyzerWeight().setLayoutAnalyzerTypeEnum(LayoutAnalyzerTypeEnum.SCENERIO_DATA_TYPE).setWeight(LayoutAnalyzerWeight.MIN_WEIGHT));
                }
            }
            // MONITOREXIT : clazz
        }
        this.executeEcc(this.layoutAnalyzerWeightList);
        this.layoutAnalyzerWeightList.sort(Comparator.comparingDouble(LayoutAnalyzerWeight::getWeight));
        return (LayoutAnalyzerWeight)this.layoutAnalyzerWeightList.get(this.layoutAnalyzerWeightList.size() - 1);
    }

    private void executeEcc(List<LayoutAnalyzerWeight> layoutAnalyzerWeights) {
        if (CollectionUtils.isEmpty(layoutAnalyzerWeights)) {
            return;
        }
        Optional<LayoutAnalyzerWeight> optMaxLayoutAnalyzerWeight = layoutAnalyzerWeights.stream().max(Comparator.comparingDouble(LayoutAnalyzerWeight::getWeight));
        if (optMaxLayoutAnalyzerWeight.isPresent()) {
            Double maxWeight = optMaxLayoutAnalyzerWeight.get().getWeight();
            List maxWeightAnalyzerList = layoutAnalyzerWeights.stream().filter(w -> Objects.equals(maxWeight, w.getWeight())).collect(Collectors.toList());
            if (maxWeightAnalyzerList.size() > 1) {
                if (maxWeight >= LayoutAnalyzerWeight.MAX_WEIGHT) {
                    for (int i = 0; i < maxWeightAnalyzerList.size(); ++i) {
                        LayoutAnalyzerWeight layoutAnalyzerWeight = (LayoutAnalyzerWeight)maxWeightAnalyzerList.get(i);
                        if (i == 0) {
                            layoutAnalyzerWeight.setWeight(LayoutAnalyzerWeight.MAX_WEIGHT);
                            continue;
                        }
                        layoutAnalyzerWeight.setWeight(Double.valueOf(LayoutAnalyzerWeight.MAX_WEIGHT - LayoutAnalyzerWeight.WEIGHT_STEP));
                    }
                } else {
                    LayoutAnalyzerWeight layoutAnalyzerWeight = (LayoutAnalyzerWeight)maxWeightAnalyzerList.get(0);
                    Double weight = layoutAnalyzerWeight.getWeight();
                    Double newWeight = weight + LayoutAnalyzerWeight.WEIGHT_STEP;
                    if (newWeight >= LayoutAnalyzerWeight.MAX_WEIGHT) {
                        layoutAnalyzerWeight.setWeight(LayoutAnalyzerWeight.MAX_WEIGHT);
                    } else {
                        layoutAnalyzerWeight.setWeight(newWeight);
                    }
                }
            }
        }
    }
}

