/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.pagetaskrelation;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

@Document(collection="pageTaskRelation")
public class PageTaskRelation
implements Serializable {
    private static final long serialVersionUID = 4759058879095295701L;
    @Id
    private String id;
    private String source;
    private String pageId;
    private String url;
    private String category;
    private TaskFilterParam param;
    private List<EnvScope> envScopes;
    private String from;
    private String createTime;
    private String updateTime;
    private String appCode;
    private String version;

    public Boolean validWithAppEnvType(String appEnvType) {
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        Boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            Boolean valid = envScope.getValid();
            if (!appEnvType.equals(type)) continue;
            result = valid;
            break;
        }
        return result;
    }

    public Boolean matchInPatternAndCategory(String tmPattern, String tmCategory) {
        if (null == tmPattern || null == tmCategory) {
            return false;
        }
        if (this.param == null) {
            return false;
        }
        String paramTmPattern = StringUtil.valueOf((Object)this.param.getTmPattern());
        String paramTmCategory = StringUtil.valueOf((Object)this.param.getTmCategory());
        if (!StringUtils.hasLength((String)paramTmPattern) && !StringUtils.hasLength((String)paramTmCategory)) {
            return false;
        }
        return !(StringUtils.hasLength((String)paramTmPattern) && !paramTmPattern.equals(tmPattern) || StringUtils.hasLength((String)paramTmCategory) && !paramTmCategory.equals(tmCategory));
    }

    public Boolean matchInTaskIdAndActivityId(String tmTaskId, String tmActivityId) {
        if (null == tmTaskId || null == tmActivityId) {
            return false;
        }
        if (this.param == null) {
            return false;
        }
        String paramTmTaskId = StringUtil.valueOf((Object)this.param.getTmTaskId());
        String paramTmActivityId = StringUtil.valueOf((Object)this.param.getTmActivityId());
        return (!StringUtils.hasLength((String)paramTmTaskId) || TaskFilter.match((String)tmTaskId.trim(), (String)paramTmTaskId, (String)this.param.getTmTaskIdMatch())) && TaskFilter.match((String)tmActivityId, (String)paramTmActivityId, (String)this.param.getTmActivityIdMatch());
    }

    public Boolean matchPatternIsCustom() {
        if (this.param == null) {
            return false;
        }
        return "CUSTOM".equals(this.param.getTmPattern());
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCategory() {
        return this.category;
    }

    public TaskFilterParam getParam() {
        return this.param;
    }

    public List<EnvScope> getEnvScopes() {
        return this.envScopes;
    }

    public String getFrom() {
        return this.from;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setParam(TaskFilterParam param) {
        this.param = param;
    }

    public void setEnvScopes(List<EnvScope> envScopes) {
        this.envScopes = envScopes;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageTaskRelation)) {
            return false;
        }
        PageTaskRelation other = (PageTaskRelation)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        TaskFilterParam this$param = this.getParam();
        TaskFilterParam other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        List this$envScopes = this.getEnvScopes();
        List other$envScopes = other.getEnvScopes();
        if (this$envScopes == null ? other$envScopes != null : !((Object)this$envScopes).equals(other$envScopes)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageTaskRelation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        TaskFilterParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        List $envScopes = this.getEnvScopes();
        result = result * 59 + ($envScopes == null ? 43 : ((Object)$envScopes).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "PageTaskRelation(id=" + this.getId() + ", source=" + this.getSource() + ", pageId=" + this.getPageId() + ", url=" + this.getUrl() + ", category=" + this.getCategory() + ", param=" + this.getParam() + ", envScopes=" + this.getEnvScopes() + ", from=" + this.getFrom() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", appCode=" + this.getAppCode() + ", version=" + this.getVersion() + ")";
    }
}

