/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.rule.validate;

import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleUtil;
import java.io.Serializable;
import java.util.Map;
import org.springframework.util.Assert;

public class ValidateRule
implements Serializable {
    private static final long serialVersionUID = 5886119652387271420L;
    private String parameter;
    private String schema;
    private String scope;
    private String type;
    private String errorMessage;
    private Integer operatorType;
    private Integer order;
    private String parameterDataType;
    private Map<String, Object> parameterDate;
    private String warningMessage;
    private Integer level;

    public ValidateRule(String schema) {
        this.schema = schema;
    }

    public static ValidateRule create(Rule rule, String locale, Map<String, Object> bizData) {
        Assert.notNull((Object)rule, (String)"rule must not null!");
        Assert.isTrue((boolean)rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory()), (String)"rule must be validate category!");
        ValidateRule validateRule = new ValidateRule();
        if (RuleUtil.validExpression((String)rule.getParameter())) {
            String expressionBizDataKey = RuleUtil.analyzeExpressionBizDataKey((String)rule.getParameter());
            Object bizDataValue = bizData.get(expressionBizDataKey);
            if ("complete_rate".equalsIgnoreCase(expressionBizDataKey)) {
                Double completeRateValue = null != bizDataValue ? Double.parseDouble(String.valueOf(bizDataValue)) : 0.0;
                validateRule.setParameter(String.valueOf(MathUtil.doubleMathCalculation((double)completeRateValue, (double)100.0, (String)"*")));
            } else {
                validateRule.setParameter(String.valueOf(bizDataValue));
            }
        } else {
            validateRule.setParameter(rule.getParameter());
        }
        validateRule.setSchema(rule.getSchema());
        validateRule.setScope(rule.getScope());
        validateRule.setType(rule.getType());
        if (null != rule.getOperatorType()) {
            validateRule.setOperatorType(rule.getOperatorType());
        }
        if (null != rule.getParameterDataType()) {
            validateRule.setParameterDataType(rule.getParameterDataType());
        }
        if (null != rule.getErrorMessage()) {
            validateRule.setErrorMessage(rule.errorMessageInfo(locale));
        }
        if (null != rule.getOrder()) {
            validateRule.setOrder(rule.getOrder());
        }
        return validateRule;
    }

    public boolean ruleIsEmpty() {
        return this.type == null && this.parameter == null;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getScope() {
        return this.scope;
    }

    public String getType() {
        return this.type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getOperatorType() {
        return this.operatorType;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getParameterDataType() {
        return this.parameterDataType;
    }

    public Map<String, Object> getParameterDate() {
        return this.parameterDate;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setOperatorType(Integer operatorType) {
        this.operatorType = operatorType;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setParameterDataType(String parameterDataType) {
        this.parameterDataType = parameterDataType;
    }

    public void setParameterDate(Map<String, Object> parameterDate) {
        this.parameterDate = parameterDate;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateRule)) {
            return false;
        }
        ValidateRule other = (ValidateRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$operatorType = this.getOperatorType();
        Integer other$operatorType = other.getOperatorType();
        if (this$operatorType == null ? other$operatorType != null : !((Object)this$operatorType).equals(other$operatorType)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        if (this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$parameterDataType = this.getParameterDataType();
        String other$parameterDataType = other.getParameterDataType();
        if (this$parameterDataType == null ? other$parameterDataType != null : !this$parameterDataType.equals(other$parameterDataType)) {
            return false;
        }
        Map this$parameterDate = this.getParameterDate();
        Map other$parameterDate = other.getParameterDate();
        if (this$parameterDate == null ? other$parameterDate != null : !((Object)this$parameterDate).equals(other$parameterDate)) {
            return false;
        }
        String this$warningMessage = this.getWarningMessage();
        String other$warningMessage = other.getWarningMessage();
        return !(this$warningMessage == null ? other$warningMessage != null : !this$warningMessage.equals(other$warningMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $operatorType = this.getOperatorType();
        result = result * 59 + ($operatorType == null ? 43 : ((Object)$operatorType).hashCode());
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $parameterDataType = this.getParameterDataType();
        result = result * 59 + ($parameterDataType == null ? 43 : $parameterDataType.hashCode());
        Map $parameterDate = this.getParameterDate();
        result = result * 59 + ($parameterDate == null ? 43 : ((Object)$parameterDate).hashCode());
        String $warningMessage = this.getWarningMessage();
        result = result * 59 + ($warningMessage == null ? 43 : $warningMessage.hashCode());
        return result;
    }

    public String toString() {
        return "ValidateRule(parameter=" + this.getParameter() + ", schema=" + this.getSchema() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", errorMessage=" + this.getErrorMessage() + ", operatorType=" + this.getOperatorType() + ", order=" + this.getOrder() + ", parameterDataType=" + this.getParameterDataType() + ", parameterDate=" + this.getParameterDate() + ", warningMessage=" + this.getWarningMessage() + ", level=" + this.getLevel() + ")";
    }

    public ValidateRule() {
    }

    public ValidateRule(String parameter, String schema, String scope, String type, String errorMessage, Integer operatorType, Integer order, String parameterDataType, Map<String, Object> parameterDate, String warningMessage, Integer level) {
        this.parameter = parameter;
        this.schema = schema;
        this.scope = scope;
        this.type = type;
        this.errorMessage = errorMessage;
        this.operatorType = operatorType;
        this.order = order;
        this.parameterDataType = parameterDataType;
        this.parameterDate = parameterDate;
        this.warningMessage = warningMessage;
        this.level = level;
    }
}

