/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataConstStringEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildAgileDataDetailStrategy")
public class UiBotModelBuildAgileDataDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildAgileDataDetailStrategy.class);
    private final DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    private final LocaleService localeService;

    public UiBotModelBuildAgileDataDetailStrategy(DigiwinPcUiBotProxyService digiwinPcUiBotProxyService, LocaleService localeService) {
        this.digiwinPcUiBotProxyService = digiwinPcUiBotProxyService;
        this.localeService = localeService;
    }

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Agile Data Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData != false || modelTypeShow != false ? this.doMockData(pageSetting, apiRequest) : this.doActually(pageSetting, apiRequest, stopWatch);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String locale = apiRequest.getLocale();
        UiBotModel resultUiBotModel = pageSetting.getPageModel();
        stopWatch.start("GetData From Web UIBot API");
        AgileDataIntermediateDsl intermediateDsl = this.digiwinPcUiBotProxyService.getAgileReportShow(apiRequest.getDataId(), Collections.emptyMap(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale);
        stopWatch.stop();
        if (StringUtils.hasLength((String)intermediateDsl.getErrorMessage())) {
            String errorMessage = intermediateDsl.getErrorMessage();
            resultUiBotModel = UiBotModel.emptyImageUibotModel((String)locale, (String)errorMessage, (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
            return resultUiBotModel;
        }
        stopWatch.start("Start Generate Agile Data Detail...");
        TitleBody titleBody = this.createTitleBodyFromDslExecuteContext(intermediateDsl);
        List agileDataMobileComponents = ModuleUtils.generateComponentFromAgileDataIntermediateDsl((ApiRequest)apiRequest, (AgileDataIntermediateDsl)intermediateDsl, (boolean)false);
        if (CollectionUtils.isEmpty((Collection)agileDataMobileComponents)) {
            String emptyText = this.localeService.getLanguageValue(locale, AgileDataConstStringEnum.DETAIL_PAGE_NO_DATA_REPLY.getValue());
            Empty emptyMobileComponent = Empty.create((String)emptyText, (boolean)true, (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
            agileDataMobileComponents.add(emptyMobileComponent);
        }
        ArrayList<TitleBody> resultMobileComponents = new ArrayList<TitleBody>(agileDataMobileComponents.size() + 1);
        resultMobileComponents.add(titleBody);
        resultMobileComponents.addAll(agileDataMobileComponents);
        resultUiBotModel = this.addMobileComponentsToUiBotModel(resultUiBotModel, resultMobileComponents);
        String pageTitle = this.localeService.getLanguageValue(locale, titleBody.getContent().getText());
        if (resultUiBotModel != null && resultUiBotModel.getSlip() != null && resultUiBotModel.getSlip().getSlipConfig() != null && resultUiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipTitle slipTitle = resultUiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
            slipTitle.setContent(pageTitle + " " + this.localeService.getLanguageValue(locale, "\u5f53\u524d\u6c9f\u901a"));
        }
        stopWatch.stop();
        return resultUiBotModel;
    }

    private TitleBody createTitleBodyFromDslExecuteContext(AgileDataIntermediateDsl intermediateDsl) {
        UiBotExecuteContext executeContext = intermediateDsl.getExecuteContext();
        String title = executeContext.getString("title");
        TitleBody titleBody = TitleBody.create((String)title, null, Collections.emptyList());
        return titleBody;
    }

    private UiBotModel addMobileComponentsToUiBotModel(UiBotModel uiBotModel, List<MobileComponent> mobileComponents) {
        if (null == uiBotModel || CollectionUtils.isEmpty(mobileComponents)) {
            return null;
        }
        mobileComponents.forEach(mc -> {
            String schema = UUIDUtil.getUuid();
            UiBotLayout mcLayout = new UiBotLayout(schema, mc.returnComponentType());
            UiBotPageData mcAddedPageData = uiBotModel.getPageData();
            mcAddedPageData.put((Object)schema, mc);
            uiBotModel.addLayout(mcLayout);
            uiBotModel.setPageData(mcAddedPageData);
        });
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String dslString = FileUtil.readText((String)"./static/agiledata/dsl-response.json");
        DigiwinAthenaApiResponse response = (DigiwinAthenaApiResponse)JsonUtil.jsonStringToObject((String)dslString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        AgileDataIntermediateDsl intermediateDsl = (AgileDataIntermediateDsl)response.getResponse();
        UiBotModel resultUiBotModel = pageSetting.getPageModel();
        if (intermediateDsl == null || intermediateDsl.isEmpty()) {
            resultUiBotModel = UiBotModel.emptyImageUibotModel((String)locale, (String)AgileDataConstStringEnum.DETAIL_PAGE_NO_DATA_REPLY.getValue(), (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
            return resultUiBotModel;
        }
        TitleBody titleBody = this.createTitleBodyFromDslExecuteContext(intermediateDsl);
        List agileDataMobileComponents = ModuleUtils.generateComponentFromAgileDataIntermediateDsl((ApiRequest)apiRequest, (AgileDataIntermediateDsl)intermediateDsl, (boolean)false);
        ArrayList<TitleBody> resultMobileComponents = new ArrayList<TitleBody>(agileDataMobileComponents.size() + 1);
        resultMobileComponents.add(titleBody);
        resultMobileComponents.addAll(agileDataMobileComponents);
        resultUiBotModel = this.addMobileComponentsToUiBotModel(resultUiBotModel, resultMobileComponents);
        String pageTitle = this.localeService.getLanguageValue(locale, titleBody.getContent().getText());
        if (resultUiBotModel != null && resultUiBotModel.getSlip() != null && resultUiBotModel.getSlip().getSlipConfig() != null && resultUiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipTitle slipTitle = resultUiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
            slipTitle.setContent(pageTitle + " " + this.localeService.getLanguageValue(locale, "\u5f53\u524d\u6c9f\u901a"));
        }
        return resultUiBotModel;
    }
}

