/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildBottomWindowInfoStrategy")
public class UiBotModelBuildBottomWindowInfoStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildBottomWindowInfoStrategy.class);

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "MESSAGE_BAR": {
                    pageData.put((Object)schema, (Object)MessageBar.create((String)((String)rawData.get((Object)"message"))));
                    break;
                }
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    multiFunctionList.setRawData(rawData);
                    pageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)uiBotLayout.getSchema())), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                    }
                    if (Optional.ofNullable(rawData.getBoolean("submit_button")).orElse(false).booleanValue()) {
                        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
                        buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
                        buttonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)"\u63d0\u4ea4"));
                        Action action = new Action();
                        action.setType(ActionTypeEnum.CALL_API_RAWDATA_OPEN_SUCCESS_PAGE.getValue());
                        action.setSuccessMsg(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u521b\u5efa\u6210\u529f"));
                        action.setRawData((Object)rawData);
                        buttonDigiwinAthena.setAction(action);
                        buttons.add(buttonDigiwinAthena);
                    }
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)buttons);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

