/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildMyApprovalTaskItemDetailStrategy")
public class UiBotModelBuildMyApprovalTaskItemDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Integer FILED_MORE_SIZE = 5;
    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        ApiRawData rawData = apiRequest.getRawData();
        List fieldDataList = new ArrayList();
        List tableLayout = new ArrayList();
        UiBotPageData tablePageData = new UiBotPageData();
        if (rawData.get("data") != null) {
            fieldDataList = (List)JsonUtil.objectToJavaObject(rawData.get("data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (rawData.get("layout") != null) {
            tableLayout = (List)JsonUtil.objectToJavaObject(rawData.get("layout"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (rawData.get("pageData") != null) {
            tablePageData = (UiBotPageData)JsonUtil.objectToJavaObject(rawData.get("pageData"), UiBotPageData.class);
        }
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    pageData.put((Object)layout.getSchema(), (Object)this.buildCustomGroup(apiRequest, fieldDataList));
                    break;
                }
                case "TABS": {
                    UiBotModel tabUiBotModel = UiBotModel.emptyUiBotModel();
                    tabUiBotModel.setLayout(tableLayout);
                    tabUiBotModel.setPageData(tablePageData);
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.buildAllTabs(apiRequest, tabUiBotModel);
                    tabs.forEach(tab -> tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode()));
                    pageData.put((Object)layout.getSchema(), (Object)tabs);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String name = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)name));
                    });
                    pageData.put((Object)layout.getSchema(), (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildCustomGroup(ApiRequest apiRequest, List<ParseFieldData> fieldDataList) {
        String locale = apiRequest.getLocale();
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_APPROVAL_ITEM_DETAIL.getValue());
        CustomGroupContent customGroupContent = this.buildCustomGroupContent(apiRequest, fieldDataList);
        customGroup.setContent(customGroupContent);
        if (customGroupContent.getLayout().size() > FILED_MORE_SIZE) {
            customGroup.setUseExpand(Boolean.valueOf(true));
            HiddenConfig hiddenConfig = new HiddenConfig();
            hiddenConfig.setHiddenType(HiddenConfigTypeEnum.FIELD.getValue());
            hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u67e5\u770b\u66f4\u591a"));
            hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d77"));
            hiddenConfig.setHiddenCount(FILED_MORE_SIZE);
            customGroup.setHiddenConfig(hiddenConfig);
        }
        return customGroup;
    }

    private CustomGroupContent buildCustomGroupContent(ApiRequest apiRequest, List<ParseFieldData> fieldDataList) {
        Boolean needTitle;
        Field field;
        CustomGroupContent customGroupContent = new CustomGroupContent();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>(fieldDataList.size());
        UiBotPageData pageData = new UiBotPageData();
        customGroupContent.setLayout(layoutList);
        customGroupContent.setPageData(pageData);
        ParseFieldData performerNameFieldData = null;
        ParseFieldData backLogDataNameFieldData = null;
        ParseFieldData planEndTimeFieldData = null;
        ParseFieldData approvalStateFieldData = null;
        for (ParseFieldData fieldData : fieldDataList) {
            if ("activity__performerName".equalsIgnoreCase(fieldData.getSchema())) {
                performerNameFieldData = fieldData;
            }
            if ("activity__backLog__data".equalsIgnoreCase(fieldData.getSchema())) {
                backLogDataNameFieldData = fieldData;
            }
            if ("activity__planEndTime".equalsIgnoreCase(fieldData.getSchema())) {
                planEndTimeFieldData = fieldData;
            }
            if (!"activity__approval__state".equalsIgnoreCase(fieldData.getSchema())) continue;
            approvalStateFieldData = fieldData;
        }
        if (performerNameFieldData != null) {
            fieldDataList.remove(performerNameFieldData);
        }
        if (backLogDataNameFieldData != null) {
            fieldDataList.remove(backLogDataNameFieldData);
            field = this.calculateTaskStatus(backLogDataNameFieldData, apiRequest.getLocale());
            layoutList.add(new UiBotLayout(field.getSchema(), "FIELD"));
            pageData.put((Object)field.getSchema(), (Object)field);
        }
        if (planEndTimeFieldData != null) {
            fieldDataList.remove(planEndTimeFieldData);
            field = this.convertTabItemCardContent(planEndTimeFieldData);
            layoutList.add(new UiBotLayout(field.getSchema(), "FIELD"));
            pageData.put((Object)field.getSchema(), (Object)field);
        }
        if (approvalStateFieldData != null) {
            fieldDataList.remove(approvalStateFieldData);
            field = this.approvalStateField(approvalStateFieldData, apiRequest.getLocale(), apiRequest.getDataId());
            layoutList.add(new UiBotLayout(field.getSchema(), "FIELD"));
            pageData.put((Object)field.getSchema(), (Object)field);
        }
        if (!layoutList.isEmpty()) {
            Divider divider = new Divider();
            divider.setType(DividerTypeEnum.ELEMENT_DIVIDER.getValue());
            String schema = divider.returnComponentType() + "_" + divider.getCmptUuid();
            layoutList.add(new UiBotLayout(schema, "DIVIDER"));
            pageData.put((Object)schema, (Object)divider);
        }
        if ((needTitle = (Boolean)Optional.ofNullable(apiRequest.getRawData().get((Object)"needTitle")).orElse(false)).booleanValue()) {
            ParseFieldData fieldData;
            fieldData = fieldDataList.get(0);
            fieldDataList.remove(fieldData);
            Field field2 = Field.create((ParseFieldData)fieldData, (String)apiRequest.getLocale());
            field2.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BIG_TITLE.getValue());
            field2.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
            field2.setLabel("");
            field2.setLabelVisible(Boolean.valueOf(false));
            layoutList.add(new UiBotLayout(field2.getSchema(), "FIELD"));
            pageData.put((Object)field2.getSchema(), (Object)field2);
        }
        for (ParseFieldData fieldData : fieldDataList) {
            Field field3;
            if ("DYNAMIC_GRAPH_VIEWER".equalsIgnoreCase(fieldData.getType())) continue;
            if ("SIGN_OFF_PROGRESS".equalsIgnoreCase(fieldData.getType())) {
                field3 = this.approvalStateField(approvalStateFieldData, apiRequest.getLocale(), apiRequest.getDataId());
                layoutList.add(new UiBotLayout(field3.getSchema(), "FIELD"));
                pageData.put((Object)field3.getSchema(), (Object)field3);
                continue;
            }
            if ("FILE_UPLOAD".equalsIgnoreCase(fieldData.getType()) || "TASK_FILE_UPLOAD".equalsIgnoreCase(fieldData.getType())) {
                ArrayList dataList;
                Map dataMap;
                Attachment attachment = new Attachment();
                attachment.setTitle(fieldData.getLabel());
                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                if (fieldData.getData() != null && (dataMap = (Map)fieldData.getData()).get("data") != null && !CollectionUtils.isEmpty((Collection)(dataList = (ArrayList)dataMap.get("data")))) {
                    List fileList = dataList.stream().map(data -> {
                        String createDate;
                        AttachmentFile file = new AttachmentFile();
                        file.setFileId((String)data.get("id"));
                        if (data.get("size") instanceof Double) {
                            Double size = (Double)data.get("size");
                            file.setFileSize(Long.valueOf(size.longValue()));
                        } else if (data.get("size") instanceof Long) {
                            file.setFileSize((Long)data.get("size"));
                        } else if (data.get("size") instanceof String) {
                            file.setFileSize(Long.valueOf(Long.parseLong((String)data.get("size"))));
                        }
                        file.setUploader((String)data.get("upload_user_name"));
                        file.setFileName((String)data.get("name"));
                        String string = createDate = data.get("create_date") == null ? "" : String.valueOf(data.get("create_date"));
                        if (StringUtils.hasLength((String)createDate)) {
                            createDate = createDate.replaceAll("/", "-");
                        }
                        file.setUploadTime(createDate);
                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)((String)data.get("name"))));
                        return file;
                    }).collect(Collectors.toList());
                    attachment.setFileList(fileList);
                }
                layoutList.add(new UiBotLayout(fieldData.getSchema(), "ATTACHMENT"));
                pageData.put((Object)fieldData.getSchema(), (Object)attachment);
                continue;
            }
            field3 = Field.create((ParseFieldData)fieldData, (String)apiRequest.getLocale());
            if (field3 == null) continue;
            field3.setLabelStyleType(Integer.valueOf(2));
            field3.setValueStyleType(Integer.valueOf(1));
            field3.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
            layoutList.add(new UiBotLayout(field3.getSchema(), "FIELD"));
            pageData.put((Object)field3.getSchema(), (Object)field3);
        }
        return customGroupContent;
    }

    private Field convertTabItemCardContent(ParseFieldData fieldData) {
        if (fieldData == null || fieldData.getData() == null) {
            return null;
        }
        Field field = new Field();
        field.setLabel(fieldData.getLabel());
        field.setLabelStyleType(Integer.valueOf(2));
        field.setValueStyleType(Integer.valueOf(1));
        field.setSchema(fieldData.getSchema());
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        AtomicReference<Object> value = new AtomicReference<Object>(fieldData.getData());
        if (fieldData.getOptions() != null) {
            fieldData.getOptions().forEach(uiBotTableColumnEditorOption -> {
                if (value.get().equals(uiBotTableColumnEditorOption.getValue())) {
                    value.set(uiBotTableColumnEditorOption.getTitle());
                }
            });
        }
        field.setValue(value.get().toString());
        return field;
    }

    private Field approvalStateField(ParseFieldData fieldData, String locale, String dataId) {
        String approve;
        Field field = new Field();
        field.setLabel(fieldData.getLabel());
        field.setSchema(fieldData.getSchema());
        field.setLabelStyleType(Integer.valueOf(2));
        field.setValueStyleType(Integer.valueOf(1));
        Map valueMap = (Map)fieldData.getData();
        switch (approve = valueMap.get("approve").toString()) {
            case "3": {
                field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u7b7e\u6838"));
                break;
            }
            default: {
                field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7b7e\u6838\u4e2d"));
            }
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageTitle(fieldData.getLabel());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
        action.setRawData((Object)valueMap);
        action.setDataId(dataId);
        field.setAction(action);
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        return field;
    }

    private Field calculateTaskStatus(ParseFieldData fieldData, String locale) {
        int days;
        Map dataMap = (Map)fieldData.getData();
        String planEndTime = (String)dataMap.get("planEndTime");
        Boolean close = (Boolean)dataMap.get("closed");
        String endTime = (String)dataMap.get("endTime");
        String performerId = (String)dataMap.get("performerId");
        String performerName = (String)dataMap.get("performerName");
        Field field = new Field();
        field.setSchema(fieldData.getSchema());
        field.setLabelStyleType(Integer.valueOf(2));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        field.setLabel(fieldData.getLabel());
        if (close.booleanValue()) {
            if (DateTimeUtil.compareTime((String)endTime, (String)planEndTime).booleanValue()) {
                field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u5b8c\u6210"));
                field.setType("DONE");
            } else {
                days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)endTime);
                field.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u540e\u5b8c\u6210"), days));
                field.setType("OVERDUE_DONE");
            }
        } else if (!DateTimeUtil.isBeforeNowDateTime((String)planEndTime).booleanValue()) {
            field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5728\u8fdb\u884c"));
            field.setType("LOADING");
        } else {
            days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)DateTimeUtil.getTodayTimeUseDefaultPattern());
            field.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), days));
            field.setType("OVERDUE");
        }
        if (StringUtils.hasLength((String)performerName)) {
            BaseMobileComponentPerson person = new BaseMobileComponentPerson();
            person.setName(performerName);
            person.setUserId(performerId);
            field.setPerson(person);
        }
        return field;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

