/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.title.articletitle.ArticleTitle;
import com.digiwin.mobile.mobileuibot.core.component.title.articletitle.BaseArticleContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.DigiwinKbsService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildSearchItemDetailStrategy")
public class UiBotModelBuildSearchItemDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildSearchItemDetailStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinKbsService digiwinKbsService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String knowledgeId = (String)apiRequest.getRawData().get((Object)"knowledge_id");
        HashMap<String, String> knowledgeInfos = new HashMap<String, String>();
        knowledgeInfos.put("knowledge_id", knowledgeId);
        Map detailInfo = this.digiwinKbsService.getDetailInfo(knowledgeInfos, userToken, locale);
        stopWatch.start("Build PccTailTask Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        block12: for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "ARTICLE_TITLE": {
                    ArticleTitle articleTitle = ArticleTitle.create((String)locale, (String)userToken, (Map)detailInfo);
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)articleTitle);
                    break;
                }
                case "TEXT_MULTI": {
                    TextMulti description = TextMulti.create((String)locale, (String)userToken, (Map)detailInfo);
                    if (null == description.getValue() || !StringUtils.isNotEmpty((CharSequence)description.getValue())) break;
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)description);
                    break;
                }
                case "SWIPER": {
                    BaseImageContent content;
                    Swiper picture = Swiper.create((String)locale, (String)userToken, (Map)detailInfo);
                    if (picture.getContent().size() <= 0 || picture.getContent().size() == 1 && (null == (content = (BaseImageContent)JsonUtil.objectToJavaObject(picture.getContent().get(0), BaseImageContent.class)).getData() || !StringUtils.isNotEmpty((CharSequence)content.getData()))) break;
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)picture);
                    break;
                }
                case "ATTACHMENT": {
                    AttachmentFile attachmentFile;
                    if ("solution".equalsIgnoreCase(layout.getSchema())) {
                        Attachment solution = Attachment.createSolution((String)locale, (String)userToken, (Map)detailInfo);
                        if (solution.getFileList().size() <= 0) continue block12;
                        if (solution.getFileList().size() == 1 && (null == (attachmentFile = (AttachmentFile)JsonUtil.objectToJavaObject(solution.getFileList().get(0), AttachmentFile.class)).getShareUrl() || !StringUtils.isNotEmpty((CharSequence)attachmentFile.getShareUrl()))) break;
                        uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)solution);
                        break;
                    }
                    if (!"actualAttachment".equalsIgnoreCase(layout.getSchema())) break;
                    Attachment actualAttachment = Attachment.createActualAttachment((String)locale, (String)userToken, (Map)detailInfo);
                    if (actualAttachment.getFileList().size() <= 0) continue block12;
                    if (actualAttachment.getFileList().size() == 1 && (null == (attachmentFile = (AttachmentFile)JsonUtil.objectToJavaObject(actualAttachment.getFileList().get(0), AttachmentFile.class)).getShareUrl() || !StringUtils.isNotEmpty((CharSequence)attachmentFile.getShareUrl()))) break;
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)actualAttachment);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/mobile_athena_search_item_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
            ArticleTitle articleTitle = (ArticleTitle)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)"articleTitle"), ArticleTitle.class);
            BaseArticleContent minorContent = articleTitle.getMinorContent();
            int readNum = minorContent.getReadNum();
            minorContent.setReadNum(Integer.valueOf(++readNum));
            articleTitle.setMinorContent(minorContent);
            uiBotModel.getPageData().put((Object)"articleTitle", (Object)articleTitle);
        }
        return uiBotModel;
    }
}

