/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberList;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryData;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryDataField;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinOrderPriceData;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTbbReport;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mrs.model.Auxiliary;
import com.digiwin.mobile.mobileuibot.proxy.mrs.model.AuxiliaryInformationResponse;
import com.digiwin.mobile.mobileuibot.proxy.mrs.service.MrsService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.AttachmentViewTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchController;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelLeftSlipStrategy")
public class UiBotModelLeftSlipStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelLeftSlipStrategy.class);
    @Autowired
    private MrsService mrsService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private HttpService httpService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildLeftSlip");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        ApiRawData apiRawData = apiRequest.getRawData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch, useMockData.booleanValue(), modelTypeShow.booleanValue()) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, boolean useMockData, boolean modelTypeShow) {
        UiBotLayout areaLayout;
        UiBotModel uiBotModel = new UiBotModel(pageSetting.getPageModel().getLayout());
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        stopWatch.start("GetData From Athena API");
        ApiRawData params = apiRequest.getRawData();
        String dataId = (String)params.get("dataId");
        String tenantId = (String)params.get("tenant_id");
        apiRequest.setTenantId(tenantId);
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        HashMap<String, Object> informationParams = new HashMap<String, Object>(6);
        informationParams.put("tenant_id", tenantId);
        informationParams.put("user_id", apiRequest.getUserId());
        informationParams.put("transaction_id", params.get("transaction_id"));
        informationParams.put("transaction_code", params.get("transaction_code"));
        if (params.get("item_type") != null && StringUtils.hasLength((String)((String)params.get("item_type")))) {
            HashMap<String, String> taskCategory = new HashMap<String, String>(1);
            taskCategory.put("task_category", (String)params.get("item_type"));
            informationParams.put("transaction_information", taskCategory);
        }
        informationParams.put("timestamp", System.currentTimeMillis());
        informationParams.put("userToken", userToken);
        informationParams.put("locale", locale);
        ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>();
        AuxiliaryInformationResponse auxiliaryInformationResponse = this.mrsService.recommendedAuxiliaryInformation(informationParams);
        if (auxiliaryInformationResponse != null && auxiliaryInformationResponse.getAuxiliaryList() != null && auxiliaryInformationResponse.getAuxiliaryList().size() > 0) {
            block10: for (Auxiliary auxiliary : auxiliaryInformationResponse.getAuxiliaryList()) {
                for (UiBotLayout layout : pageSetting.getPageModel().getLayout()) {
                    if (auxiliary.getAuxiliaryCode().equals(layout.getSchema())) {
                        uiBotLayouts.add(layout);
                        continue block10;
                    }
                    if (!"area".equals(layout.getSchema())) continue;
                    UiBotLayout areaLayout2 = new UiBotLayout("area", "BLANK_AREA");
                    uiBotLayouts.add(areaLayout2);
                }
            }
        } else if ("PROJECT_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            UiBotLayout uiBotLayout = new UiBotLayout("pcc_itemAttribute_list", "CUSTOM_GROUP");
            uiBotLayouts.add(uiBotLayout);
            areaLayout = new UiBotLayout("area", "BLANK_AREA");
            uiBotLayouts.add(areaLayout);
            UiBotLayout boardLayout = new UiBotLayout("pcc_board_template", "CUSTOM_GROUP");
            uiBotLayouts.add(boardLayout);
        } else if ("INVENTORY_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            UiBotLayout boardLayout = new UiBotLayout("inventory_data", "CUSTOM_GROUP");
            uiBotLayouts.add(boardLayout);
            UiBotLayout abnormalReviewLayout = new UiBotLayout("abnormal_review", "CUSTOM_GROUP");
            uiBotLayouts.add(abnormalReviewLayout);
        } else if ("PURCHASE_ORDER.I01".equalsIgnoreCase(dataId)) {
            UiBotLayout historyPriceLayout = new UiBotLayout("erp_purchase_history_price", "CUSTOM_GROUP");
            uiBotLayouts.add(historyPriceLayout);
            areaLayout = new UiBotLayout("area", "BLANK_AREA");
            uiBotLayouts.add(areaLayout);
            UiBotLayout attachmentLayout = new UiBotLayout("erp_purchase_attachment", "CUSTOM_GROUP");
            uiBotLayouts.add(attachmentLayout);
        } else if ("uibotManualTask".equalsIgnoreCase(dataId)) {
            UiBotLayout baseInformationLayout = new UiBotLayout("pom_basic_information", "CUSTOM_GROUP");
            uiBotLayouts.add(baseInformationLayout);
            areaLayout = new UiBotLayout("area", "BLANK_AREA");
            uiBotLayouts.add(areaLayout);
            UiBotLayout orderStatusLayout = new UiBotLayout("pom_order_status", "CUSTOM_GROUP");
            uiBotLayouts.add(orderStatusLayout);
            UiBotLayout areaLayout1 = new UiBotLayout("area", "BLANK_AREA");
            uiBotLayouts.add(areaLayout1);
            UiBotLayout accountsReceivableLayout = new UiBotLayout("pom_accounts_receivable", "CUSTOM_GROUP");
            uiBotLayouts.add(accountsReceivableLayout);
        }
        if (uiBotLayouts.size() == 0) {
            return this.emptyUibotModel(apiRequest.getLocale());
        }
        boolean isOfficialCustomer = false;
        ArrayList<UiBotLayout> removeUiBotLayouts = new ArrayList<UiBotLayout>(2);
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "SMART_PRECISE_SEARCH": {
                    List cardInfoRequests = (List)params.get("card_info");
                    if (cardInfoRequests == null || cardInfoRequests.size() == 0) {
                        return this.emptyUibotModel(apiRequest.getLocale());
                    }
                    for (Map param : cardInfoRequests) {
                        param.put("cad_type", "0");
                        param.put("is_select_all_version", true);
                    }
                    List cardInfoResponses = this.digiwinEspProxyService.getCardInfo(cardInfoRequests, apiRequest.getIamUserToken(), tenantId, apiRequest.getLocale());
                    if (cardInfoResponses == null || cardInfoResponses.size() == 0) {
                        return this.emptyUibotModel(apiRequest.getLocale());
                    }
                    UiBotPageData pageData = this.buildPageData(auxiliaryInformationResponse, uiBotLayout, cardInfoResponses, apiRequest);
                    if (pageData == null) break;
                    uiBotModel.addPageData(uiBotLayout.getSchema(), pageData.get((Object)uiBotLayout.getSchema()));
                    break;
                }
                case "CUSTOM_GROUP": {
                    String customerNo;
                    CustomGroup customGroup;
                    if ("pcc_itemAttribute_list".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        List humanResourceLoadList;
                        List itemInfo = (List)params.get("item_info");
                        customGroup = itemInfo == null || itemInfo.size() < 1 ? CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7a7a\u4f59\u4ea7\u80fd"), (UiBotModel)this.emptyUibotModel(apiRequest.getLocale())) : ((humanResourceLoadList = this.digiwinEspProxyService.getHumanResourceLoadByDateId(itemInfo, "0", tenantId, locale, userToken)) == null || humanResourceLoadList.size() < 1 ? CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7a7a\u4f59\u4ea7\u80fd"), (UiBotModel)this.emptyUibotModel(apiRequest.getLocale())) : this.buildCustomSlipModel(auxiliaryInformationResponse, uiBotLayout, uiBotPageData, apiRequest, humanResourceLoadList));
                    } else if ("pcc_board_template".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        String projectNo = (String)params.get("project_no");
                        String projectName = (String)params.get("project_name");
                        customGroup = this.buildBoardCustomGroup(uiBotLayout, uiBotPageData, projectNo, projectName, userToken, apiRequest.getLocale());
                    } else if ("inventory_data".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        String purchaseNo = (String)params.get("purchase_no");
                        String itemNo = (String)params.get("item_no");
                        String itemName = (String)params.get("item_name_spec");
                        String eocCompanyId = (String)params.get("eoc_company_id");
                        if (!StringUtils.hasLength((String)purchaseNo) || !StringUtils.hasLength((String)itemNo)) break;
                        customGroup = this.buildInventoryCustomGroup(uiBotLayout, uiBotPageData, purchaseNo, itemNo, itemName, userToken, tenantId, eocCompanyId, apiRequest.getLocale());
                    } else if ("abnormal_review".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        String taskNo = (String)params.get("task_no");
                        String projectNo = (String)params.get("project_no");
                        customGroup = this.buildAbnormalReviewCustomGroup(uiBotLayout, uiBotPageData, taskNo, projectNo, apiRequest);
                    } else if ("erp_purchase_history_price".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        List itemCodeList = (List)params.get("item_code_list");
                        customGroup = this.buildHistoryPriceCustomGroup(itemCodeList, uiBotLayout, uiBotPageData, userToken, tenantId, apiRequest.getLocale());
                    } else if ("erp_purchase_attachment".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        List attachmentList = new ArrayList();
                        if (params.get("attachment") != null) {
                            attachmentList = (List)params.get("attachment");
                        }
                        Map attribute = Optional.ofNullable((Map)params.get("attribute")).orElse(new HashMap());
                        customGroup = attachmentList == null || attachmentList.size() == 0 ? CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u9644\u4ef6"), (UiBotModel)this.emptyUibotModel(apiRequest.getLocale())) : this.buildAttachmentCustomGroup(uiBotLayout, uiBotPageData, attachmentList, attribute, apiRequest.getLocale());
                    } else if ("pom_basic_information".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        Boolean moduleEnable = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(tenantId, apiRequest.getUserId(), "POM", "basicDataEntry", apiRequest.getIamUserToken());
                        if (moduleEnable.booleanValue()) {
                            String customerNo2 = (String)params.get("customer_no");
                            if (!StringUtils.hasLength((String)customerNo2)) {
                                customGroup = CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u57fa\u7840\u8d44\u6599"), (UiBotModel)this.emptyUibotModel(apiRequest.getLocale()));
                            } else {
                                Map digiwinCustomerInfo;
                                String customerProperty;
                                ArrayList<String> customerNos = new ArrayList<String>(1);
                                customerNos.add(customerNo2);
                                List digiwinCustomerInfos = this.digiwinEspProxyService.getCustomerInfoByNo(customerNos, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
                                if (digiwinCustomerInfos != null && digiwinCustomerInfos.size() > 0 && "2".equals(customerProperty = (String)(digiwinCustomerInfo = (Map)digiwinCustomerInfos.get(0)).get("customer_property"))) {
                                    isOfficialCustomer = true;
                                }
                                customGroup = this.buildBasicInformationCustomGroup(uiBotLayout, uiBotPageData, digiwinCustomerInfos, apiRequest, isOfficialCustomer);
                            }
                        } else {
                            isOfficialCustomer = false;
                            customGroup = CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u57fa\u7840\u8d44\u6599"), (UiBotModel)this.noAccessUibotModel(apiRequest.getLocale()));
                        }
                    } else if ("pom_accounts_receivable".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        if (!isOfficialCustomer) {
                            removeUiBotLayouts.add(uiBotLayout);
                            break;
                        }
                        customerNo = (String)params.get("customer_no");
                        customGroup = this.buildAccountsReceivableCustomGroup(uiBotLayout, uiBotPageData, customerNo, apiRequest);
                    } else if ("pom_order_status".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        if (!isOfficialCustomer) {
                            removeUiBotLayouts.add(uiBotLayout);
                            break;
                        }
                        customerNo = (String)params.get("customer_no");
                        String customerName = params.getString("customer_name");
                        customGroup = this.buildOrderStatusCustomGroup(uiBotLayout, uiBotPageData, customerName, apiRequest);
                    } else {
                        customGroup = CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7a7a\u4f59\u4ea7\u80fd"), (UiBotModel)this.emptyUibotModel(apiRequest.getLocale()));
                    }
                    uiBotModel.addPageData(uiBotLayout.getSchema(), (Object)customGroup);
                    break;
                }
                case "BLANK_AREA": {
                    uiBotModel.addPageData(uiBotLayout.getSchema(), uiBotPageData.get((Object)uiBotLayout.getSchema()));
                    break;
                }
            }
        }
        uiBotLayouts.removeAll(removeUiBotLayouts);
        stopWatch.stop();
        uiBotModel.setPageType(pageSetting.getPageModel().getPageType());
        uiBotModel.setLayout(uiBotLayouts);
        return uiBotModel;
    }

    private CustomGroup buildAbnormalReviewCustomGroup(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData, String taskNo, String projectNo, ApiRequest apiRequest) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uiBotPageData.get((Object)uiBotLayout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        ArrayList<UiBotLayout> contentLayouts = new ArrayList<UiBotLayout>();
        UiBotPageData pageData = uiBotModel.getPageData();
        ArrayList docInfos = new ArrayList(1);
        ArrayList projectInfos = new ArrayList(1);
        HashMap<String, Object> docInfo = new HashMap<String, Object>(2);
        docInfo.put("project_no", projectNo);
        HashMap<String, String> projectInfo = new HashMap<String, String>(2);
        projectInfo.put("project_no", projectNo);
        projectInfo.put("task_no", taskNo);
        projectInfos.add(projectInfo);
        docInfo.put("project_info", projectInfos);
        docInfos.add(docInfo);
        List abnormalReviewInfo = this.digiwinEspProxyService.getAbnormalReviewInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), docInfos);
        if (abnormalReviewInfo != null && abnormalReviewInfo.size() > 0) {
            List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(uiBotLayout.getSchema(), apiRequest.getPageId());
            List titleTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(uiBotLayout.getSchema()) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
            List importantColumnTags = columnTagList.stream().filter(ct -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode().equalsIgnoreCase(ct.getTagDefinition().getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
            ArrayList<String> titleSchemas = new ArrayList<String>(titleTagList.size());
            String importantSchema = ((ColumnTag)importantColumnTags.get(0)).getSchema();
            for (ColumnTag tag2 : titleTagList) {
                titleSchemas.add(tag2.getSchema());
            }
            for (Map data : abnormalReviewInfo) {
                UiBotLayout contentLayout = new UiBotLayout();
                String schema = UUIDUtil.getUuid();
                contentLayout.setSchema(schema);
                contentLayout.setType("CUSTOM_GROUP");
                ArrayList<UiBotLayout> mobileLayouts = new ArrayList<UiBotLayout>(uiBotLayouts.size());
                CustomGroup customGroupItem = new CustomGroup();
                customGroupItem.setUseExpand(Boolean.valueOf(false));
                customGroupItem.setHiddenConfig(new HiddenConfig());
                customGroupItem.setHasDetail(Boolean.valueOf(false));
                customGroupItem.setName("");
                customGroupItem.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_BORDERED.getValue());
                CustomGroupContent contentItem = new CustomGroupContent();
                UiBotPageData pageDataItem = new UiBotPageData();
                String titleVale = "";
                String importValue = "";
                for (UiBotLayout layout : uiBotLayouts) {
                    UiBotLayout mobileLayout = new UiBotLayout();
                    switch (layout.getType()) {
                        case "FIELD": {
                            if (titleSchemas.contains(layout.getSchema())) {
                                titleVale = titleVale + this.dealEmptyString(data.get(layout.getSchema()));
                                break;
                            }
                            if (importantSchema.equalsIgnoreCase(layout.getSchema())) {
                                importValue = this.dealEmptyString(data.get(importantSchema));
                                mobileLayout.setSchema(layout.getSchema());
                                mobileLayout.setType(layout.getType());
                                break;
                            }
                            mobileLayout.setSchema(layout.getSchema());
                            mobileLayout.setType(layout.getType());
                            pageDataItem.put((Object)layout.getSchema(), (Object)Field.create((String)((String)layout.getmLabelText().get(apiRequest.getLocale())), (String)this.dealEmptyString(data.get(layout.getSchema())), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, (Boolean)false));
                            break;
                        }
                    }
                    if (mobileLayout.getSchema() == null) continue;
                    mobileLayouts.add(mobileLayout);
                }
                pageDataItem.put((Object)importantSchema, (Object)Field.create((String)titleVale, (String)importValue, (Integer)1, (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX, (Boolean)false));
                contentItem.setLayout(mobileLayouts);
                contentItem.setPageData(pageDataItem);
                customGroupItem.setContent(contentItem);
                contentLayouts.add(contentLayout);
                pageData.put((Object)schema, (Object)customGroupItem);
            }
        } else {
            UiBotModel emptyModel = this.emptyUibotModel(apiRequest.getLocale());
            content.setLayout(emptyModel.getLayout());
            content.setPageData(emptyModel.getPageData());
            return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5f02\u5e38\u56de\u62a5"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)content);
        }
        content.setLayout(contentLayouts);
        content.setPageData(pageData);
        customGroup.setContent(content);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        customGroup.setHasDetail(Boolean.valueOf(false));
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5f02\u5e38\u56de\u62a5"));
        customGroup.setUseExpand(Boolean.valueOf(true));
        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(Integer.valueOf(3));
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u67e5\u770b\u66f4\u591a"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6536\u8d77"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.ENTRY.getValue());
        customGroup.setHiddenConfig(hiddenConfig);
        return customGroup;
    }

    private CustomGroup buildOrderStatusCustomGroup(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData, String customerName, ApiRequest apiRequest) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uiBotPageData.get((Object)uiBotLayout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        List kgTbbReports = this.digiwinKnowledgeMapsProxyService.getTbbReports(apiRequest.getIamUserToken(), apiRequest.getLocale(), "POM");
        if (kgTbbReports == null || kgTbbReports.size() == 0) {
            UiBotModel emptyModel = this.emptyUibotModel(apiRequest.getLocale());
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8ba2\u5355\u72b6\u51b5"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "WEBVIEW": {
                    Webview tbbWebview = new Webview();
                    try {
                        tbbWebview = KnowledgeMapsTbbReport.buildBoardWebview((KnowledgeMapsTbbReport)((KnowledgeMapsTbbReport)kgTbbReports.get(0)), (String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    Webview webview = (Webview)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uiBotModel.getPageData().get((Object)layout.getSchema())), Webview.class);
                    webview.setUrl(UrlUtil.urlEncodeChinese((String)(tbbWebview.getUrl() + "&inputCost_projectId=" + customerName + "&is_global_filter=2")));
                    webview.getButtonList().add(webview.createLeftSlipOpenWindowButton());
                    pageData.put((Object)layout.getSchema(), (Object)webview);
                    break;
                }
            }
        }
        customGroupContent.setPageData(pageData);
        return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8ba2\u5355\u72b6\u51b5"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
    }

    private CustomGroup buildAccountsReceivableCustomGroup(UiBotLayout layout, UiBotPageData pageData, String customerNo, ApiRequest apiRequest) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5e94\u6536\u8d26\u6b3e"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        ArrayList<String> customerNos = new ArrayList<String>(1);
        customerNos.add(customerNo);
        List digiwinCustomerInfos = this.digiwinEspProxyService.getCustomerInfoByNo(customerNos, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (digiwinCustomerInfos == null || digiwinCustomerInfos.size() == 0) {
            UiBotModel emptyModel = this.emptyUibotModel(apiRequest.getLocale());
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            customGroup.setContent(customGroupContent);
            customGroup.setUseExpand(Boolean.valueOf(false));
            customGroup.setHiddenConfig(new HiddenConfig());
            return customGroup;
        }
        Map digiwinCustomerInfo = (Map)digiwinCustomerInfos.get(0);
        List digiwinReceivables = this.digiwinEspProxyService.getReceivableByNo(customerNos, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), (String)digiwinCustomerInfo.get("eoc_company_id"));
        if (digiwinReceivables == null || digiwinReceivables.size() == 0) {
            UiBotModel emptyModel = this.emptyUibotModel(apiRequest.getLocale(), LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5e94\u6536\u8d26\u6b3e"));
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            customGroup.setContent(customGroupContent);
            customGroup.setHiddenConfig(new HiddenConfig());
            customGroup.setUseExpand(Boolean.valueOf(false));
            return customGroup;
        }
        UiBotLayout contentLayout = (UiBotLayout)uiBotLayouts.get(0);
        UiBotPageData contentPageData = uiBotModel.getPageData();
        UiBotModel contentUiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contentPageData.get((Object)contentLayout.getSchema())), UiBotModel.class);
        List contentUiBotLayouts = contentUiBotModel.getLayout();
        ArrayList<String> months = new ArrayList<String>();
        HashMap monthReceivable = new HashMap();
        digiwinReceivables.sort((d1, d2) -> {
            LocalDate d2Date;
            String fieldUseToCompare = contentLayout.getSchema();
            LocalDate d1Date = DateTimeUtil.parseLocalDateUseDefaultPattern((String)String.valueOf(d1.get(fieldUseToCompare)));
            if (d1Date.isBefore(d2Date = DateTimeUtil.parseLocalDateUseDefaultPattern((String)String.valueOf(d2.get(fieldUseToCompare))))) {
                return 1;
            }
            if (d1Date.isEqual(d2Date)) {
                return 0;
            }
            return -1;
        });
        for (Map digiwinReceivable : digiwinReceivables) {
            HashMap<String, Double> params;
            String month = DateTimeUtil.getYearMonthOfTime((String)((String)digiwinReceivable.get(contentLayout.getSchema()) + " 00:00:00"));
            if (!months.contains(month)) {
                months.add(month);
            }
            if (monthReceivable.keySet().contains(month)) {
                params = (HashMap<String, Double>)monthReceivable.get(month);
                for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                    Double schema = (Double)digiwinReceivable.get(uiBotLayout.getSchema());
                    Double oldSchema = (Double)params.get(uiBotLayout.getSchema());
                    params.put(uiBotLayout.getSchema(), schema + oldSchema);
                }
                monthReceivable.put(month, params);
                continue;
            }
            params = new HashMap<String, Double>(2);
            for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                params.put(uiBotLayout.getSchema(), (Double)digiwinReceivable.get(uiBotLayout.getSchema()));
            }
            monthReceivable.put(month, params);
        }
        ArrayList<UiBotLayout> middleLayouts = new ArrayList<UiBotLayout>(months.size());
        UiBotLayout areaLayout = new UiBotLayout("area", "BLANK_AREA");
        for (String month : months) {
            UiBotLayout middleLayout = new UiBotLayout();
            CustomGroup childCustomGroup = new CustomGroup();
            childCustomGroup.setHiddenConfig(new HiddenConfig());
            childCustomGroup.setName(month);
            childCustomGroup.setUseExpand(Boolean.valueOf(false));
            childCustomGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_INCLUDE_TITLE_BORDERED.getValue());
            CustomGroupContent customGroupContent1 = new CustomGroupContent();
            Map params = (Map)monthReceivable.get(month);
            ArrayList<UiBotLayout> uiBotLayoutList = new ArrayList<UiBotLayout>();
            UiBotPageData pageData1 = new UiBotPageData();
            for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                String newSchema = uiBotLayout.getSchema() + UUIDUtil.getUuid();
                switch (uiBotLayout.getType()) {
                    case "FIELD": {
                        pageData1.put((Object)newSchema, (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(apiRequest.getLocale())), (String)String.valueOf(params.get(uiBotLayout.getSchema())), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                        break;
                    }
                }
                UiBotLayout newUibotLayOut = new UiBotLayout();
                newUibotLayOut.setSchema(newSchema);
                newUibotLayOut.setType(uiBotLayout.getType());
                newUibotLayOut.setmLabelText(uiBotLayout.getmLabelText());
                uiBotLayoutList.add(newUibotLayOut);
            }
            customGroupContent1.setLayout(uiBotLayoutList);
            customGroupContent1.setPageData(pageData1);
            childCustomGroup.setContent(customGroupContent1);
            String middleSchema = UUIDUtil.getUuid();
            middleLayout.setSchema(middleSchema);
            middleLayout.setType("CUSTOM_GROUP");
            middleLayouts.add(middleLayout);
            middleLayouts.add(areaLayout);
            uiBotPageData.put((Object)middleSchema, (Object)childCustomGroup);
            uiBotPageData.put((Object)"area", contentPageData.get((Object)"area"));
        }
        customGroupContent.setLayout(middleLayouts);
        customGroupContent.setPageData(uiBotPageData);
        customGroup.setContent(customGroupContent);
        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(Integer.valueOf(3));
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u67e5\u770b\u66f4\u591a"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6536\u8d77"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.ENTRY.getValue());
        customGroup.setHiddenConfig(hiddenConfig);
        customGroup.setUseExpand(Boolean.valueOf(true));
        hiddenConfig.setAction(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5e94\u6536\u8d26\u6b3e"), ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return customGroup;
    }

    private CustomGroup buildBasicInformationCustomGroup(UiBotLayout layout, UiBotPageData pageData, List<Map<String, Object>> digiwinCustomerInfos, ApiRequest request, boolean isOfficialCustomer) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u57fa\u7840\u8d44\u6599"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_BORDERED.getValue());
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        if (digiwinCustomerInfos == null || digiwinCustomerInfos.size() == 0) {
            UiBotModel emptyModel = this.emptyUibotModel(request.getLocale(), LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u57fa\u7840\u8d44\u6599"));
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            customGroup.setContent(customGroupContent);
            customGroup.setUseExpand(Boolean.valueOf(false));
            customGroup.setHiddenConfig(new HiddenConfig());
            return customGroup;
        }
        Map<String, Object> digiwinCustomerInfo = digiwinCustomerInfos.get(0);
        block8: for (UiBotLayout uiBotLayout : uiBotLayouts) {
            block4 : switch (uiBotLayout.getType()) {
                case "FIELD": {
                    if (uiBotLayout.getSchema().contains(".")) {
                        String[] schemas = uiBotLayout.getSchema().split("\\.");
                        Map params = new HashMap();
                        for (String schema : schemas) {
                            if (!(digiwinCustomerInfo.get(schema) instanceof Map)) {
                                if (digiwinCustomerInfo.get(schema) == null) {
                                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(request.getLocale())), (String)"", (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                                    break block4;
                                }
                                uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(request.getLocale())), (String)((String)params.get(schema)), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                                break block4;
                            }
                            params = (Map)digiwinCustomerInfo.get(schema);
                        }
                        continue block8;
                    }
                    if ("customer_property".equals(uiBotLayout.getSchema())) {
                        if ("1".equals(digiwinCustomerInfo.get(uiBotLayout.getSchema()))) {
                            uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(request.getLocale())), (String)LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u6f5c\u5728"), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                            break;
                        }
                        uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(request.getLocale())), (String)LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u6b63\u5f0f"), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                        break;
                    }
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Field.create((String)((String)uiBotLayout.getmLabelText().get(request.getLocale())), (String)((String)digiwinCustomerInfo.get(uiBotLayout.getSchema())), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, (Boolean)false));
                    break;
                }
                case "PICTURE": {
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)Picture.createStaticPic((String)uiBotLayout.getSchema()));
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        customGroup.setContent(customGroupContent);
        if (isOfficialCustomer) {
            customGroup.setUseExpand(Boolean.valueOf(true));
        } else {
            customGroup.setUseExpand(Boolean.valueOf(false));
        }
        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(Integer.valueOf(6));
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u67e5\u770b\u66f4\u591a"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u6536\u8d77"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.FIELD.getValue());
        hiddenConfig.setAction(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u57fa\u7840\u8d44\u6599"), ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
        customGroup.setHiddenConfig(hiddenConfig);
        return customGroup;
    }

    private CustomGroup buildAttachmentCustomGroup(UiBotLayout layout, UiBotPageData pageData, List<Map<String, Object>> attachmentList, Map<String, Object> attribute, String locale) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "ATTACHMENT": {
                    Attachment attachment = new Attachment();
                    attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                    ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
                    attachment.setFileList(fileList);
                    for (Map<String, Object> attachmentMap : attachmentList) {
                        AttachmentFile file = new AttachmentFile();
                        file.setFileId((String)attachmentMap.get("id"));
                        file.setFileName((String)attachmentMap.get("name"));
                        if (attachmentMap.get("size") != null) {
                            file.setFileSize(Long.valueOf(Long.parseLong(attachmentMap.get("size").toString())));
                        }
                        file.setUploader((String)attachmentMap.get("upload_user_name"));
                        String createData = (String)attachmentMap.get("create_date");
                        if (StringUtils.hasLength((String)createData)) {
                            createData = createData.replaceAll("/", "-");
                        }
                        file.setUploadTime(createData);
                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)((String)attachmentMap.get("name"))));
                        file.setViewable(Boolean.valueOf(true));
                        String type = (String)attribute.get("type");
                        if (AttachmentViewTypeEnum.OUTER.name().equals(type)) {
                            file.setShareUrl((String)attachmentMap.get("url"));
                        } else if (AttachmentViewTypeEnum.ERP.name().equals(type)) {
                            file.setViewable(Boolean.valueOf(false));
                        }
                        fileList.add(file);
                    }
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)attachment);
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9644\u4ef6"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
    }

    private CustomGroup buildHistoryPriceCustomGroup(List<String> itemCodeList, UiBotLayout layout, UiBotPageData pageData, String userToken, String tenantId, String locale) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "NUMBER_LIST": {
                    List orderPriceDataList = new ArrayList();
                    if (!CollectionUtils.isEmpty(itemCodeList)) {
                        orderPriceDataList = this.digiwinEspProxyService.getLatelyPriceListByItemCode(itemCodeList, userToken, tenantId, locale);
                    }
                    NumberList numberList = new NumberList();
                    numberList.setTitle(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u672c\u6b21\u91c7\u8d2d\u5b58\u5728\u5355\u4ef7\u5f02\u5e38\u7269\u6599\u5171n\u9879"), Optional.ofNullable(itemCodeList).map(List::size).orElse(0)));
                    numberList.setMorePageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5386\u53f2\u5355\u4ef7"));
                    numberList.setDisplayDataNum(Integer.valueOf(3));
                    numberList.setShowCategoryTitle(Boolean.valueOf(false));
                    ArrayList<NumberListCategory> categoryList = new ArrayList<NumberListCategory>();
                    numberList.setCategoryList(categoryList);
                    NumberListCategory category = new NumberListCategory();
                    categoryList.add(category);
                    category.setCategoryTitle("");
                    category.setCategoryName("");
                    category.setDefaultSelect(Boolean.valueOf(true));
                    category.setNumber(Double.valueOf(0.0));
                    category.setEmptyPromptText(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u5386\u53f2\u5355\u4ef7"));
                    ArrayList<NumberListCategoryData> dataList = new ArrayList<NumberListCategoryData>();
                    category.setData(dataList);
                    if (!CollectionUtils.isEmpty(orderPriceDataList)) {
                        for (DigiwinOrderPriceData priceData : orderPriceDataList) {
                            NumberListCategoryDataField field;
                            NumberListCategoryData data = new NumberListCategoryData();
                            dataList.add(data);
                            data.setTitle(priceData.getItemName());
                            ArrayList<NumberListCategoryDataField> fields = new ArrayList<NumberListCategoryDataField>();
                            data.setFields(fields);
                            if (StringUtils.hasLength((String)priceData.getItemSpec())) {
                                field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u89c4\u683c"));
                                field.setValue(priceData.getItemSpec());
                                fields.add(field);
                            }
                            if (priceData.getPurchasePrice() != null) {
                                field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6700\u8fd1\u91c7\u8d2d\u5355\u4ef7"));
                                field.setValue(String.valueOf(priceData.getPurchasePrice()));
                                fields.add(field);
                            }
                            if (StringUtils.hasLength((String)priceData.getSupplierName())) {
                                field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4f9b\u5e94\u5546"));
                                field.setValue(priceData.getSupplierName());
                                fields.add(field);
                            }
                            if (!StringUtils.hasLength((String)priceData.getPurchaseDate())) continue;
                            field = new NumberListCategoryDataField();
                            field.setLabel(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u91c7\u4e70\u65e5\u671f"));
                            field.setValue(priceData.getPurchaseDate());
                            fields.add(field);
                        }
                    }
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)numberList);
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5386\u53f2\u5355\u4ef7"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
    }

    private CustomGroup buildInventoryCustomGroup(UiBotLayout layout, UiBotPageData pageData, String purchaseNo, String itemNo, String itemName, String userToken, String tenantId, String eocCompanyId, String locale) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "NUMBER_LIST": {
                    NumberList numberList = new NumberList();
                    numberList.setTitle(itemName);
                    numberList.setMorePageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7269\u6599\u5e93\u5b58"));
                    numberList.setDisplayDataNum(Integer.valueOf(3));
                    String eocSiteId = this.digiwinEspProxyService.getEocSiteIdByPurchaseNo(purchaseNo, eocCompanyId, userToken, tenantId, locale);
                    List itemCategoryList = this.digiwinEspProxyService.getCategoryByItemNo(itemNo, eocCompanyId, userToken, tenantId, locale);
                    List inventoryDataList = this.digiwinEspProxyService.getInventoryByCategory(eocSiteId, itemCategoryList, eocCompanyId, userToken, tenantId, locale);
                    List categoryList = itemCategoryList.stream().map(itemCategory -> {
                        NumberListCategory category = new NumberListCategory();
                        category.setCategoryName(itemCategory.getClassificationMethodName());
                        category.setCategoryTitle("\u201c" + itemCategory.getCategoryName() + "\u201d" + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5e93\u5b58\u603b\u6570\u91cf") + ":");
                        category.setDefaultSelect(Boolean.valueOf(false));
                        category.setEmptyPromptText(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u7269\u6599\u5e93\u5b58"));
                        String categoryNo = itemCategory.getCategoryNo();
                        AtomicReference<Double> number = new AtomicReference<Double>(0.0);
                        List numberListCategoryDataList = inventoryDataList.stream().filter(inventoryData -> categoryNo.equalsIgnoreCase(inventoryData.getCategoryNo())).map(inventoryData -> {
                            NumberListCategoryData categoryData = new NumberListCategoryData();
                            categoryData.setTitle(inventoryData.getWarehouseName());
                            NumberListCategoryDataField field = new NumberListCategoryDataField();
                            field.setLabel(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5e93\u5b58\u603b\u6570"));
                            ArrayList<NumberListCategoryDataField> fields = new ArrayList<NumberListCategoryDataField>();
                            fields.add(field);
                            categoryData.setFields(fields);
                            field.setValue(inventoryData.getInventoryQty().toString());
                            number.updateAndGet(v -> v + inventoryData.getInventoryQty());
                            return categoryData;
                        }).collect(Collectors.toList());
                        category.setData(numberListCategoryDataList);
                        category.setNumber(number.get());
                        return category;
                    }).collect(Collectors.toList());
                    if (categoryList != null && !categoryList.isEmpty()) {
                        ((NumberListCategory)categoryList.get(0)).setDefaultSelect(Boolean.valueOf(true));
                    }
                    numberList.setCategoryList(categoryList);
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)numberList);
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7269\u6599\u5e93\u5b58"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
    }

    private CustomGroup buildBoardCustomGroup(UiBotLayout layout, UiBotPageData pageData, String projectNo, String projectName, String userToken, String locale) {
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)layout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "WEBVIEW": {
                    Webview webview = (Webview)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uiBotModel.getPageData().get((Object)uiBotLayout.getSchema())), Webview.class);
                    String url = AppContext.getApiUrlSetting().getTbbWebUrl() + webview.getUrl().replace("${token}", userToken).replace("${project_no}", projectNo != null ? projectNo : "").replace("${project_name}", projectName != null ? projectName : "").replace("${locale}", locale);
                    webview.setUrl(UrlUtil.urlEncodeChinese((String)(url + "&is_global_filter=1")));
                    webview.getButtonList().add(webview.createLeftSlipOpenWindowButton());
                    uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)webview);
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6295\u5165\u6210\u672c"), (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, (CustomGroupContent)customGroupContent);
    }

    private UiBotModel emptyUibotModel(String locale) {
        ArrayList<UiBotLayout> uiBotLayoutList = new ArrayList<UiBotLayout>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType("EMPTY");
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put((Object)"emptyData", (Object)Empty.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u6570\u636e"), (boolean)true));
        logger.error("\u672a\u627e\u5230\u76f8\u5173\u5206\u7c7b\u3002\u3002\u3002");
        return uiBotModel1;
    }

    private UiBotModel emptyUibotModel(String locale, String categoryName) {
        ArrayList<UiBotLayout> uiBotLayoutList = new ArrayList<UiBotLayout>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType("EMPTY");
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put((Object)"emptyData", (Object)Empty.create((String)(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u6570\u636e") + categoryName), (boolean)true));
        logger.error("\u672a\u627e\u5230\u76f8\u5173\u5206\u7c7b\u3002\u3002\u3002");
        return uiBotModel1;
    }

    private UiBotModel noAccessUibotModel(String locale) {
        ArrayList<UiBotLayout> uiBotLayoutList = new ArrayList<UiBotLayout>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType("EMPTY");
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put((Object)"emptyData", (Object)Empty.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u672a\u5f00\u542f\u5e94\u7528\u6743\u9650\uff0c\u8bf7\u5230\u9f0e\u6377\u4e91\u5f00\u542f"), (boolean)true));
        logger.error("\u672a\u5f00\u542f\u5e94\u7528\u6743\u9650\uff0c\u8bf7\u5230\u9f0e\u6377\u4e91\u5f00\u542f");
        return uiBotModel1;
    }

    private CustomGroup buildCustomSlipModel(AuxiliaryInformationResponse auxiliaryInformationResponse, UiBotLayout uiBotLayout, UiBotPageData pageData, ApiRequest apiRequest, List<Map<String, Object>> humanResourceLoadList) {
        CustomGroup customGroup = new CustomGroup();
        UiBotModel uiBotModel = (UiBotModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageData.get((Object)uiBotLayout.getSchema())), UiBotModel.class);
        List uiBotLayouts = uiBotModel.getLayout();
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7a7a\u4f59\u4ea7\u80fd"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout1 : uiBotLayouts) {
            switch (uiBotLayout1.getType()) {
                case "TABLE": {
                    Table classTable = Table.create((UiBotLayout)uiBotLayout1, (UiBotPageData)uiBotModel.getPageData(), humanResourceLoadList, (String)apiRequest.getLocale(), (String)"0");
                    if (classTable.getRows() == null || classTable.getRows().size() < 1) {
                        UiBotModel emptyModel = this.emptyUibotModel(apiRequest.getLocale());
                        customGroupContent.setLayout(emptyModel.getLayout());
                        customGroupContent.setPageData(emptyModel.getPageData());
                        customGroup.setContent(customGroupContent);
                        return customGroup;
                    }
                    uiBotPageData.put((Object)uiBotLayout1.getSchema(), (Object)classTable);
                    break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        customGroup.setContent(customGroupContent);
        return customGroup;
    }

    private UiBotPageData buildPageData(AuxiliaryInformationResponse auxiliaryInformationResponse, UiBotLayout uiBotLayout, List<Map<String, Object>> cardInfoResponses, ApiRequest apiRequest) {
        if (cardInfoResponses == null || cardInfoResponses.size() < 1) {
            return null;
        }
        Map oldPageData = new HashMap();
        List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId("cad_info", apiRequest.getPageId());
        List profileTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List picTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PIC.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        ArrayList<SmartPreciseSearch> smartPreciseSearches = new ArrayList<SmartPreciseSearch>();
        for (Map<String, Object> cardInfoResponse : cardInfoResponses) {
            Object columnTag2;
            SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
            ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>();
            for (Object columnTag2 : profileTagList) {
                SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                searchField.setFieldId(columnTag2.getSchema());
                searchField.setFieldTitle((String)columnTag2.getmLabelText().get(apiRequest.getLocale()));
                searchField.setFieldValue((String)cardInfoResponse.get(columnTag2.getSchema()));
                searchField.setFieldLayoutType(Integer.valueOf(columnTag2.getParallel() != false ? 2 : 1));
                searchField.setSkip(columnTag2.getSkip());
                searchField.setSkipConfig(new SkipConfig());
                fields.add(searchField);
            }
            smartPreciseSearch.setFields(fields);
            smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
            ArrayList<Pic> pics = new ArrayList<Pic>(1);
            columnTag2 = picTagList.iterator();
            while (columnTag2.hasNext()) {
                ColumnTag columnTag3 = (ColumnTag)columnTag2.next();
                Pic pic = new Pic();
                pic.setPicUrl((String)cardInfoResponse.get(columnTag3.getSchema()));
                pics.add(pic);
            }
            smartPreciseSearch.setPics(pics);
            smartPreciseSearch.setDataKey((String)cardInfoResponse.get("graph_no"));
            smartPreciseSearches.add(smartPreciseSearch);
        }
        if (smartPreciseSearches.size() == 0) {
            return null;
        }
        SearchController searchController = new SearchController();
        oldPageData = searchController.buildModel(smartPreciseSearches, null, "\u5171${count}\u9879", "${count}", Boolean.valueOf(true), "ddc_itemAttribute_list");
        List datas = (List)oldPageData.get("contentList");
        if (datas != null && datas.size() > 0) {
            for (Map data : datas) {
                Map action = (Map)((Map)data.get("data")).get("action");
                action.put("type", ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                HashMap<String, List<Map<String, Object>>> rawData = (HashMap<String, List<Map<String, Object>>>)action.get("rawData");
                if (rawData == null) {
                    rawData = new HashMap<String, List<Map<String, Object>>>();
                }
                rawData.put("params", cardInfoResponses);
                action.put("rawData", rawData);
            }
        }
        UiBotPageData pageData = new UiBotPageData();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Auxiliary auxiliary : auxiliaryInformationResponse.getAuxiliaryList()) {
            if (!auxiliary.getAuxiliaryCode().equals(uiBotLayout.getSchema())) continue;
            params.put("title", auxiliary.getAuxiliaryName());
            params.putAll(oldPageData);
            break;
        }
        pageData.put((Object)uiBotLayout.getSchema(), params);
        return pageData;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData params = apiRequest.getRawData();
        String dataId = (String)params.get("dataId");
        String data = "";
        UiBotModel uiBotModel = null;
        if ("PURCHASE_APPROVAL_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            data = FileUtil.readText((String)"static/appstore-use/left-slip-purchaseapproval-show-437720680112192.json");
        } else if ("PROJECT_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            data = FileUtil.readText((String)"static/appstore-use/left-slip-project-show-318819017437759.json");
        } else if ("INVENTORY_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            String itemNameSpec = (String)params.get("item_name_spec");
            data = FileUtil.readText((String)"static/appstore-use/left-slip-inventory-show-0218A-08-20220523.json");
            data = data.replaceAll("0218A-08", itemNameSpec);
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }

    private String dealEmptyString(Object data) {
        if (data == null) {
            return "-";
        }
        return StringUtils.hasLength((String)String.valueOf(data)) ? String.valueOf(data) : "-";
    }
}

