/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public abstract class AbstractUniversalParsingPageStrategy<T extends AbstractEntity>
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractUniversalParsingPageStrategy.class);
    @Autowired
    protected PcRuleService pcRuleService;
    @Autowired
    protected UiBotDesignerRenderService uiBotDesignerRenderService;
    @Autowired
    protected ComponentParamAnalyzerFactory componentParamAnalyzerFactory;
    @Autowired
    private UiBotMultipleDataSourceService uiBotMultipleDataSourceService;

    protected UiBotModel buildModel(T absEntity, PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(absEntity, pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(T absEntity, PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        PcUiBotExecuteContext executeContext = (PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"executeContext"), PcUiBotExecuteContext.class);
        absEntity.setApiRequest(apiRequest).setExecuteContext(executeContext).setUiBotModel(uiBotModel);
        this.handleRawDataData(absEntity);
        UiBotPageLayout pageLayout = this.bulidPageLayout(absEntity);
        if (pageLayout == null) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            uiBotModel.getRenderData().resetCancelComponentToBottom();
            return uiBotModel;
        }
        ComponentContext cmptContext = (ComponentContext)JsonUtil.objectToJavaObject((Object)apiRequest, ComponentContext.class);
        cmptContext.setExecuteContext(executeContext);
        cmptContext.setPageLayoutInfo(this.handlePageLayoutData(absEntity));
        cmptContext.setPageDefine(this.getPageDefine(absEntity));
        this.resetPageMultipleDataSourceData(cmptContext, executeContext, pageLayout, apiRequest);
        ApiRawData rawData = apiRequest.getRawData();
        Object data = rawData.get((Object)"data");
        MobilePageRawData mobilePageRawData = new MobilePageRawData().setRawMap((Map)rawData.get((Object)"rawMap")).setDataId(apiRequest.getDataId()).setRawDataType(rawData.getString("rawDataType")).setExtendedFields((Map)rawData.get((Object)"baseEntryExtendedFields")).setSourceCategory(rawData.getString("sourceCategory")).setDataKeys((List)rawData.get((Object)"dataKeys")).setComponentId(rawData.getString("componentId"));
        this.bulidRanderData(absEntity, pageLayout, data, mobilePageRawData, cmptContext);
        this.buildRule(absEntity);
        this.removeEditRulesIfNecessary(absEntity);
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)(CollectionUtils.isEmpty((Map)mobilePageRawData.getRawMap()) ? data : mobilePageRawData.getRawMap()), UiBotPageData.class));
        this.uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength((String)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    protected abstract void handleRawDataData(T var1);

    protected abstract UiBotPageLayout bulidPageLayout(T var1);

    protected abstract Map<String, Map<String, Object>> handlePageLayoutData(T var1);

    private void resetPageMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, UiBotPageLayout pageLayout, ApiRequest apiRequest) {
        Map multipleDataSourceData;
        HashMap rawParam = new HashMap();
        Object data = apiRequest.getRawData().get((Object)"data");
        if (data != null) {
            List listData;
            if (data instanceof Map) {
                rawParam.putAll((Map)data);
            } else if (data instanceof List && !CollectionUtils.isEmpty((Collection)((List)data)) && (listData = (List)data).get(0) instanceof Map) {
                rawParam.putAll((Map)listData.get(0));
            }
        }
        if ((multipleDataSourceData = this.uiBotMultipleDataSourceService.buildPageMultipleDataSourceData(cmptContext, executeContext, pageLayout, rawParam)) != null) {
            apiRequest.getRawData().put("data", (Object)multipleDataSourceData);
        }
    }

    protected abstract void buildRule(T var1);

    protected void removeEditRulesIfNecessary(T absEntity) {
    }

    protected abstract Map<String, Object> buildHooks(T var1, UiBotPageLayout var2, ComponentContext var3);

    protected abstract PcUiBotPageDefine getPageDefine(T var1);

    protected void bulidRanderData(T absEntity, UiBotPageLayout pageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        uiBotModel.setHooks(this.buildHooks(absEntity, pageLayout, cmptContext));
        List bodyCmptList = this.buildBodyCmpt(absEntity, pageLayout, dataResult, mobilePageRawData, cmptContext);
        if (CollectionUtils.isEmpty((Collection)bodyCmptList)) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            uiBotModel.getRenderData().resetCancelComponentToBottom();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType((List)bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer singleListContainer = new SingleListContainer();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }
            List bottomCmptList = this.buildBottomCmpt(absEntity, pageLayout, dataResult, mobilePageRawData, cmptContext);
            if (!CollectionUtils.isEmpty((Collection)bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBodyCmpt(T absEntity, UiBotPageLayout mainPageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        uiBotModel.setTitleVisible(mainPageLayout.getTitleVisible());
        uiBotModel.setPageTitle(BooleanUtils.isTrue((Boolean)mainPageLayout.getTitleVisible()) ? mainPageLayout.getTitle() : "");
        uiBotModel.setShowMore(mainPageLayout.getShowMore());
        uiBotModel.setPageBackgroudColor(mainPageLayout.getPageBackgroudColor());
        if (dataResult == null) {
            return null;
        }
        if (dataResult instanceof List) {
            return null;
        }
        if (dataResult instanceof Map) {
            Map map = (Map)dataResult;
            List cmptList = this.uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), map, mobilePageRawData);
            if (CollectionUtils.isEmpty((Collection)cmptList)) {
                return null;
            }
            return cmptList;
        }
        return null;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottomCmpt(T absEntity, UiBotPageLayout mainPageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        if (dataResult == null) {
            return null;
        }
        if (dataResult instanceof List) {
            return null;
        }
        if (dataResult instanceof Map) {
            Map map = (Map)dataResult;
            cmptContext.setCanBottomButton(Boolean.valueOf(true));
            List cmptList = this.uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBottom(), map, mobilePageRawData);
            if (CollectionUtils.isEmpty((Collection)cmptList)) {
                return null;
            }
            return cmptList;
        }
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

