/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.AbstractUniversalParsingPageStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.UiBotModelDataDrivenDslUniversalParsingPageStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotShowMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.AssistanPatternTaskBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelDataDrivenDslUniversalParsingPageStrategy")
public class UiBotModelDataDrivenDslUniversalParsingPageStrategy
extends AbstractUniversalParsingPageStrategy<DataDrivenDslEntity> {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelDataDrivenDslUniversalParsingPageStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private AssistanPatternTaskBuilder assistanPatternTaskBuilder;
    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel((AbstractEntity)new DataDrivenDslEntity(), pageSetting, apiRequest);
    }

    protected void handleRawDataData(DataDrivenDslEntity absEntity) {
        this.handleRawDataDataOfSubmitParam(absEntity.getApiRequest());
        this.handleRawDataRawMapAndPageDefines(absEntity);
    }

    private void handleRawDataDataOfSubmitParam(ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty((Collection)apiRequest.getSubmitParam())) {
            return;
        }
        Map data = (Map)apiRequest.getRawData().get((Object)"data");
        block10: for (ActionSubmitParam submitParam : apiRequest.getSubmitParam()) {
            String type = submitParam.getType();
            if ("FIELD".equalsIgnoreCase(type)) continue;
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            switch (type) {
                case "ATTACHMENT": {
                    continue block10;
                }
                case "INPUT_DATETIME_PICKER": {
                    InputDateTimePicker picker = (InputDateTimePicker)paramObj;
                    if (picker.getDatetimeValue() == null) continue block10;
                    data.put(schema, InputDateTime.getDateTypeDateStringByType((InputDateTime)picker.getDatetimeValue(), (Integer)picker.getType()));
                    continue block10;
                }
                case "INPUT_SWITCH": {
                    InputSwitch inputSwitch = (InputSwitch)paramObj;
                    data.put(schema, Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1);
                    continue block10;
                }
            }
            ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
            if (null == componentParamAnalyzer) {
                log.error("\u5f53\u524d\u63d0\u4ea4\u53c2\u6570\u6ca1\u6709\u5bf9\u5e94\u53c2\u6570\u89e3\u6790\u5668\uff0c\u8bf7\u6ce8\u610f\u662f\u5426\u4f1a\u6709\u540e\u7eed\u53c2\u6570\u5f02\u5e38\uff01\u5f53\u524dschema\u662f\uff1a{}\uff0c\u53c2\u6570\u662f\uff1a{}", (Object)schema, (Object)JsonUtil.javaObjectToJsonString((Object)paramObj));
                continue;
            }
            Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            if (analyzedParam instanceof Map) {
                data.putAll((Map)analyzedParam);
                continue;
            }
            data.put(schema, analyzedParam);
        }
    }

    private void handleRawDataRawMapAndPageDefines(DataDrivenDslEntity absEntity) {
        List pageDefines = this.taskPageDefineAnalyzer.analysis(null, absEntity.getExecuteContext(), null);
        this.handleRawDataRawMap(absEntity.getApiRequest());
        absEntity.setPageDefines(pageDefines);
    }

    private void handleRawDataRawMap(ApiRequest apiRequest) {
        Map allRawMap = (Map)apiRequest.getRawData().get((Object)"allRawMap");
        if (CollectionUtils.isEmpty((Map)allRawMap)) {
            return;
        }
        apiRequest.getRawData().put("rawMap", (Object)allRawMap);
    }

    protected UiBotPageLayout bulidPageLayout(DataDrivenDslEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        Map rawDataRawData = (Map)apiRequest.getRawData().get((Object)"rawData");
        boolean existSubmitButton = Optional.ofNullable(rawDataRawData).map(r -> (Boolean)r.get("existSubmitButton")).orElse(false);
        PcUiBotMetadataField parentField = (PcUiBotMetadataField)JsonUtil.objectToJavaObject(Optional.ofNullable(rawDataRawData).map(r -> r.get("parentField")).orElse(null), PcUiBotMetadataField.class);
        String sourceType = Optional.ofNullable(rawDataRawData).map(r -> (String)r.get("sourceType")).orElse(null);
        String nanaMessageId = Optional.ofNullable(rawDataRawData).map(r -> (String)r.get("nanaMessageId")).orElse(null);
        if (parentField == null) {
            return null;
        }
        List subFields = parentField.getSubFields();
        if (CollectionUtils.isEmpty((Collection)subFields)) {
            return null;
        }
        UiBotPageLayout uiBotPageLayout = new UiBotPageLayout();
        uiBotPageLayout.setPageBackgroudColor(null);
        uiBotPageLayout.setShowMore(Boolean.valueOf(false));
        uiBotPageLayout.setTitle(this.localeService.getLanguageValue(executeContext.getLocale(), "\u6570\u636e\u9a71\u52a8"));
        uiBotPageLayout.setTitleVisible(Boolean.valueOf(false));
        uiBotPageLayout.setPageId(apiRequest.getPageId());
        uiBotPageLayout.setSchema("a1h8t2ko0a");
        uiBotPageLayout.setComponentType("set-up-drawer");
        uiBotPageLayout.setHeader(new ArrayList());
        uiBotPageLayout.setBody(this.buildBody(executeContext, parentField, existSubmitButton, sourceType, nanaMessageId));
        uiBotPageLayout.setBottom(this.buildBottom(executeContext, parentField, existSubmitButton, absEntity.getPageDefines(), sourceType, nanaMessageId));
        return uiBotPageLayout;
    }

    protected Map<String, Map<String, Object>> handlePageLayoutData(DataDrivenDslEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return Optional.ofNullable(absEntity.getPageDefines()).orElse(Collections.emptyList()).stream().filter(pageDefine -> StringUtils.hasLength((String)dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode())).findFirst().map(PcUiBotPageDefine::getPageLayoutInfo).orElse(new HashMap());
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(PcUiBotExecuteContext executeContext, PcUiBotMetadataField showField, boolean existSubmitButton, String sourceType, String nanaMessageId) {
        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        showField.setArray(false);
        showMetadata.setShowFields((List)Lists.newArrayList((Object[])new PcUiBotMetadataField[]{showField}));
        return this.assistanPatternTaskBuilder.buildBody(executeContext, showMetadata, existSubmitButton, false, sourceType, nanaMessageId, Boolean.valueOf(true));
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, List<PcUiBotTaskPageDefine> pageDefines, String sourceType, String nanaMessageId) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(executeContext, parentField, existSubmitButton, pageDefines, sourceType, nanaMessageId));
        return Lists.newArrayList((Object[])new BaseMobileComponentWrapper[]{new BaseMobileComponentWrapper((BaseMobileComponent)buttonGroup, "DW_BUTTON_GROUP")});
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, List<PcUiBotTaskPageDefine> pageDefines, String sourceType, String nanaMessageId) {
        ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>>();
        BaseMobileComponentWrapper cancelButton = this.buildCancelButton(executeContext);
        contentGroup.add(cancelButton);
        String dataStateCode = executeContext.getDataStateCode();
        Optional<PcUiBotTaskPageDefine> currentPageDefine = ((List)Optional.ofNullable(pageDefines).orElse(new ArrayList())).stream().filter(pageDefine -> StringUtils.hasLength((String)dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode())).findFirst();
        if (!currentPageDefine.isPresent()) {
            return contentGroup;
        }
        PcUiBotTaskPageDefine pageDefine2 = currentPageDefine.get();
        if (BooleanUtils.isTrue((Boolean)pageDefine2.getMerge())) {
            BaseMobileComponentWrapper submitButton = this.buildMergeSubmitButton(executeContext, parentField, existSubmitButton, pageDefine2, sourceType, nanaMessageId);
            if (submitButton != null) {
                contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)submitButton);
            }
        } else {
            BaseMobileComponentWrapper submitButton;
            BaseMobileComponentWrapper saveButton = this.buildSaveButton(executeContext, parentField, existSubmitButton);
            if (saveButton != null) {
                contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)saveButton);
            }
            if ((submitButton = this.buildSubmitButton(executeContext, parentField, existSubmitButton, pageDefine2, sourceType, nanaMessageId)) != null) {
                contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)submitButton);
            }
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildMergeSubmitButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
        if (BooleanUtils.isTrue((Boolean)pageDefine.getFinished())) {
            return null;
        }
        List submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty((Collection)submitActions)) {
            return null;
        }
        Optional<PcUiBotSubmitAction> uiBotActionOptional = submitActions.stream().filter(r -> "TaskEngine".equals(r.getType()) && "submit-data".equals(r.getActionId())).findFirst();
        if (!uiBotActionOptional.isPresent()) {
            return null;
        }
        PcUiBotSubmitAction submitAction = uiBotActionOptional.get();
        String uuid = UUIDUtil.getUuid();
        submitAction.setUuid(uuid);
        submitAction.setBtnId(uuid);
        submitAction.setTitle(this.localeService.getLanguageValue(executeContext.getLocale(), "\u63d0\u4ea4"));
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        uiBotJumpAction.setJumpPageId("page1");
        uiBotJumpAction.setNanaMessageId(nanaMessageId);
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setConfirmPop(ConfirmPop.create((String)(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "\u662f\u5426\u786e\u5b9a") + submitAction.getTitle() + "\uff1f"), (boolean)true));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON", uuid);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildCancelButton(PcUiBotExecuteContext executeContext) {
        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);
        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(this.localeService.getLanguageValue(locale, "\u53d6\u6d88"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setType(ActionTypeEnum.BACK.getValue());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSaveButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton) {
        boolean isEditable = ((List)Optional.ofNullable(parentField.getSubFields()).orElse(new ArrayList())).stream().anyMatch(PcUiBotMetadataField::isCanEdit);
        if (!existSubmitButton) {
            return null;
        }
        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);
        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(this.localeService.getLanguageValue(locale, "\u6682\u5b58"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setType(ActionTypeEnum.JUMP_NEXT_AND_TRANSFER_DATA_TO_PREFIX.getValue());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setSaveType("save");
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSubmitButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
        boolean isEditable = ((List)Optional.ofNullable(parentField.getSubFields()).orElse(new ArrayList())).stream().anyMatch(PcUiBotMetadataField::isCanEdit);
        if (!existSubmitButton) {
            return null;
        }
        if (BooleanUtils.isTrue((Boolean)pageDefine.getFinished())) {
            return null;
        }
        List submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty((Collection)submitActions)) {
            return null;
        }
        Optional<PcUiBotSubmitAction> uiBotActionOptional = submitActions.stream().filter(r -> "TaskEngine".equals(r.getType()) && "submit-data".equals(r.getActionId())).findFirst();
        if (!uiBotActionOptional.isPresent()) {
            return null;
        }
        PcUiBotSubmitAction submitAction = uiBotActionOptional.get();
        String uuid = UUIDUtil.getUuid();
        submitAction.setUuid(uuid);
        submitAction.setBtnId(uuid);
        submitAction.setTitle(this.localeService.getLanguageValue(executeContext.getLocale(), "\u4fdd\u5b58\u5e76\u63d0\u4ea4"));
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        if ("nana".equals(sourceType) || StringUtils.hasLength((String)sourceType)) {
            uiBotJumpAction.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            uiBotJumpAction.setJumpPageId("page1");
        } else {
            uiBotJumpAction.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
        }
        uiBotJumpAction.setNanaMessageId(nanaMessageId);
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setConfirmPop(ConfirmPop.create((String)(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "\u662f\u5426\u786e\u5b9a") + submitAction.getTitle() + "\uff1f"), (boolean)true));
        uiBotJumpAction.setSaveType("submit");
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("saveType", "submit");
        uiBotJumpAction.setRawData(rawData);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON", uuid);
    }

    protected void buildRule(DataDrivenDslEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List rules = this.pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty((Collection)rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    protected Map<String, Object> buildHooks(DataDrivenDslEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        List hooks = ((List)Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList())).stream().filter(pageDefine -> StringUtils.hasLength((String)dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode())).findFirst().map(PcUiBotPageDefine::getHooks).orElse(Collections.emptyList());
        return this.uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    protected PcUiBotPageDefine getPageDefine(DataDrivenDslEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return ((List)Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList())).stream().filter(pageDefine -> StringUtils.hasLength((String)dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode())).findFirst().orElse(null);
    }
}

