/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard.service.impl;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleCodeGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleItemGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleQueryListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleUpdateListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.UserDashBoardSetting;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.service.UserDashBoardSettingService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetJobResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DashBoardServiceImpl
implements DashBoardService {
    private static final Logger log = LoggerFactory.getLogger(DashBoardServiceImpl.class);
    @Autowired
    private UserDashBoardSettingService userDashBoardSettingService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    private DigiwinSemcProxyService semcProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel dataEntryAsync(CustomContentRequest customContentRequest) {
        String subTitle;
        List moduleSettingCodeGroupByAppList;
        List<AppModuleItem> appModuleItemList;
        Map sysParam = customContentRequest.getSysParam();
        String locale = MapUtils.getString((Map)sysParam, (Object)"locale");
        String iamUserToken = MapUtils.getString((Map)sysParam, (Object)"iamUserToken");
        String clientId = MapUtils.getString((Map)sysParam, (Object)"clientId");
        String tenantId = MapUtils.getString((Map)sysParam, (Object)"tenantId");
        String userId = MapUtils.getString((Map)sysParam, (Object)"userId");
        String code = MapUtils.getString((Map)sysParam, (Object)"code");
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if (CollectionUtils.isEmpty((Collection)(appModuleItemList = this.getDataEntryModuleList(clientId, iamUserToken, tenantId, locale)))) {
            return uiBotModel;
        }
        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(userId);
        userDashBoardSetting.setTenantId(tenantId);
        userDashBoardSetting.setCode(code);
        UserDashBoardSetting userDashBoardSettingQuery = this.userDashBoardSettingService.getUserDashBoardSetting(userDashBoardSetting);
        if (Objects.nonNull(userDashBoardSettingQuery) && !CollectionUtils.isEmpty((Collection)(moduleSettingCodeGroupByAppList = (List)JsonUtil.jsonStringToObject((String)userDashBoardSettingQuery.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            Map<String, ModuleCodeGroupByApp.AppGroupItem> appGroupItemMapById = moduleSettingCodeGroupByAppList.stream().flatMap(e -> e.getItemList().stream()).collect(Collectors.toMap(ModuleCodeGroupByApp.AppGroupItem::getId, e -> e, (a, b) -> a));
            appModuleItemList.forEach(item -> item.setIsTop(Optional.ofNullable(appGroupItemMapById.get(item.getId())).map(ModuleCodeGroupByApp.AppGroupItem::getIsTop).orElse(false)));
            appModuleItemList = appModuleItemList.stream().sorted(Comparator.comparing(item -> item.getIsTop() != false ? 0 : 1)).collect(Collectors.toList());
        }
        Action subTitleAction = new Action();
        if (appModuleItemList.size() > 4) {
            subTitle = this.localeService.getLanguageValue(locale, "\u67e5\u770b\u66f4\u591a>");
            subTitleAction.setType(ActionTypeEnum.JUMP_SEE_MORE.getValue());
        } else {
            subTitle = this.localeService.getLanguageValue(locale, "\u7ba1\u7406");
            subTitleAction.setType(ActionTypeEnum.JUMP_MANAGE.getValue());
        }
        CustomContent dataEntryCustomContent = new CustomContent();
        dataEntryCustomContent.setCode(AppModuleCodeEnum.DATA_ENTRY.getCode());
        dataEntryCustomContent.setTitle(this.localeService.getLanguageValue(locale, AppModuleCodeEnum.DATA_ENTRY.getName()));
        dataEntryCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
        dataEntryCustomContent.setRowSize(Integer.valueOf(2));
        dataEntryCustomContent.setLimitShowSize(Integer.valueOf(4));
        dataEntryCustomContent.setSubTitle(subTitle);
        dataEntryCustomContent.setSubTitleAction(subTitleAction);
        dataEntryCustomContent.addAllComponentsToGroup(appModuleItemList, "DW_APP_MODULE_ITEM");
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)dataEntryCustomContent, "DW_CUSTOM_CONTENT"));
        return uiBotModel;
    }

    public UiBotModel smartMachineAsync(CustomContentRequest customContentRequest) {
        List topicPresetRespList;
        Map sysParam = customContentRequest.getSysParam();
        String locale = (String)sysParam.get("locale");
        String iamUserToken = (String)sysParam.get("iamUserToken");
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if (CollectionUtils.isEmpty((Collection)(topicPresetRespList = this.semcProxyService.queryAllJob(new ArrayList(), locale, iamUserToken)))) {
            return uiBotModel;
        }
        List customGroupList = this.buildCustomGroupList(topicPresetRespList, locale);
        CustomContent smartMachineCustomContent = new CustomContent();
        smartMachineCustomContent.setCode(AppModuleCodeEnum.SMART_MACHINE.getCode());
        smartMachineCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
        smartMachineCustomContent.setRowSize(Integer.valueOf(1));
        smartMachineCustomContent.setLimitShowSize(Integer.valueOf(customGroupList.size()));
        smartMachineCustomContent.setSubComponentName("CUSTOM_GROUP");
        smartMachineCustomContent.addAllComponentsToGroup(customGroupList, "DW_CUSTOM_GROUP");
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)smartMachineCustomContent, "DW_CUSTOM_CONTENT"));
        return uiBotModel;
    }

    public List<ModuleItemGroupByApp> getModuleList(DashBoardModuleQueryListRequest request) {
        List moduleSettingCodeGroupByAppList;
        List dataEntryModuleList = this.getDataEntryModuleList(request.getClientId(), request.getIamUserToken(), request.getTenantId(), request.getLocale());
        if (CollectionUtils.isEmpty((Collection)dataEntryModuleList)) {
            return Collections.emptyList();
        }
        Map<String, List<AppModuleItem>> dataEntryModuleListMapByParentCode = dataEntryModuleList.stream().collect(Collectors.groupingBy(AppModuleItem::getParentCode));
        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(request.getUserId());
        userDashBoardSetting.setTenantId(request.getTenantId());
        userDashBoardSetting.setCode(request.getCode());
        UserDashBoardSetting userDashBoardSettingQuery = this.userDashBoardSettingService.getUserDashBoardSetting(userDashBoardSetting);
        ArrayList<ModuleItemGroupByApp> moduleItemGroupByAppList = new ArrayList<ModuleItemGroupByApp>();
        if (Objects.nonNull(userDashBoardSettingQuery) && !CollectionUtils.isEmpty((Collection)(moduleSettingCodeGroupByAppList = (List)JsonUtil.jsonStringToObject((String)userDashBoardSettingQuery.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            for (ModuleCodeGroupByApp moduleSettingCodeGroupByApp : moduleSettingCodeGroupByAppList) {
                if (!dataEntryModuleListMapByParentCode.containsKey(moduleSettingCodeGroupByApp.getAppCode())) continue;
                List<AppModuleItem> dataEntryModuleListByParentCode = dataEntryModuleListMapByParentCode.get(moduleSettingCodeGroupByApp.getAppCode());
                Map<String, AppModuleItem> dataEntryModuleListById = dataEntryModuleListByParentCode.stream().collect(Collectors.toMap(Button::getId, e -> e, (a, b) -> a));
                ArrayList<ModuleItemGroupByApp.AppGroupItem> newAppGroupItemList = new ArrayList<ModuleItemGroupByApp.AppGroupItem>();
                for (ModuleCodeGroupByApp.AppGroupItem moduleSettingAppCodeGroupItem : moduleSettingCodeGroupByApp.getItemList()) {
                    if (!dataEntryModuleListById.containsKey(moduleSettingAppCodeGroupItem.getId())) continue;
                    AppModuleItem appModuleItemById = dataEntryModuleListById.get(moduleSettingAppCodeGroupItem.getId());
                    ModuleItemGroupByApp.AppGroupItem newAppGroupItem = (ModuleItemGroupByApp.AppGroupItem)JsonUtil.objectToJavaObject((Object)appModuleItemById, ModuleItemGroupByApp.AppGroupItem.class);
                    newAppGroupItem.setIsTop(moduleSettingAppCodeGroupItem.getIsTop());
                    newAppGroupItemList.add(newAppGroupItem);
                    dataEntryModuleListById.remove(moduleSettingAppCodeGroupItem.getId());
                }
                if (!CollectionUtils.isEmpty(dataEntryModuleListById)) {
                    dataEntryModuleListById.values().forEach(e -> {
                        ModuleItemGroupByApp.AppGroupItem newAppGroupItem = (ModuleItemGroupByApp.AppGroupItem)JsonUtil.objectToJavaObject((Object)e, ModuleItemGroupByApp.AppGroupItem.class);
                        newAppGroupItemList.add(newAppGroupItem);
                    });
                }
                ModuleItemGroupByApp moduleItemGroupByApp = new ModuleItemGroupByApp();
                moduleItemGroupByApp.setAppCode(dataEntryModuleListByParentCode.get(0).getParentCode());
                moduleItemGroupByApp.setAppName(dataEntryModuleListByParentCode.get(0).getParentName());
                moduleItemGroupByApp.setItemList(newAppGroupItemList);
                moduleItemGroupByAppList.add(moduleItemGroupByApp);
                dataEntryModuleListMapByParentCode.remove(moduleSettingCodeGroupByApp.getAppCode());
            }
        }
        if (!CollectionUtils.isEmpty(dataEntryModuleListMapByParentCode)) {
            dataEntryModuleListMapByParentCode.values().forEach(item -> {
                ModuleItemGroupByApp moduleItemGroupByApp = new ModuleItemGroupByApp();
                moduleItemGroupByApp.setAppCode(((AppModuleItem)item.get(0)).getParentCode());
                moduleItemGroupByApp.setAppName(((AppModuleItem)item.get(0)).getParentName());
                List newAppGroupItemList = (List)JsonUtil.objectToJavaObject((Object)item, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                moduleItemGroupByApp.setItemList(newAppGroupItemList);
                moduleItemGroupByAppList.add(moduleItemGroupByApp);
            });
        }
        return moduleItemGroupByAppList;
    }

    public boolean updateModuleInfo(DashBoardModuleUpdateListRequest dshBoardModuleUpdateListRequest) {
        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(dshBoardModuleUpdateListRequest.getUserId());
        userDashBoardSetting.setTenantId(dshBoardModuleUpdateListRequest.getTenantId());
        userDashBoardSetting.setCode(dshBoardModuleUpdateListRequest.getCode());
        if (!CollectionUtils.isEmpty((Collection)dshBoardModuleUpdateListRequest.getAppList())) {
            userDashBoardSetting.setData(JsonUtil.javaObjectToJsonString((Object)dshBoardModuleUpdateListRequest.getAppList()));
        }
        return this.userDashBoardSettingService.insertOrUpdateUserDashBoardSetting(userDashBoardSetting);
    }

    public List<AppModuleItem> getDataEntryModuleList(String clientId, String iamUserToken, String tenantId, String locale) {
        List basicDataList = this.digiwinAudcProxyService.getBasicDataList(clientId, iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty((Collection)basicDataList)) {
            return Collections.emptyList();
        }
        String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List tmActivityIdList = this.activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), tenantId, tenantVersion).stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            return Collections.emptyList();
        }
        ArrayList<AppModuleItem> appModuleItemList = new ArrayList<AppModuleItem>();
        basicDataList.forEach(tmData -> tmData.getBaseItemDtoList().forEach(itemDto -> {
            if (itemDto.isAllow().booleanValue() && tmActivityIdList.contains(itemDto.getCode())) {
                AppModuleItem appModuleItem = new AppModuleItem();
                appModuleItem.setName(itemDto.getName());
                appModuleItem.setId(itemDto.getCode());
                appModuleItem.setParentCode(tmData.getAppCode());
                appModuleItem.setParentName(tmData.getAppName());
                appModuleItem.setBgColor("#FFF3E4");
                Action action = new Action();
                appModuleItem.setAction(action);
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                if ("SIGN-DOCUMENT".equals(itemDto.getCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                } else if (Lists.newArrayList((Object[])new String[]{"DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI"}).contains(itemDto.getCategory())) {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                } else {
                    return;
                }
                action.setJumpPageTitle(itemDto.getName());
                action.setDataId(itemDto.getCode());
                appModuleItemList.add(appModuleItem);
            }
        }));
        return appModuleItemList;
    }

    public List<CustomGroup> buildCustomGroupList(List<TopicPresetResp> topicPresetRespList, String locale) {
        return topicPresetRespList.stream().map(topicPresetResp -> {
            CustomGroup customGroup = new CustomGroup();
            customGroup.setName(topicPresetResp.getModuleName());
            customGroup.setStyleType(CustomGroupStyleTypeEnum.TITLE_BLACK.getValue());
            AppEntrance appEntrance = new AppEntrance();
            List appList = this.addJobTouchable(topicPresetResp.getTopicpList(), locale);
            appEntrance.setAppList(appList);
            customGroup.addComponentToGroup((BaseMobileComponent)appEntrance, "DW_APP_ENTRANCE");
            return customGroup;
        }).collect(Collectors.toList());
    }

    public List<AppFunctionTouchable> addJobTouchable(List<TopicPresetJobResp> topicpList, String locale) {
        ArrayList<AppFunctionTouchable> appList = new ArrayList<AppFunctionTouchable>();
        for (TopicPresetJobResp topicp : topicpList) {
            AppFunctionTouchable touchable = new AppFunctionTouchable();
            touchable.setIconUrl(topicp.getTopicPresetIcon());
            touchable.setImageUrl(topicp.getTopicPresetIcon());
            touchable.setName(topicp.getTopicPresetName());
            touchable.setId(topicp.getCaseId());
            Action action = new Action();
            action.setOpenWebPageTitle(topicp.getTopicPresetName());
            action.setRequestUrl(topicp.getTopicPresetUrl());
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            if (!topicp.getIsSetCompany().booleanValue()) {
                action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                action.setToastMsg(this.localeService.getLanguageValue(locale, "\u8bf7\u5148\u8bbe\u7f6e\u516c\u53f8\u522b\u548c\u5382\u522b"));
            }
            touchable.setAction(action);
            appList.add(touchable);
        }
        return appList;
    }

    public Map<String, TopicPresetResp> addAppUiBot(List<TopicPresetResp> topicPresetRespList, List<UiBotLayout> layoutList) {
        HashMap<String, TopicPresetResp> topicPresetRespMap = new HashMap<String, TopicPresetResp>();
        for (TopicPresetResp topicPreset : topicPresetRespList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType("CUSTOM_GROUP");
            layoutList.add(layout);
            topicPresetRespMap.put(schema, topicPreset);
        }
        return topicPresetRespMap;
    }
}

