/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dataentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class UiBotModelBuildBasicDataEntranceStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        List basicDataList;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if (CollectionUtils.isEmpty((Collection)(basicDataList = this.digiwinAudcProxyService.getBasicDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale())))) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List tmActivityIdList = this.activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), apiRequest.getTenantId(), tenantVersion).stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        ArrayList bodyCmptList = new ArrayList();
        basicDataList.forEach(tmData -> {
            Retractable retractable = new Retractable();
            retractable.setTitle(tmData.getAppName());
            retractable.setIsExpand(Boolean.valueOf(true));
            Apposition apposition = new Apposition();
            retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper((BaseMobileComponent)apposition, "DW_APPOSITION")));
            apposition.setColumns(Integer.valueOf(2));
            ArrayList appositionDataList = new ArrayList();
            apposition.setDatas(appositionDataList);
            tmData.getBaseItemDtoList().forEach(itemDto -> {
                if (itemDto.isAllow().booleanValue() && tmActivityIdList.contains(itemDto.getCode())) {
                    Button button = new Button();
                    button.setName(itemDto.getName());
                    Action action = new Action();
                    button.setAction(action);
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    if ("SIGN-DOCUMENT".equals(itemDto.getCategory())) {
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                    } else if (Lists.newArrayList((Object[])new String[]{"DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI"}).contains(itemDto.getCategory())) {
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                    } else {
                        return;
                    }
                    action.setJumpPageTitle(itemDto.getName());
                    action.setDataId(itemDto.getCode());
                    AppositionData appositionData = new AppositionData();
                    appositionData.setComponentType("DW_BUTTON");
                    appositionData.setData((Object)button);
                    appositionDataList.add(appositionData);
                }
            });
            if (!CollectionUtils.isEmpty(appositionDataList)) {
                bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)retractable, "DW_RETRACYABLE"));
            }
        });
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        SingleListContainer singleListContainer = new SingleListContainer();
        singleListContainer.addAll(bodyCmptList);
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

