/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerFieldTagConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldTagApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer.DesignerTagAnalyzer;
import com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer.DesignerTagAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uiBotDesignerFieldTagApplierService")
public class UiBotDesignerFieldTagApplierServiceImpl
implements UiBotDesignerFieldTagApplierService {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerFieldTagApplierServiceImpl.class);
    private final DesignerTagAnalyzerFactory designerTagAnalyzerFactory;

    public UiBotDesignerFieldTagApplierServiceImpl(DesignerTagAnalyzerFactory designerTagAnalyzerFactory) {
        this.designerTagAnalyzerFactory = designerTagAnalyzerFactory;
    }

    public void applyFieldTag(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        UiBotTargetLayoutSearchResult layoutSearchResult = uiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        List tagConfigList = uiBotDesignerConfig.getTagConfigs();
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
            if (CollectionUtils.isEmpty((Collection)tableColumnDefinitionList)) {
                return;
            }
            List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
            this.commonProcessTag(uiBotModel, tagConfigList, tableColumns);
            uiBotModel.setAppliedDesignerFieldTag(Boolean.valueOf(true));
        } else if (pcDataLayout.isTypeOfFormList()) {
            List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(Collections.emptyList());
            this.commonProcessTag(uiBotModel, tagConfigList, pcFieldLayoutList);
            uiBotModel.setAppliedDesignerFieldTag(Boolean.valueOf(true));
        } else {
            return;
        }
    }

    private <T extends UiBotBizFieldBase> void commonProcessTag(UiBotModel uiBotModel, List<UiBotDesignerFieldTagConfig> tagConfigList, List<T> bizFieldBaseList) {
        if (CollectionUtils.isEmpty(bizFieldBaseList)) {
            return;
        }
        Map<String, UiBotBizFieldBase> bizFieldBaseMap = bizFieldBaseList.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        for (UiBotDesignerFieldTagConfig uiBotDesignerFieldTagConfig : tagConfigList) {
            String targetFieldId = uiBotDesignerFieldTagConfig.getEspFieldId();
            UiBotBizFieldBase targetBizFieldBase = bizFieldBaseMap.get(targetFieldId);
            if (null == targetBizFieldBase) continue;
            String previousAnalyzedComponentTagCode = "";
            for (KnowledgeMapsTag knowledgeMapsTag : uiBotDesignerFieldTagConfig.getTags()) {
                DesignerTagAnalyzer tagAnalyzer = this.designerTagAnalyzerFactory.get(knowledgeMapsTag.getCode());
                if (null == tagAnalyzer) continue;
                String currentTagCode = tagAnalyzer.getTagCode();
                if (Boolean.TRUE.equals(tagAnalyzer.tagCodeChangeComponentState())) {
                    tagAnalyzer.analyze(uiBotModel, targetBizFieldBase, knowledgeMapsTag);
                }
                if (StringUtils.hasLength((String)previousAnalyzedComponentTagCode) || !Boolean.TRUE.equals(tagAnalyzer.tagCodeDecideComponentType())) continue;
                tagAnalyzer.analyze(uiBotModel, targetBizFieldBase, knowledgeMapsTag);
                previousAnalyzedComponentTagCode = currentTagCode;
            }
        }
    }
}

