/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.environment;

import com.digiwin.mobile.mobileuibot.api.ApiRequestEnvConfig;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.pageskeleton.PageSkeleton;
import com.digiwin.mobile.mobileuibot.core.pageskeleton.PageSkeletonService;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfig;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfigService;
import com.digiwin.mobile.mobileuibot.environment.config.EnvConfigModel;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppCommonConfig;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppConfig;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppCustomizeConfig;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnvironmentService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentService.class);
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private PageSkeletonService pageSkeletonService;
    @Autowired
    private EnvironmentConfigService environmentConfigService;

    public Map<String, Object> getEnvironmentConfig(ApiRequestEnvConfig apiRequestEnvConfig) {
        boolean getPageSkeletonConfig = apiRequestEnvConfig.getGetPageSkeletonConfig();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skeleton", this.getSkeletonMap());
        if (getPageSkeletonConfig) {
            return map;
        }
        Map appConfig = this.getAppConfig();
        map.putAll(appConfig);
        map.put("mqtt", this.getMqttMap(Boolean.valueOf(Boolean.TRUE.equals(appConfig.get("enableMqtt")))));
        map.put("switchTracking", this.sysEnvConfig.getSwitchTracking());
        return map;
    }

    private Map<String, Object> getMqttMap(Boolean enableMqtt) {
        HashMap<String, Object> mqttConfig = new HashMap<String, Object>(8);
        if (enableMqtt.booleanValue()) {
            enableMqtt = "true".equalsIgnoreCase(AppContext.getApiUrlSetting().getEnableMqtt());
        }
        mqttConfig.put("enableMqtt", enableMqtt);
        mqttConfig.put("mqttUrl", AppContext.getApiUrlSetting().getMqttUrl());
        mqttConfig.put("mqttPort", AppContext.getApiUrlSetting().getMqttPort());
        mqttConfig.put("mqttPath", AppContext.getApiUrlSetting().getMqttPath());
        mqttConfig.put("mqttUserName", AppContext.getApiUrlSetting().getMqttUserName());
        mqttConfig.put("mqttPassword", AppContext.getApiUrlSetting().getMqttPassword());
        mqttConfig.put("mqttTopicServerName", AppContext.getApiUrlSetting().getServerName());
        mqttConfig.put("mqttTopicServerNameASA", this.sysEnvConfig.getMqttTopicServerNameASA());
        return mqttConfig;
    }

    public Map<String, Object> getAppConfig() {
        EvnAppCommonConfig commonConfig;
        HashMap<String, Object> appEnvironmentConfig = new HashMap<String, Object>(8);
        List environmentConfigs = this.environmentConfigService.getEnvironmentConfig();
        log.debug("mongodb environmentConfig data:{}", (Object)JsonUtil.javaObjectToJsonString((Object)environmentConfigs));
        if (CollectionUtils.isEmpty((Collection)environmentConfigs)) {
            return appEnvironmentConfig;
        }
        EnvironmentConfig environmentConfig = (EnvironmentConfig)environmentConfigs.get(0);
        EnvConfigModel envConfigModel = environmentConfig.getConfig();
        if (null == envConfigModel) {
            return appEnvironmentConfig;
        }
        EvnAppConfig appConfig = envConfigModel.getAppConfig();
        if (null == appConfig) {
            return appEnvironmentConfig;
        }
        List customizeConfig = appConfig.getCustomizeConfig();
        if (!CollectionUtils.isEmpty((Collection)customizeConfig)) {
            for (EvnAppCustomizeConfig config : customizeConfig) {
                appEnvironmentConfig.put(config.getName(), config);
            }
        }
        if (null != (commonConfig = appConfig.getCommonConfig())) {
            appEnvironmentConfig.putAll((Map)JsonUtil.objectToJavaObject((Object)commonConfig, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
        return appEnvironmentConfig;
    }

    private Map<String, Object> getSkeletonMap() {
        List pageSkeletons = this.pageSkeletonService.getAllSkeletonConfig();
        HashMap<String, Object> skeletonMap = new HashMap<String, Object>(pageSkeletons.size());
        for (PageSkeleton pageSkeleton : pageSkeletons) {
            skeletonMap.put(pageSkeleton.getPageId(), pageSkeleton.getSkeletons());
        }
        return skeletonMap;
    }
}

