/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.Image;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardService;
import com.digiwin.mobile.mobileuibot.index.IndexBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="indexBuildNoWorkStrategy")
public class IndexBuildNoWorkStrategy
implements IndexBuildStrategy {
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private DashboardService dashboardService;

    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_NO_WORK.toString();
    }

    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator layoutIterator = uiBotModel.getLayout().iterator();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            if (layout.getType().equals("INDEX_NAVBAR") && pageData.get((Object)layout.getSchema()) != null) {
                IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                pageData.put((Object)layout.getSchema(), (Object)indexNavBar);
                layoutList.add(layout);
                continue;
            }
            if (layout.getType().equals("BLANK_AREA")) {
                layoutList.add(layout);
                continue;
            }
            if (layout.getType().equals("CUSTOM_TAB_CONTROLLER") && pageData.get((Object)layout.getSchema()) != null) {
                CustomTabController customTabController = (CustomTabController)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabController.class);
                customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                pageData.put((Object)layout.getSchema(), (Object)customTabController);
                layoutList.add(layout);
                continue;
            }
            if (layout.getType().equals("IMAGE") && pageData.get((Object)layout.getSchema()) != null) {
                Image image = (Image)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Image.class);
                Integer dataType = image.getContent().getDataType();
                if (BaseImageContentDataTypeEnum.NETWORK_HTTP_URL.getValue().equals(dataType)) {
                    String data = image.getContent().getData();
                    image.getContent().setData(data.replace("${locale}", apiRequest.getLocale()));
                }
                pageData.put((Object)layout.getSchema(), (Object)image);
                layoutList.add(layout);
                continue;
            }
            if (layout.getType().equals("UNI_SEARCH") && pageData.get((Object)layout.getSchema()) != null) {
                UniSearch uniSearch = (UniSearch)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put((Object)layout.getSchema(), (Object)uniSearch);
                layoutList.add(layout);
                continue;
            }
            if ("recommend_see".equals(layout.getType())) {
                List customContentList = this.dashboardService.generateDashboardCustomContent(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), true, Boolean.valueOf(true));
                if (customContentList == null || customContentList.isEmpty()) continue;
                customContentList.stream().forEach(customContent -> {
                    String uuid = UUIDUtil.getUuid();
                    UiBotLayout customContentLayout = new UiBotLayout();
                    customContentLayout.setType("CUSTOM_CONTENT");
                    customContentLayout.setSchema(uuid);
                    layoutList.add(customContentLayout);
                    pageData.put((Object)uuid, customContent);
                });
                continue;
            }
            if (!"recommend_do".equals(layout.getType())) continue;
            CustomContent customContent2 = CustomContent.create((String)apiRequest.getLocale(), (String)apiRequest.getClientId(), (String)apiRequest.getIamUserToken(), (String)"", (String)(AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/recommend/menu?userId=" + apiRequest.getUserId()), (boolean)true);
            String uuid = UUIDUtil.getUuid();
            UiBotLayout customContentLayout = new UiBotLayout();
            customContentLayout.setType("CUSTOM_CONTENT");
            customContentLayout.setSchema(uuid);
            layoutList.add(customContentLayout);
            pageData.put((Object)uuid, (Object)customContent2);
        }
        uiBotModel.setLayout(layoutList);
        return uiBotModel;
    }
}

