/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndexBuildTouristModeStrategy {
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!CollectionUtils.isEmpty((Collection)layoutList)) {
            layoutList.forEach(layout -> {
                switch (layout.getType()) {
                    case "INDEX_NAVBAR": {
                        IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), IndexNavBar.class);
                        indexNavBar.initSetting(apiRequest.getLocale(), null);
                        pageData.put((Object)layout.getSchema(), (Object)indexNavBar);
                        break;
                    }
                    case "CUSTOM_GROUP": {
                        CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                        customGroup.initSetting(apiRequest.getLocale());
                        pageData.put((Object)layout.getSchema(), (Object)customGroup);
                        break;
                    }
                    case "SWIPER": {
                        Swiper swiper = (Swiper)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Swiper.class);
                        swiper.initSetting(apiRequest.getLocale());
                        Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
                        if (isTw.booleanValue()) {
                            List contents = swiper.getContent().stream().filter(content -> !BaseImageContentCategoryEnum.ZTB_DRIVER_REGISTER.getValue().equals(content.getCategory())).collect(Collectors.toList());
                            swiper.setContent(contents);
                        }
                        for (BaseImageContent content2 : swiper.getContent()) {
                            Action action;
                            if (!BaseImageContentCategoryEnum.ZTB_DRIVER_REGISTER.getValue().equals(content2.getCategory()) || null == (action = content2.getAction())) continue;
                            HashMap<String, String> params = new HashMap<String, String>(1);
                            params.put("module_type", "1");
                            String webUrl = this.digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
                            if (!StringUtil.isNotEmpty((CharSequence)webUrl)) continue;
                            action.setRequestUrl(webUrl);
                        }
                        pageData.put((Object)layout.getSchema(), (Object)swiper);
                        break;
                    }
                }
            });
        }
        return uiBotModel;
    }
}

