/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mock;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.mapper.MockMapper;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.mock.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.mock.model.MockCategory;
import com.digiwin.mobile.mobileuibot.mock.request.MockVO;
import com.digiwin.mobile.mobileuibot.model.Mock;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MockServiceImpl
implements MockService {
    @Autowired
    private MockMapper mockMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;

    public List<Mock> mockList(String recordUserId, boolean isMockSuperAdmin) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Mock::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        if (!isMockSuperAdmin) {
            wrapper.eq(Mock::getRecordUserId, (Object)recordUserId);
        }
        wrapper.orderByDesc(Mock::getPublish, (Object[])new SFunction[]{Mock::getUpdateTime});
        List mockList = this.mockMapper.selectList((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)mockList) ? Collections.emptyList() : mockList;
    }

    public Mock selectByMockId(String mockId, String recordUserId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Mock::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(Mock::getMockId, (Object)mockId);
        if (recordUserId != null) {
            wrapper.eq(Mock::getRecordUserId, (Object)recordUserId);
        }
        return (Mock)this.mockMapper.selectOne((Wrapper)wrapper, false);
    }

    public int delete(String mockId, String recordUserId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Mock::getMockId, (Object)mockId);
        updateWrapper.eq(Mock::getRecordUserId, (Object)recordUserId);
        updateWrapper.eq(Mock::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        updateWrapper.set(Mock::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        int i = this.mockMapper.update(null, (Wrapper)updateWrapper);
        this.digiwinExperienceProxyService.deleteMockData(new OuterMockData().setMockId(mockId));
        return i;
    }

    public int publish(String mockId, String recordUserId, Integer publish) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Mock::getMockId, (Object)mockId);
        updateWrapper.eq(Mock::getRecordUserId, (Object)recordUserId);
        updateWrapper.eq(Mock::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        updateWrapper.set(Mock::getPublish, (Object)publish);
        return this.mockMapper.update(null, (Wrapper)updateWrapper);
    }

    public List<String> categoryList() {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"verify").is((Object)true)).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"order")}));
        List mockCategories = this.mongoTemplate.find(query, MockCategory.class);
        if (CollectionUtils.isEmpty((Collection)mockCategories)) {
            return Collections.emptyList();
        }
        return mockCategories.stream().map(MockCategory::getCategoryName).collect(Collectors.toList());
    }

    public MockVO startRecord(MockVO vo) {
        Mock mock = new Mock().setMockName(vo.getMockName()).setApplicationName(vo.getApplicationName()).setRecordUserId(vo.getRecordUserId()).setRecordUserName(vo.getRecordUserName()).setEnableNana(vo.getEnableNana()).setNanaTenantId(vo.getNanaTenantId()).setNanaAdminAccount(vo.getNanaAdminAccount()).setNanaAdminPassword(vo.getNanaAdminPassword()).setNanaAuthorizationCode(vo.getNanaAuthorizationCode());
        if (StringUtils.hasLength((String)vo.getMockId())) {
            mock.setMockId(vo.getMockId());
            this.mockMapper.updateById((Object)mock);
        } else {
            mock.setMockId(UUIDUtil.getUuid()).setPublish(PublishEnum.UNPUBLISH.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date());
            this.mockMapper.insert((Object)mock);
        }
        return vo.setMockId(mock.getMockId());
    }

    public String settingMockUserInfo(String mockId, DigiwhaleLoginResponse body) {
        Mock mock = (Mock)this.mockMapper.selectById((Serializable)((Object)mockId));
        String mockUserId = mock.getMockUserId();
        if (!StringUtils.hasLength((String)mockUserId)) {
            Mock update = new Mock().setMockId(mockId).setMockUserId(body.getIamAuth().getUserId()).setMockUserName(body.getIamAuth().getUserName());
            this.mockMapper.updateById((Object)update);
            return update.getMockId();
        }
        String userId = body.getIamAuth().getUserId();
        if (mockUserId.equals(userId)) {
            return mock.getMockId();
        }
        Mock insert = new Mock().setMockId(UUIDUtil.getUuid()).setMockName(mock.getMockName()).setApplicationName(mock.getApplicationName()).setRecordUserId(mock.getRecordUserId()).setRecordUserName(mock.getRecordUserName()).setMockUserId(body.getIamAuth().getUserId()).setMockUserName(body.getIamAuth().getUserName()).setPublish(PublishEnum.UNPUBLISH.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date()).setEnableNana(mock.getEnableNana()).setNanaTenantId(mock.getNanaTenantId()).setNanaAdminAccount(mock.getNanaAdminAccount()).setNanaAdminPassword(mock.getNanaAdminPassword()).setNanaAuthorizationCode(mock.getNanaAuthorizationCode());
        this.mockMapper.insert((Object)insert);
        return insert.getMockId();
    }

    public List<Mock> mockListOfPublish() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Mock::getPublish, (Object)PublishEnum.PUBLISH.getValue());
        wrapper.eq(Mock::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByDesc(Mock::getUpdateTime);
        List mockList = this.mockMapper.selectList((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)mockList) ? Collections.emptyList() : mockList;
    }
}

