/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mock.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

@Document(collection="mockData")
public class MockData
implements Serializable {
    private static final long serialVersionUID = -7607334276297623430L;
    public static final String ROLE_DEFAULT = "default";
    @Id
    private String id;
    private String uri;
    private String pageId;
    private String dataId;
    private String locale;
    private Map<String, Object> body;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockData mockData = (MockData)o;
        return Objects.equals(this.id, mockData.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Object getResponseBody(String roleCode) {
        if (this.body == null) {
            return null;
        }
        if (StringUtils.hasLength((String)roleCode) && this.body.containsKey(roleCode)) {
            return this.body.get(roleCode);
        }
        if (this.body.containsKey(ROLE_DEFAULT)) {
            return this.body.get(ROLE_DEFAULT);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String getLocale() {
        return this.locale;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public String toString() {
        return "MockData(id=" + this.getId() + ", uri=" + this.getUri() + ", pageId=" + this.getPageId() + ", dataId=" + this.getDataId() + ", locale=" + this.getLocale() + ", body=" + this.getBody() + ")";
    }
}

