/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mongodb;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.mongodb.dto.MongoDbAddDTO;
import com.digiwin.mobile.mobileuibot.mongodb.dto.MongoDbDeleteDTO;
import com.digiwin.mobile.mobileuibot.mongodb.dto.MongoDbQueryDTO;
import com.digiwin.mobile.mobileuibot.mongodb.dto.MongoDbUpdateDTO;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/mongodb"})
public class MongoDbController {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    @GetMapping(value={"/query"})
    public ApiResponse query(@Valid MongoDbQueryDTO dto) {
        Query query = new Query();
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIncludeField())) {
            query.fields().include(new String[]{"_id", dto.getIncludeField()});
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        ArrayList list = new ArrayList();
        List mongoDbList = null;
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            mongoDbList = this.mongoTemplate.find(query, Map.class, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            mongoDbList = this.secondMongoTemplate.find(query, Map.class, dto.getCollectionName());
        }
        if (CollectionUtils.isEmpty(mongoDbList)) {
            return ApiResponse.buildOK((String)"\u6682\u65e0\u6570\u636e");
        }
        for (Map map : mongoDbList) {
            HashMap mapResult = new HashMap(map.size());
            map.put("_id", String.valueOf(map.get("_id")));
            mapResult.putAll(map);
            list.add(mapResult);
        }
        return ApiResponse.buildOK().setData(list);
    }

    @PostMapping(value={"/query"})
    public ApiResponse queryPost(@RequestBody @Valid MongoDbQueryDTO dto) {
        Query query = new Query();
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        }
        if (!CollectionUtils.isEmpty((Map)dto.getQueryField())) {
            dto.getQueryField().forEach((k, v) -> query.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v)));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIncludeField())) {
            query.fields().include(new String[]{"_id", dto.getIncludeField()});
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getIncludeFields())) {
            dto.getIncludeFields().forEach(arg_0 -> ((Field)query.fields()).include(arg_0));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getExcludeFields())) {
            dto.getExcludeFields().forEach(arg_0 -> ((Field)query.fields()).exclude(arg_0));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        ArrayList list = new ArrayList();
        List mongoDbList = null;
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            mongoDbList = this.mongoTemplate.find(query, Map.class, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            mongoDbList = this.secondMongoTemplate.find(query, Map.class, dto.getCollectionName());
        }
        if (CollectionUtils.isEmpty(mongoDbList)) {
            return ApiResponse.buildOK((String)"\u6682\u65e0\u6570\u636e");
        }
        for (Map map : mongoDbList) {
            HashMap mapResult = new HashMap(map.size());
            map.put("_id", String.valueOf(map.get("_id")));
            mapResult.putAll(map);
            list.add(mapResult);
        }
        return ApiResponse.buildOK().setData(list);
    }

    @PostMapping(value={"/update"})
    public ApiResponse updateLoggingLevel(@RequestBody @Valid MongoDbUpdateDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        Update update = new Update();
        if (ObjectUtils.isNotEmpty((Object)dto.getMapData())) {
            for (Map.Entry s : dto.getMapData().entrySet()) {
                update.set((String)s.getKey(), dto.getMapData().get(s.getKey()));
            }
            if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, dto.getCollectionName());
            }
            if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
                this.secondMongoTemplate.updateFirst(query, (UpdateDefinition)update, dto.getCollectionName());
            }
        }
        Map map = null;
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            map = (Map)this.mongoTemplate.findById((Object)dto.getId(), Map.class, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            map = (Map)this.secondMongoTemplate.findById((Object)dto.getId(), Map.class, dto.getCollectionName());
        }
        return ApiResponse.buildOK().setData(map);
    }

    @PostMapping(value={"/add"})
    public ApiResponse add(@RequestBody @Valid MongoDbAddDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        if (ObjectUtils.isEmpty((Object)dto.getMapData())) {
            return ApiResponse.buildError((String)"mapData\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)MapUtils.getString((Map)dto.getMapData(), (Object)"_id"))) {
            return ApiResponse.buildError((String)"mapData\u8bf7\u4f20\u5165_id");
        }
        String id = MapUtils.getString((Map)dto.getMapData(), (Object)"_id");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        boolean isExist = false;
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            isExist = this.mongoTemplate.exists(query, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            isExist = this.secondMongoTemplate.exists(query, dto.getCollectionName());
        }
        if (isExist) {
            return ApiResponse.buildError((String)"mapData\u4e2d\u5bf9\u5e94id\u5df2\u5b58\u5728");
        }
        dto.getMapData().put("_id", new ObjectId(MapUtils.getString((Map)dto.getMapData(), (Object)"_id")));
        BasicDBObject dbObject = new BasicDBObject();
        dbObject.putAll(dto.getMapData());
        BasicDBObject result = new BasicDBObject();
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            result = (DBObject)this.mongoTemplate.save((Object)dbObject, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            result = (DBObject)this.secondMongoTemplate.save((Object)dbObject, dto.getCollectionName());
        }
        if (Objects.nonNull(result)) {
            result.put("_id", (Object)String.valueOf(result.get("_id")));
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/delete"})
    public ApiResponse delete(@RequestBody @Valid MongoDbDeleteDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ApiResponse.buildError((String)"\u53e3\u4ee4\u9519\u8bef");
        }
        Map<String, String> dataMap = new HashMap();
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            dataMap = (Map)this.mongoTemplate.findById((Object)new ObjectId(dto.getId()), Map.class, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            dataMap = (Map)this.secondMongoTemplate.findById((Object)new ObjectId(dto.getId()), Map.class, dto.getCollectionName());
        }
        if (CollectionUtils.isEmpty(dataMap)) {
            return ApiResponse.buildError((String)"\u6b64id\u5bf9\u5e94\u6570\u636e\u4e0d\u5b58\u5728");
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        if ("\u4e3b\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            this.mongoTemplate.remove(query, dto.getCollectionName());
        }
        if ("\u526f\u5e93".equalsIgnoreCase(dto.getDatabaseName())) {
            this.secondMongoTemplate.remove(query, dto.getCollectionName());
        }
        dataMap.put("_id", String.valueOf(dataMap.get("_id")));
        return ApiResponse.buildOK().setData(dataMap);
    }
}

