/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mongodb.designerconfig;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.DataVersionEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class MobileDesignerConfigRepository {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private TaskFilterService taskFilterService;

    public Boolean isExsitTmActivityId(String tmActivityId, String type, String version) {
        return this.findOne(tmActivityId, type, version) != null;
    }

    public Boolean isExsitTmActivityIdOfNotAppCode(String tmActivityId, String type, String version, Set<String> notAppCodeList) {
        return this.findOne(tmActivityId, type, version, notAppCodeList) != null;
    }

    private MobileDesignerConfig findOne(String tmActivityId, String type, String version) {
        return this.findOne(tmActivityId, type, version, null);
    }

    private MobileDesignerConfig findOne(String tmActivityId, String type, String version, Set<String> notAppCodeList) {
        Query queryAll = new Query();
        queryAll.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version)).fields().exclude("data").exclude("rules");
        List list = this.mongoTemplate.find(queryAll, MobileDesignerConfig.class).stream().filter(config -> {
            if (CollectionUtils.isEmpty((Collection)notAppCodeList)) {
                return true;
            }
            return !notAppCodeList.contains(config.getApplication());
        }).filter(config -> config.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (MobileDesignerConfig designerConfig : list) {
            boolean match = TaskFilter.match((String)tmActivityId, (String)designerConfig.getTmActivityId(), (String)designerConfig.getTmActivityIdMatch());
            if (!match) continue;
            tmActivityId = designerConfig.getTmActivityId();
            break;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)tmActivityId)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        MobileDesignerConfig findOne = (MobileDesignerConfig)this.mongoTemplate.findOne(query, MobileDesignerConfig.class);
        return Optional.ofNullable(findOne).orElse(new MobileDesignerConfig()).validWithAppEnvType(AppContext.getEnvType()) != false ? findOne : null;
    }

    public MobileDesignerConfig selectOneDsl(String tmActivityId, String type) {
        return this.findOne(tmActivityId, type, DataVersionEnum.V1_0.getVersion());
    }

    public MobileDesignerConfig selectAllRule(String tmActivityId, String type) {
        MobileDesignerConfig designerConfig = this.findOne(tmActivityId, type, DataVersionEnum.V1_0.getVersion());
        if (designerConfig == null) {
            return designerConfig;
        }
        return designerConfig;
    }

    public List<MobileDesignerConfig> findByType(String type, String version, Set<String> notAppCodeList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        if (!CollectionUtils.isEmpty(notAppCodeList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").nin(notAppCodeList));
        }
        return this.mongoTemplate.find(query, MobileDesignerConfig.class).stream().filter(config -> config.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.findAllAndRemove(query, MobileDesignerConfig.class);
        this.secondMongoTemplate.findAllAndRemove(query, MobileDesignerConfig.class);
    }

    public List<MobileDesignerConfig> selectByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List list = this.mongoTemplate.find(query, MobileDesignerConfig.class);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    public void batchInsert(List<MobileDesignerConfig> mobileDesignerConfigs) {
        if (CollectionUtils.isEmpty(mobileDesignerConfigs)) {
            return;
        }
        this.mongoTemplate.insertAll(mobileDesignerConfigs);
        this.secondMongoTemplate.insertAll(mobileDesignerConfigs);
    }

    public void updataData(MobileDesignerConfig config) {
        if (config == null || !StringUtils.hasLength((String)config.getTmActivityId()) || config.getData() == null || !StringUtils.hasLength((String)config.getApplication())) {
            return;
        }
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)config.getTmActivityId())).addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)config.getApplication()));
        if (this.mongoTemplate.findOne(query, MobileDesignerConfig.class) == null) {
            return;
        }
        Update update = new Update().set("data", (Object)config.getData());
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, MobileDesignerConfig.class);
        this.secondMongoTemplate.updateMulti(query, (UpdateDefinition)update, MobileDesignerConfig.class);
    }
}

