/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.navigation;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.gptai.GptAiModel;
import com.digiwin.mobile.mobileuibot.gptai.GptAiService;
import com.digiwin.mobile.mobileuibot.navigation.BottomNavigation;
import com.digiwin.mobile.mobileuibot.navigation.Navigation;
import com.digiwin.mobile.mobileuibot.navigation.NavigationService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/navigation"})
public class NavigationController {
    private static final Logger log = LoggerFactory.getLogger(NavigationController.class);
    private static int GPT_AI_HAVE_PERMISSION = 1;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private UiBotService uiBotService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private GptAiService gptAiService;
    @Autowired
    private AiAssistantService aiAssistantService;

    @RequestMapping(value={"/bottom"}, method={RequestMethod.POST})
    public ApiResponse<List<BottomNavigation>> getBottomNavigation(@RequestBody ApiRequest apiRequest) throws IOException {
        if (BooleanUtils.isTrue((Boolean)AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            String bottomNavigationString = FileUtil.readText((String)"./static/agiledata/agileData-privatization-bottom.json");
            List bottomNavigationList = (List)JsonUtil.jsonStringToObject((String)bottomNavigationString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return ApiResponse.buildOK().setData((Object)bottomNavigationList);
        }
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            return this.doMockData();
        }
        String locale = apiRequest.getLocale();
        if (!TestController.specialHandleSwitch() && this.uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
            return ApiResponse.buildOK().setData(Collections.emptyList());
        }
        Navigation navigation = !TestController.specialHandleSwitch() ? this.navigationService.findFirst() : (Navigation)JsonUtil.jsonStringToObject((String)this.getBottomNavigationMockData(), Navigation.class);
        if (navigation != null) {
            List bottomNavigationList = navigation.getBottomNavigations();
            if (bottomNavigationList != null) {
                ArrayList list = new ArrayList();
                for (BottomNavigation bottomNavigation : bottomNavigationList) {
                    this.handleNanaAuthorizations(apiRequest, bottomNavigation, list);
                    bottomNavigation.setPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)bottomNavigation.getPageId()));
                    bottomNavigation.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)bottomNavigation.getPageId()));
                }
                if (CollectionUtils.isEmpty(list)) {
                    bottomNavigationList.removeIf(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId()));
                }
            }
            return ApiResponse.buildOK().setData((Object)navigation.getBottomNavigations());
        }
        return ApiResponse.buildError();
    }

    private String getBottomNavigationMockData() {
        return "{   \n    \"_id\" : \"613b08f3530e71620cc5e111\", \n    \"bottomNavigations\" : [\n        {\n            \"iconData\" : 59110, \n            \"name\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n            \"pageId\" : \"NOTIFICATION_PAGE\", \n            \"pageTitle\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 59111, \n            \"name\" : \"${i18n-dj-mobile-INDEX}\", \n            \"pageId\" : \"INDEX\", \n            \"pageTitle\" : \"${i18n-dj-mobile-INDEX}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 59111, \n            \"name\" : \"${i18n-dj-mobile-GPT_AI}\", \n            \"pageId\" : \"GPT_AI\", \n            \"pageTitle\" : \"${i18n-dj-mobile-GPT_AI}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 58939, \n            \"name\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n            \"pageId\" : \"MOBILE_MY_TODO\", \n            \"pageTitle\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n            \"showName\" : false, \n            \"calenderType\" : 2\n        }, \n        {\n            \"iconData\" : 59112, \n            \"name\" : \"${i18n-dj-mobile-DASHBOARD}\", \n            \"pageId\" : \"DASHBOARD\", \n            \"pageTitle\" : \"${i18n-dj-mobile-DASHBOARD}\", \n            \"showName\" : false\n        }\n    ]\n}\n";
    }

    private void handleNanaAuthorizations(ApiRequest apiRequest, BottomNavigation bottomNavigation, List<GptAiModel> list) {
        if (PageSettingIdPresetEnum.GPT_AI.name().equals(bottomNavigation.getPageId())) {
            try {
                int assistantCount = this.aiAssistantService.queryAssistantCount(apiRequest);
                if (assistantCount != 0) {
                    list.add(new GptAiModel());
                }
            }
            catch (Exception e) {
                log.error("query product buy status error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private ApiResponse<List<BottomNavigation>> doMockData() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List apiData = null;
        String data = FileUtil.readText((String)"static/appstore-use/navigation-bottom.json");
        if (null != data && !data.isEmpty()) {
            apiData = (List)JsonUtil.jsonStringToObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        return ApiResponse.buildOK().setData(apiData);
    }
}

