/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationReadStateEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaPcNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.BadgeRemoveRuleEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.BadgeShowTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummaryBadge;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummarySubject;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageBoardCommenter;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSummary
implements Serializable {
    private static final long serialVersionUID = 3253780939513502434L;
    private static final Logger logger = LoggerFactory.getLogger(NotificationSummary.class);
    private NotificationSummaryBadge badge;
    private String categoryId;
    private String categoryName;
    private String categoryNameDesc;
    private String jumpPageId;
    private String jumpPageTitle;
    private NotificationSummarySubject latestNotification;

    @Deprecated
    public static NotificationSummary create(String locale, DigiwinAimMessageSummary digiwinAimMessageSummary) {
        NotificationSummary notificationSummary = new NotificationSummary();
        String pcSubTypeCategory = digiwinAimMessageSummary.getSubTypeCategory();
        if (pcSubTypeCategory.equals(AthenaPcNotificationCategoryEnum.PROXY_REMIND.toString()) || pcSubTypeCategory.equals(AthenaPcNotificationCategoryEnum.ATHENA_REMIND.toString()) || pcSubTypeCategory.equals(AthenaPcNotificationCategoryEnum.EXCEPTION_OR_OVERDUE.toString())) {
            notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString());
            notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
        } else {
            if (pcSubTypeCategory.equals(AthenaPcNotificationCategoryEnum.INTERNAL_REMIND.toString())) {
                return null;
            }
            notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString());
            notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString()));
        }
        notificationSummary.setBadge(NotificationSummaryBadge.create((DigiwinAimMessageSummary)digiwinAimMessageSummary, (String)notificationSummary.getCategoryId()));
        notificationSummary.setJumpPageId(notificationSummary.getCategoryId());
        notificationSummary.setJumpPageTitle(notificationSummary.getCategoryName());
        notificationSummary.setLatestNotification(NotificationSummarySubject.create((String)locale, (DigiwinAimMessageSummary)digiwinAimMessageSummary));
        return notificationSummary;
    }

    @Deprecated
    public static NotificationSummary create(String locale, List<DigiwinAtmcBacklog> digiwinAtmcBacklogList) {
        NotificationSummary notificationSummary = new NotificationSummary();
        Integer overdueCount = (int)digiwinAtmcBacklogList.stream().filter(backlog -> backlog.getOverdue().equals(Boolean.TRUE)).count();
        Integer todayEndExceptOverdueCount = (int)digiwinAtmcBacklogList.stream().filter(backlog -> DateTimeUtil.isTodayTime((String)backlog.getEndTime()).equals(Boolean.TRUE)).filter(backlog -> !backlog.getOverdue().equals(Boolean.TRUE)).count();
        notificationSummary.setBadge(NotificationSummaryBadge.create((Integer)(overdueCount + todayEndExceptOverdueCount)));
        notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO.toString());
        notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO.toString()));
        notificationSummary.setJumpPageId(notificationSummary.getCategoryId());
        notificationSummary.setJumpPageTitle(notificationSummary.getCategoryName());
        notificationSummary.setLatestNotification(NotificationSummarySubject.create((String)locale, digiwinAtmcBacklogList));
        return notificationSummary;
    }

    @Deprecated
    public static NotificationSummary createMyProject(String locale) {
        NotificationSummary notificationSummary = new NotificationSummary();
        notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_MY_PROJECT.toString());
        notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_MY_PROJECT.toString()));
        String content = LocaleUtil.getMobileTextByKey((String)locale, (String)"ATHENA_MY_PROJECT_PROMPT");
        notificationSummary.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT.toString());
        notificationSummary.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT.toString()));
        notificationSummary.setLatestNotification(new NotificationSummarySubject(content));
        return notificationSummary;
    }

    @Deprecated
    public static NotificationSummary createPersonal(String locale, DigiwinAimMessageBoardCommenter commenter, List<DigiwinAimMessage> digiwinAimMessages) {
        NotificationSummary notificationSummary = new NotificationSummary();
        Long unreadCount = digiwinAimMessages.stream().filter(digiwinAimMessage -> digiwinAimMessage.getState().equals(AthenaNotificationReadStateEnum.UNREAD.getState())).count();
        notificationSummary.setBadge(new NotificationSummaryBadge(Integer.valueOf(unreadCount.intValue()), BadgeRemoveRuleEnum.REMOVE_AFTER_TAP.getType(), BadgeShowTypeEnum.SHOW_IN_NUMBER.getType()));
        notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_INTERNAL_PERSONAL.toString() + commenter.getUserId());
        notificationSummary.setCategoryName(commenter.getUserName());
        notificationSummary.setJumpPageId(AthenaMobileNotificationCategoryEnum.MOBILE_INTERNAL_PERSONAL.toString());
        notificationSummary.setJumpPageTitle(commenter.getUserName());
        notificationSummary.setLatestNotification(NotificationSummarySubject.createPersonal((String)locale, (DigiwinAimMessage)digiwinAimMessages.get(0)));
        return notificationSummary;
    }

    public static NotificationSummary createAthenaWelcomeSummary(String locale) {
        NotificationSummary notificationSummary = new NotificationSummary();
        notificationSummary.setBadge(new NotificationSummaryBadge(Integer.valueOf(0), BadgeRemoveRuleEnum.REMOVE_AFTER_TAP.getType(), BadgeShowTypeEnum.SHOW_IN_NUMBER.getType()));
        notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString());
        notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
        String content = LocaleUtil.getMobileTextByKey((String)locale, (String)"WELCOME_TO_ATHENA");
        notificationSummary.setJumpPageId(notificationSummary.getCategoryId());
        notificationSummary.setJumpPageTitle(notificationSummary.getCategoryName());
        notificationSummary.setLatestNotification(new NotificationSummarySubject(content));
        return notificationSummary;
    }

    public static NotificationSummary create(String locale, DigiwinAimMessage aimMessageSummary, Integer unRead, LocaleService localeService) {
        NotificationSummary notificationSummary = new NotificationSummary();
        String pcSubTypeCategory = aimMessageSummary.getSubTypeCategory();
        notificationSummary.setCategoryId(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString());
        notificationSummary.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
        notificationSummary.setBadge(NotificationSummaryBadge.create((DigiwinAimMessage)aimMessageSummary, (String)notificationSummary.getCategoryId(), (Integer)unRead));
        notificationSummary.setJumpPageId(notificationSummary.getCategoryId());
        notificationSummary.setJumpPageTitle(notificationSummary.getCategoryName());
        notificationSummary.setLatestNotification(NotificationSummarySubject.create((String)locale, (DigiwinAimMessage)aimMessageSummary, (LocaleService)localeService));
        return notificationSummary;
    }

    public NotificationSummary merge(NotificationSummary notificationSummary) {
        LocalDateTime comparedLatest;
        if (!notificationSummary.getCategoryId().equals(this.getCategoryId())) {
            logger.debug("categoryIds are different, we will do noting and just return....");
            return this;
        }
        NotificationSummarySubject currentLatestNotification = this.getLatestNotification();
        LocalDateTime currentLatest = DateTimeUtil.parseUseDefaultPattern((String)currentLatestNotification.getPublishTime());
        if (currentLatest.isBefore(comparedLatest = DateTimeUtil.parseUseDefaultPattern((String)notificationSummary.getLatestNotification().getPublishTime()))) {
            this.setLatestNotification(notificationSummary.getLatestNotification());
        }
        return this;
    }

    public NotificationSummaryBadge getBadge() {
        return this.badge;
    }

    public void setBadge(NotificationSummaryBadge badge) {
        this.badge = badge;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryNameDesc() {
        return this.categoryNameDesc;
    }

    public void setCategoryNameDesc(String categoryNameDesc) {
        this.categoryNameDesc = categoryNameDesc;
    }

    public String getJumpPageId() {
        return this.jumpPageId;
    }

    public void setJumpPageId(String jumpPageId) {
        this.jumpPageId = jumpPageId;
    }

    public String getJumpPageTitle() {
        return this.jumpPageTitle;
    }

    public void setJumpPageTitle(String jumpPageTitle) {
        this.jumpPageTitle = jumpPageTitle;
    }

    public NotificationSummarySubject getLatestNotification() {
        return this.latestNotification;
    }

    public void setLatestNotification(NotificationSummarySubject latestNotification) {
        this.latestNotification = latestNotification;
    }
}

