/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationLabel;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageBoard;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContent;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import java.io.Serializable;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationSummarySubject
implements Serializable {
    private static final long serialVersionUID = 829508695582178904L;
    private String content;
    private NotificationLabel label;
    private String publishTime;
    private String gid;

    public static NotificationSummarySubject create(String locale, DigiwinAimMessageSummary digiwinAimMessageSummary) {
        NotificationSummarySubject summarySubject = new NotificationSummarySubject();
        summarySubject.setContent(NotificationSummarySubject.calculateWithTitleAndContent((String)digiwinAimMessageSummary.getMessage().getTitle(), (String)digiwinAimMessageSummary.getMessage().getContent().getMsg()));
        summarySubject.setLabel(NotificationLabel.create((String)locale, (DigiwinAimMessageSummary)digiwinAimMessageSummary));
        if (digiwinAimMessageSummary.getMessage().getContent().getStartTime().contains("T")) {
            summarySubject.setPublishTime(digiwinAimMessageSummary.getMessage().getCreateDate());
        } else {
            summarySubject.setPublishTime(digiwinAimMessageSummary.getMessage().getSendDate());
        }
        summarySubject.setGid(digiwinAimMessageSummary.getMessage().getGid());
        return summarySubject;
    }

    public static NotificationSummarySubject create(String locale, List<DigiwinAtmcBacklog> digiwinAtmcBacklogList) {
        NotificationSummarySubject summarySubject = new NotificationSummarySubject();
        long overdueBacklogCount = digiwinAtmcBacklogList.stream().filter(digiwinAtmcBacklog -> digiwinAtmcBacklog.getOverdue().equals(true)).count();
        summarySubject.setContent(TaskStringUtil.getTaskInNotificationSummaryContent((String)locale, (long)overdueBacklogCount));
        summarySubject.setLabel(null);
        summarySubject.setPublishTime("");
        return summarySubject;
    }

    public static NotificationSummarySubject createPersonal(String locale, DigiwinAimMessage digiwinAimMessage) {
        NotificationSummarySubject summarySubject = new NotificationSummarySubject();
        summarySubject.setContent(((DigiwinAimMessageBoard)digiwinAimMessage.getContent().getMessageBoard().get(0)).getComment());
        summarySubject.setPublishTime(digiwinAimMessage.getSendDate());
        return summarySubject;
    }

    public static String calculateWithTitleAndContent(String title, String content) {
        String result = title != null ? (title.trim().length() > 0 && (content == null || content.trim().length() == 0) ? title : (title.trim().length() == 0 && content != null && content.trim().length() > 0 ? content : (title.trim().length() > 0 && content != null && content.trim().length() > 0 ? title + " " + content : ""))) : "";
        return result;
    }

    public NotificationSummarySubject() {
    }

    public NotificationSummarySubject(String content) {
        this.content = content;
    }

    public NotificationSummarySubject(String content, NotificationLabel label, String publishTime) {
        this.content = content;
        this.label = label;
        this.publishTime = publishTime;
    }

    public static NotificationSummarySubject create(String locale, DigiwinAimMessage aimMessageSummary, LocaleService localeService) {
        NotificationSummarySubject summarySubject = new NotificationSummarySubject();
        if (AthenaMessageTypeEnum.EOC.getType().equals(aimMessageSummary.getType())) {
            summarySubject.setContent(localeService.getLanguageValue(locale, "\u4e91\u63a7\u5236\u53f0\u5c1a\u6709\u91cd\u8981\u8bbe\u5b9a\u672a\u5b8c\u6210\uff0c\u5c06\u5bfc\u81f4\u96c5\u5178\u5a1c\u53d1\u6210\u4e0d\u53ef\u9884\u671f\u7684\u5f02\u5e38\uff0c\u8bf7\u5173\u6ce8~"));
        } else if (AthenaMessageTypeEnum.REMINDER.getType().equals(aimMessageSummary.getType())) {
            String str = "";
            if (aimMessageSummary.getContent() != null) {
                DigiwinAimMessageContent content = aimMessageSummary.getContent();
                str = localeService.getLanguageValue(locale, "\u60a8\u7684\u4efb\u52a1") + content.getTaskName() + localeService.getLanguageValue(locale, "\u5373\u5c06\u903e\u671f") + "\uff0c" + localeService.getLanguageValue(locale, "\u6240\u5c5e\u9879\u76ee") + content.getProjectName() + "\uff0c" + localeService.getLanguageValue(locale, "\u9879\u76ee\u53d1\u8d77\u4eba") + content.getPersonInChargeName();
            }
            summarySubject.setContent(str);
        } else if (AthenaMessageTypeEnum.BASE_DATA_ENTRY.getType().equals(aimMessageSummary.getType())) {
            String str = "";
            if (aimMessageSummary.getContent() != null) {
                Integer failedNum = aimMessageSummary.getContent().getFailedNum();
                Integer succeededNumN = aimMessageSummary.getContent().getSucceededNum();
                Integer processingNum = aimMessageSummary.getContent().getProcessingNum();
                if (aimMessageSummary.getContent().getActivityName() != null) {
                    str = "en_US".equals(locale) ? aimMessageSummary.getContent().getActivityName().getEnUSName() : ("zh_TW".equals(locale) ? aimMessageSummary.getContent().getActivityName().getZhTWName() : aimMessageSummary.getContent().getActivityName().getDefaultName());
                }
                if (AthenaNotificationTypeEnum.EXCEPTION.toString().equals(aimMessageSummary.getCategory())) {
                    str = str + " " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5bfc\u5165\u5f02\u5e38\uff0c\u603b\u6570") + (failedNum + succeededNumN + processingNum) + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7b14") + "," + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f02\u5e38") + failedNum + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7b14") + "\u3002";
                } else if (AthenaNotificationTypeEnum.OTHER.toString().equals(aimMessageSummary.getCategory())) {
                    str = str + " " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5bfc\u5165\u6210\u529f\uff0c\u603b\u6570") + (failedNum + succeededNumN + processingNum) + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7b14") + "\u3002";
                }
            }
            summarySubject.setContent(str);
        } else if (AthenaMessageTypeEnum.AGILE_DATA_DETAIL.getType().equals(aimMessageSummary.getType())) {
            summarySubject.setContent(NotificationSummarySubject.calculateWithTitleAndContent((String)aimMessageSummary.getTitle(), (String)aimMessageSummary.getContent().getTitle()));
        } else if (AthenaMessageTypeEnum.TEXT.getType().equals(aimMessageSummary.getType())) {
            summarySubject.setContent(NotificationSummarySubject.calculateWithTitleAndContent((String)aimMessageSummary.getTitle(), (String)aimMessageSummary.getContent().getMsg()));
        } else {
            summarySubject.setContent(NotificationSummarySubject.calculateWithTitleAndContent((String)aimMessageSummary.getTitle(), (String)aimMessageSummary.getContent().getMsg()));
        }
        summarySubject.setLabel(NotificationLabel.create((String)locale, (DigiwinAimMessage)aimMessageSummary));
        if (aimMessageSummary.getContent() != null && aimMessageSummary.getContent().getStartTime() != null && aimMessageSummary.getContent().getStartTime().contains("T")) {
            summarySubject.setPublishTime(aimMessageSummary.getCreateDate());
        } else {
            summarySubject.setPublishTime(aimMessageSummary.getSendDate());
        }
        summarySubject.setGid(aimMessageSummary.getGid());
        return summarySubject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public NotificationLabel getLabel() {
        return this.label;
    }

    public void setLabel(NotificationLabel label) {
        this.label = label;
    }

    public String getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(String publishTime) {
        this.publishTime = publishTime;
    }

    public String getGid() {
        return this.gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }
}

