/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.strategy;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetail;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetailPersonalCard;
import com.digiwin.mobile.mobileuibot.notification.strategy.NotificationDetailStrategy;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContent;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimNewMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskShare;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="notificationDetailChattingStrategy")
public class NotificationDetailChattingStrategy
implements NotificationDetailStrategy {
    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public List<NotificationDetail> listNotificationDetails(String userId, String clientId, String locale, String iamUserToken, String tenantId, String mobileNotificationCategoryId, String dataId, Integer pageNum, Integer pageSize) throws IOException {
        List digiwinAimMessages = new ArrayList();
        DigiwinAimNewMessageSummary digiwinAimNewMessageSummary = this.digiwinAimProxyService.listMessageSummary(locale, iamUserToken, pageNum, pageSize);
        if (digiwinAimNewMessageSummary != null) {
            digiwinAimMessages = digiwinAimNewMessageSummary.getContent();
        }
        ArrayList<NotificationDetail> notificationDetails = new ArrayList<NotificationDetail>();
        if (pageNum < 1 && mobileNotificationCategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()) && digiwinAimMessages.isEmpty()) {
            notificationDetails.add(NotificationDetail.createAthenaWelcomeDetail((String)locale));
            return notificationDetails;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List filterList = this.activityFilterService.listValidInAthenaOfTaskFilter(tenantId, tenantVersion);
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);
        List customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();
        DigiwinIamUserInfo userInfo = this.digiwinIamProxyService.userInfoById(userId, iamUserToken, locale);
        Optional<DigiwinIamTenant> tenantOptional = this.digiwinIamProxyService.listUserTenantsInAthena(iamUserToken).stream().filter(tenant -> tenantId.equals(tenant.getId())).findFirst();
        for (DigiwinAimMessage aimMessage : digiwinAimMessages) {
            NotificationDetail detail = null;
            NotificationDetailPersonalCard personalCard = null;
            boolean msgContentIdEmpty = false;
            if (Optional.ofNullable(aimMessage.getContent()).map(DigiwinAimMessageContent::getId).orElse("").isEmpty()) {
                msgContentIdEmpty = true;
            }
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail1 = new DigiwinAtmcBacklogDetail();
            if (AthenaMessageTypeEnum.ACTIVITY.getType().equals(aimMessage.getType())) {
                DigiwinAtmcTaskShare digiwinAtmcTaskShare;
                DigiwinAimMessageContent digiwinAimMessageContent = aimMessage.getContent();
                if (digiwinAimMessageContent != null && StringUtils.hasLength((String)digiwinAimMessageContent.getShareCode()) && (digiwinAtmcTaskShare = this.digiwinAtmcProxyService.getShareTask(locale, iamUserToken, digiwinAimMessageContent.getShareCode())) != null && digiwinAtmcTaskShare.getTaskId() != null) {
                    DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, digiwinAtmcTaskShare.getTaskId() + "");
                    personalCard = NotificationDetailPersonalCard.create((String)locale, (String)iamUserToken, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (DigiwinAimMessage)aimMessage, (List)pageTaskRelationList, (List)filterList, (String)tenantId, (String)tenantVersion);
                }
                if (digiwinAimMessageContent != null && StringUtil.isNotEmpty((CharSequence)digiwinAimMessageContent.getId())) {
                    digiwinAtmcBacklogDetail1 = msgContentIdEmpty ? new DigiwinAtmcBacklogDetail() : this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, aimMessage.getContent().getId());
                    personalCard = NotificationDetailPersonalCard.create((String)locale, (String)iamUserToken, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail1, (DigiwinAimMessage)aimMessage, (List)pageTaskRelationList, (List)filterList, (String)tenantId, (String)tenantVersion);
                }
            } else if (AthenaMessageTypeEnum.TASK.getType().equals(aimMessage.getType())) {
                // empty if block
            }
            detail = NotificationDetail.create((String)locale, (DigiwinAimMessage)aimMessage, personalCard, (String)mobileNotificationCategoryId, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail1, (List)customTaskConfigList, (String)iamUserToken);
            if (AthenaMessageTypeEnum.EOC.getType().equals(aimMessage.getType())) {
                this.buildResultByEOC(locale, detail, aimMessage, userInfo, tenantOptional);
            }
            notificationDetails.add(detail);
        }
        notificationDetails.sort((o1, o2) -> {
            LocalDateTime o2NotificationSendDateTime;
            LocalDateTime o1NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getPublishTime());
            if (o1NotificationSendDateTime.isBefore(o2NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getPublishTime()))) {
                return 1;
            }
            if (o1NotificationSendDateTime.isEqual(o2NotificationSendDateTime)) {
                return 0;
            }
            return -1;
        });
        return notificationDetails;
    }

    private void buildResultByEOC(String locale, NotificationDetail result, DigiwinAimMessage aimMessage, DigiwinIamUserInfo userInfo, Optional<DigiwinIamTenant> tenantOptional) {
        HashMap<String, Object> msgContent = new HashMap<String, Object>();
        result.setMsgContent(msgContent);
        StringBuilder usersb = new StringBuilder();
        if (null != userInfo) {
            usersb.append(userInfo.getName()).append(" ");
        }
        StringBuilder settingMsg = new StringBuilder();
        Object eocMsg = aimMessage.getContent().getEocMsg();
        if (null != eocMsg) {
            List msgList = (List)JsonUtil.objectToJavaObject((Object)eocMsg, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            msgList.forEach(msg -> {
                if (StringUtils.hasLength((String)msg)) {
                    try {
                        String first = msg.substring(0, 1);
                        String second = msg.substring(1, 2);
                        String other = msg.substring(2);
                        settingMsg.append(this.localeService.getLanguageValue(locale, first)).append(second).append(this.localeService.getLanguageValue(locale, other)).append(";");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        msgContent.put("title", usersb.append(this.localeService.getLanguageValue(locale, "\u4f60\u597d")).append(":").toString());
        msgContent.put("subTitle", this.localeService.getLanguageValue(locale, "\u96c5\u5178\u5a1c\u79df\u6237") + "\u3010" + tenantOptional.map(DigiwinIamTenant::getName).orElse("") + " ( " + tenantOptional.map(DigiwinIamTenant::getId).orElse("") + " )\u3011" + this.localeService.getLanguageValue(locale, "\u5f53\u524d\u7528\u6237\u8bbe\u5b9a\u4e0d\u5b8c\u6574") + "," + this.localeService.getLanguageValue(locale, "\u8bf7\u81f3\u4e91\u63a7\u5236\u53f0\u5b8c\u6210\u4ee5\u4e0b\u91cd\u8981\u8bbe\u5b9a") + ": " + settingMsg.toString() + this.localeService.getLanguageValue(locale, "\u8be6\u89c1\u4e0b\u8868\u660e\u7ec6"));
        msgContent.put("content", Optional.ofNullable(aimMessage.getContent()).map(DigiwinAimMessageContent::getData).orElse(Collections.emptyList()));
        msgContent.put("hint", this.localeService.getLanguageValue(locale, "\u53cb\u5584\u63d0\u9192\uff1a\u672a\u5b8c\u6210\u4e0a\u8ff0\u8bbe\u5b9a\u5c06\u5bfc\u81f4\u76f8\u5173\u7528\u6237\u4f7f\u7528\u96c5\u5178\u5a1c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u9884\u671f\u7684\u5f02\u5e38"));
        msgContent.put("bottom", this.localeService.getLanguageValue(locale, "\u5177\u4f53\u8be6\u60c5\u8bf7\u901a\u8fc7web\u7aef\u4e91\u63a7\u5236\u53f0\u67e5\u770b"));
    }
}

