/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.openapi.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcMobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcMobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcPageTaskRelation;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcPageTaskRelationRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTaskFilter;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTaskFilterRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTenantRelation;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTenantRelationRepository;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.AppPublishOperateEnum;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.DataVersionEnum;
import com.digiwin.mobile.mobileuibot.openapi.designer.request.AppPublishVO;
import com.digiwin.mobile.mobileuibot.openapi.service.OpenApiService;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterCategoryEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterFromEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterParam;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OpenApiServiceImpl
implements OpenApiService {
    private static final Logger log = LoggerFactory.getLogger(OpenApiServiceImpl.class);
    @Autowired
    private TaskFilterRepository taskFilterRepository;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;
    @Autowired
    private UcTaskFilterRepository ucTaskFilterRepository;
    @Autowired
    private UcPageTaskRelationRepository ucPageTaskRelationRepository;
    @Autowired
    private UcMobileDesignerConfigRepository ucMobileDesignerConfigRepository;
    @Autowired
    private UcTenantRelationRepository ucTenantRelationRepository;

    public void publishOrSwitch(AppPublishVO publishVO) {
        if (AppPublishOperateEnum.PUBLISH.getOperate().equals(publishVO.getOperate())) {
            this.publish(publishVO);
        } else if (AppPublishOperateEnum.SWITCH.getOperate().equals(publishVO.getOperate())) {
            this.switchover(publishVO);
        } else {
            log.warn("Unsupported operation: {}", (Object)publishVO.getOperate());
            return;
        }
    }

    private void publish(AppPublishVO publishVO) {
        if (BooleanUtils.isTrue((Boolean)publishVO.getIndividualCase())) {
            this.ucPublish(publishVO);
        } else {
            this.stdPublish(publishVO);
        }
    }

    private void stdPublish(AppPublishVO publishVO) {
        this.deleteStdVersion(publishVO.getAppCode(), DataVersionEnum.V1_0.getVersion());
        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
        ArrayList taskFilters = new ArrayList();
        ArrayList pageTaskRelations = new ArrayList();
        ArrayList mobileDesignerConfigs = new ArrayList();
        publishVO.getTaskList().forEach(task -> {
            taskFilters.add(this.buildStdTaskFilter(new TaskFilter(), publishVO.getAppCode(), task.getTmActivityId(), time, DataVersionEnum.V1_0.getVersion()));
            pageTaskRelations.add(this.buildStdPageTaskRelation(new PageTaskRelation(), publishVO.getAppCode(), task.getTmActivityId(), time, DataVersionEnum.V1_0.getVersion()));
            mobileDesignerConfigs.add(this.buildStdMobileDesignerConfig(new MobileDesignerConfig(), publishVO.getAppCode(), task.getTmActivityId(), MobileDesignerConfigTypeEnum.TASK.getValue(), time, DataVersionEnum.V1_0.getVersion()));
        });
        publishVO.getProjectList().forEach(project -> mobileDesignerConfigs.add(this.buildStdMobileDesignerConfig(new MobileDesignerConfig(), publishVO.getAppCode(), project.getTmActivityId(), MobileDesignerConfigTypeEnum.PROJECT.getValue(), time, DataVersionEnum.V1_0.getVersion())));
        publishVO.getStartProjectList().forEach(startProject -> mobileDesignerConfigs.add(this.buildStdMobileDesignerConfig(new MobileDesignerConfig(), publishVO.getAppCode(), startProject.getTmActivityId(), MobileDesignerConfigTypeEnum.START_PROJECT.getValue(), time, DataVersionEnum.V1_0.getVersion())));
        publishVO.getDataEntryList().forEach(dataEntry -> mobileDesignerConfigs.add(this.buildStdMobileDesignerConfig(new MobileDesignerConfig(), publishVO.getAppCode(), dataEntry.getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), time, DataVersionEnum.V1_0.getVersion())));
        this.batchInsertStdVersion(taskFilters, pageTaskRelations, mobileDesignerConfigs, DataVersionEnum.V1_0.getVersion());
    }

    private void ucPublish(AppPublishVO publishVO) {
        this.deleteUcVersion(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V1_0.getVersion());
        if (CollectionUtils.isEmpty((Collection)publishVO.getTenantIdList())) {
            log.info("Tenant ID list is empty, skipping insertion.");
            return;
        }
        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
        ArrayList taskFilters = new ArrayList();
        ArrayList pageTaskRelations = new ArrayList();
        ArrayList mobileDesignerConfigs = new ArrayList();
        ArrayList tenantRelations = new ArrayList();
        if (BooleanUtils.isTrue((Boolean)publishVO.getIndividualAll())) {
            publishVO.getTaskList().forEach(task -> {
                taskFilters.add(this.buildUcTaskFilter(publishVO.getUcAppCode(), publishVO.getAppCode(), task.getTmActivityId(), time, DataVersionEnum.V1_0.getVersion()));
                pageTaskRelations.add(this.buildUcPageTaskRelation(publishVO.getUcAppCode(), publishVO.getAppCode(), task.getTmActivityId(), time, DataVersionEnum.V1_0.getVersion()));
                mobileDesignerConfigs.add(this.buildUcMobileDesignerConfig(publishVO.getUcAppCode(), publishVO.getAppCode(), task.getTmActivityId(), MobileDesignerConfigTypeEnum.TASK.getValue(), time, DataVersionEnum.V1_0.getVersion()));
            });
            publishVO.getProjectList().forEach(project -> mobileDesignerConfigs.add(this.buildUcMobileDesignerConfig(publishVO.getUcAppCode(), publishVO.getAppCode(), project.getTmActivityId(), MobileDesignerConfigTypeEnum.PROJECT.getValue(), time, DataVersionEnum.V1_0.getVersion())));
            publishVO.getStartProjectList().forEach(startProject -> mobileDesignerConfigs.add(this.buildUcMobileDesignerConfig(publishVO.getUcAppCode(), publishVO.getAppCode(), startProject.getTmActivityId(), MobileDesignerConfigTypeEnum.START_PROJECT.getValue(), time, DataVersionEnum.V1_0.getVersion())));
        }
        publishVO.getDataEntryList().forEach(dataEntry -> mobileDesignerConfigs.add(this.buildUcMobileDesignerConfig(publishVO.getUcAppCode(), publishVO.getAppCode(), dataEntry.getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), time, DataVersionEnum.V1_0.getVersion())));
        publishVO.getTenantIdList().forEach(tenantId -> tenantRelations.add(this.buildUcTenantRelation(publishVO.getUcAppCode(), publishVO.getAppCode(), tenantId, publishVO.getIndividualAll(), time, DataVersionEnum.V1_0.getVersion())));
        this.batchInsertUcVersion(taskFilters, pageTaskRelations, mobileDesignerConfigs, tenantRelations);
    }

    private void switchover(AppPublishVO publishVO) {
        if (BooleanUtils.isTrue((Boolean)publishVO.getIndividualCase())) {
            this.ucSwitch(publishVO);
        } else {
            this.stdSwitch(publishVO);
        }
    }

    private void stdSwitch(AppPublishVO publishVO) {
        this.deleteStdVersion(publishVO.getAppCode(), DataVersionEnum.V2_0.getVersion());
        List taskFilters = this.taskFilterRepository.selectByCode(publishVO.getAppCode(), DataVersionEnum.V1_0.getVersion());
        List pageTaskRelations = this.pageTaskRelationService.selectByCode(publishVO.getAppCode(), DataVersionEnum.V1_0.getVersion());
        List mobileDesignerConfigs = this.mobileDesignerConfigRepository.selectByCode(publishVO.getAppCode(), DataVersionEnum.V1_0.getVersion());
        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
        taskFilters.forEach(taskFilter -> {
            taskFilter.setId(null);
            taskFilter.setCreateTime(time);
            taskFilter.setUpdateTime(time);
            taskFilter.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        pageTaskRelations.forEach(pageTaskRelation -> {
            pageTaskRelation.setId(null);
            pageTaskRelation.setCreateTime(time);
            pageTaskRelation.setUpdateTime(time);
            pageTaskRelation.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        mobileDesignerConfigs.forEach(mobileDesignerConfig -> {
            mobileDesignerConfig.setId(null);
            mobileDesignerConfig.setCreateTime(time);
            mobileDesignerConfig.setUpdateTime(time);
            mobileDesignerConfig.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        this.batchInsertStdVersion(taskFilters, pageTaskRelations, mobileDesignerConfigs, DataVersionEnum.V2_0.getVersion());
    }

    private void ucSwitch(AppPublishVO publishVO) {
        this.deleteUcVersion(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V2_0.getVersion());
        List taskFilters = this.ucTaskFilterRepository.selectByCode(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V1_0.getVersion());
        List pageTaskRelations = this.ucPageTaskRelationRepository.selectByCode(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V1_0.getVersion());
        List mobileDesignerConfigs = this.ucMobileDesignerConfigRepository.selectByCode(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V1_0.getVersion());
        List tenantRelations = this.ucTenantRelationRepository.selectByCode(publishVO.getAppCode(), publishVO.getUcAppCode(), DataVersionEnum.V1_0.getVersion());
        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
        taskFilters.forEach(taskFilter -> {
            taskFilter.setId(null);
            taskFilter.setCreateTime(time);
            taskFilter.setUpdateTime(time);
            taskFilter.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        pageTaskRelations.forEach(pageTaskRelation -> {
            pageTaskRelation.setId(null);
            pageTaskRelation.setCreateTime(time);
            pageTaskRelation.setUpdateTime(time);
            pageTaskRelation.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        mobileDesignerConfigs.forEach(mobileDesignerConfig -> {
            mobileDesignerConfig.setId(null);
            mobileDesignerConfig.setCreateTime(time);
            mobileDesignerConfig.setUpdateTime(time);
            mobileDesignerConfig.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        tenantRelations.forEach(tenantRelation -> {
            tenantRelation.setId(null);
            tenantRelation.setCreateTime(time);
            tenantRelation.setUpdateTime(time);
            tenantRelation.setVersion(DataVersionEnum.V2_0.getVersion());
        });
        this.batchInsertUcVersion(taskFilters, pageTaskRelations, mobileDesignerConfigs, tenantRelations);
    }

    private void deleteStdVersion(String appCode, String version) {
        this.taskFilterRepository.deleteByCode(appCode, version);
        this.pageTaskRelationService.deleteByCode(appCode, version);
        this.mobileDesignerConfigRepository.deleteByCode(appCode, version);
    }

    private void deleteUcVersion(String appCode, String ucAppCode, String version) {
        this.ucTaskFilterRepository.deleteByCode(appCode, ucAppCode, version);
        this.ucPageTaskRelationRepository.deleteByCode(appCode, ucAppCode, version);
        this.ucMobileDesignerConfigRepository.deleteByCode(appCode, ucAppCode, version);
        this.ucTenantRelationRepository.deleteByCode(appCode, ucAppCode, version);
    }

    private void batchInsertStdVersion(List<TaskFilter> taskFilters, List<PageTaskRelation> pageTaskRelations, List<MobileDesignerConfig> mobileDesignerConfigs, String version) {
        this.taskFilterRepository.batchInsert(taskFilters, version);
        this.pageTaskRelationService.batchInsert(pageTaskRelations);
        this.mobileDesignerConfigRepository.batchInsert(mobileDesignerConfigs);
    }

    private void batchInsertUcVersion(List<UcTaskFilter> taskFilters, List<UcPageTaskRelation> pageTaskRelations, List<UcMobileDesignerConfig> mobileDesignerConfigs, List<UcTenantRelation> tenantRelations) {
        this.ucTaskFilterRepository.batchInsert(taskFilters);
        this.ucPageTaskRelationRepository.batchInsert(pageTaskRelations);
        this.ucMobileDesignerConfigRepository.batchInsert(mobileDesignerConfigs);
        this.ucTenantRelationRepository.batchInsert(tenantRelations);
    }

    private <T extends TaskFilter> T buildStdTaskFilter(T taskFilter, String appCode, String tmActivityId, String time, String version) {
        taskFilter.setId(null);
        taskFilter.setSource("athena");
        taskFilter.setCategory(TaskFilterCategoryEnum.TASK.getValue());
        TaskFilterParam param = new TaskFilterParam();
        param.setTmActivityId(tmActivityId);
        taskFilter.setParam(param);
        taskFilter.setParamOp("==");
        taskFilter.setValid(Boolean.valueOf(true));
        taskFilter.setEnvScopes(this.getEnvScopes());
        taskFilter.setFrom(TaskFilterFromEnum.DESIGNER.getValue());
        taskFilter.setCreateTime(time);
        taskFilter.setUpdateTime(time);
        taskFilter.setAppCode(appCode);
        taskFilter.setVersion(version);
        return taskFilter;
    }

    private <T extends PageTaskRelation> T buildStdPageTaskRelation(T pageTaskRelation, String appCode, String tmActivityId, String time, String version) {
        pageTaskRelation.setId(null);
        pageTaskRelation.setSource("athena");
        pageTaskRelation.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
        pageTaskRelation.setCategory(PageTaskRelationCategoryEnum.DETAIL.getValue());
        TaskFilterParam param = new TaskFilterParam();
        param.setTmActivityId(tmActivityId);
        pageTaskRelation.setParam(param);
        pageTaskRelation.setEnvScopes(this.getEnvScopes());
        pageTaskRelation.setFrom(TaskFilterFromEnum.DESIGNER.getValue());
        pageTaskRelation.setCreateTime(time);
        pageTaskRelation.setUpdateTime(time);
        pageTaskRelation.setAppCode(appCode);
        pageTaskRelation.setVersion(version);
        return pageTaskRelation;
    }

    private <T extends MobileDesignerConfig> T buildStdMobileDesignerConfig(T mobileDesignerConfig, String appCode, String tmActivityId, String type, String time, String version) {
        mobileDesignerConfig.setId(null).setApplication(appCode).setTmTaskId(null).setTmActivityId(tmActivityId).setTmActivityIdMatch(null).setTmPattern(null).setTmCategory(null).setType(type).setEnvScopes(this.getEnvScopes()).setData(null).setRules(null).setCreateTime(time).setUpdateTime(time).setVersion(version);
        return mobileDesignerConfig;
    }

    private UcTaskFilter buildUcTaskFilter(String ucAppCode, String appCode, String tmActivityId, String time, String version) {
        UcTaskFilter taskFilter = (UcTaskFilter)this.buildStdTaskFilter((TaskFilter)new UcTaskFilter(), appCode, tmActivityId, time, version);
        taskFilter.setUcAppCode(ucAppCode);
        return taskFilter;
    }

    private UcPageTaskRelation buildUcPageTaskRelation(String ucAppCode, String appCode, String tmActivityId, String time, String version) {
        UcPageTaskRelation pageTaskRelation = (UcPageTaskRelation)this.buildStdPageTaskRelation((PageTaskRelation)new UcPageTaskRelation(), appCode, tmActivityId, time, version);
        pageTaskRelation.setUcAppCode(ucAppCode);
        return pageTaskRelation;
    }

    private UcMobileDesignerConfig buildUcMobileDesignerConfig(String ucAppCode, String appCode, String tmActivityId, String type, String time, String version) {
        return ((UcMobileDesignerConfig)this.buildStdMobileDesignerConfig((MobileDesignerConfig)new UcMobileDesignerConfig(), appCode, tmActivityId, type, time, version)).setUcAppCode(ucAppCode);
    }

    private UcTenantRelation buildUcTenantRelation(String ucAppCode, String appCode, String tenantId, Boolean individualAll, String time, String version) {
        return new UcTenantRelation().setId(null).setAppCode(appCode).setUcAppCode(ucAppCode).setTenantId(tenantId).setIndividualAll(individualAll).setCreateTime(time).setUpdateTime(time).setVersion(version);
    }

    private List<EnvScope> getEnvScopes() {
        ArrayList<EnvScope> list = new ArrayList<EnvScope>();
        EnvScope prod = new EnvScope();
        prod.setType(AppEnvTypeEnum.PRODUCTION.getEnvType());
        prod.setValid(Boolean.valueOf(AppEnvTypeEnum.PRODUCTION.getEnvType().equals(AppContext.getEnvType())));
        list.add(prod);
        EnvScope test = new EnvScope();
        test.setType(AppEnvTypeEnum.TEST.getEnvType());
        test.setValid(Boolean.valueOf(AppEnvTypeEnum.TEST.getEnvType().equals(AppContext.getEnvType())));
        list.add(test);
        EnvScope dev = new EnvScope();
        dev.setType(AppEnvTypeEnum.DEVELOP.getEnvType());
        dev.setValid(Boolean.valueOf(AppEnvTypeEnum.DEVELOP.getEnvType().equals(AppContext.getEnvType())));
        list.add(dev);
        return list;
    }

    public void updataData(MobileDesignerConfig config) {
        this.mobileDesignerConfigRepository.updataData(config);
        this.ucMobileDesignerConfigRepository.updateData(config);
    }
}

