/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pattern.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternDetail;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternRequest;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSummaryLayout;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/pattern"})
public class PatternController {
    public static final String JUMP_INFO_SEARCH = "search";
    @Autowired
    private ProjectFilterService projectFilterService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    @PostMapping(value={"/jump/info"})
    public ApiResponse<Map> getPatternJumpInfo(@RequestBody PatternRequest request, String type) {
        Action action;
        PatternDetail detail = request.getDetail();
        if (detail == null || !StringUtils.hasLength((String)detail.getType()) || !StringUtils.hasLength((String)detail.getDataId())) {
            return ApiResponse.buildError((String)"Pattern can not be empty!");
        }
        String tenantId = request.getTenantId();
        if (!StringUtils.hasLength((String)tenantId)) {
            return ApiResponse.buildError((String)"TenantId can not be empty!");
        }
        if ("PROJECT".equalsIgnoreCase(detail.getType())) {
            action = this.getProjectAction(request, type);
        } else if ("TASK".equalsIgnoreCase(detail.getType())) {
            action = this.getTaskAction(request, type);
        } else if ("AGILE_DATA_DETAIL".equalsIgnoreCase(detail.getType())) {
            action = this.getAgileDataAction(request, type);
        } else {
            return ApiResponse.buildError((String)"Pattern type is invalid!");
        }
        HashMap<String, Action> map = new HashMap<String, Action>(1);
        map.put("action", action);
        return ApiResponse.buildOK().setData(map);
    }

    private Action getAgileDataAction(PatternRequest request, String type) {
        Action action = new Action();
        if (JUMP_INFO_SEARCH.equalsIgnoreCase(type)) {
            action = Action.getNoSupportAction((LocaleService)this.localeService, (String)request.getLocale(), (String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be5\u4fe1\u606f\u8be6\u60c5");
        } else {
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_AGILE_DATA_DETAIL_PAGE.toString());
            action.setDataId(request.getDataId());
            action.setJumpPageTitle("");
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        }
        return action;
    }

    private Action getProjectAction(PatternRequest request, String type) {
        Action action;
        PatternDetail detail = request.getDetail();
        DigiwinAtmcProject project = new DigiwinAtmcProject();
        DigiwinAtmcCardDetail cardDetail = this.digiwinAtmcProxyService.getDigiwinAtmcProjectCardDetail(request.getLocale(), request.getIamUserToken(), request.getTenantId(), detail.getDataId());
        if (StringUtils.hasLength((String)detail.getTmTaskId())) {
            project.setTmTaskId(detail.getTmTaskId());
        } else {
            project.setTmTaskId(cardDetail.getTmTaskId());
        }
        if (this.projectFilterService.isCenterConsoleProject(project, request.getTenantId())) {
            DigiwinAtmcSummaryLayout summaryLayout = cardDetail.getSummaryLayout();
            List layoutList = summaryLayout.getLayout();
            UiBotPageData pageData = summaryLayout.getPageData();
            Map bizData = new HashMap();
            for (UiBotLayout layout : layoutList) {
                List bizDataList;
                if (!layout.isTypeOfTable() || CollectionUtils.isEmpty((Collection)(bizDataList = (List)pageData.get((Object)layout.getSchema())))) continue;
                bizData = (Map)bizDataList.get(0);
            }
            String projectStatus = (String)bizData.get("project_status");
            if ("30".equalsIgnoreCase(projectStatus) || "50".equalsIgnoreCase(projectStatus)) {
                HashMap<String, String> rawData = new HashMap<String, String>();
                rawData.put("project_type", cardDetail.getTmTaskId());
                action = new Action(detail.getDataId(), PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData);
            } else {
                action = JUMP_INFO_SEARCH.equalsIgnoreCase(type) ? Action.getNoSupportAction((LocaleService)this.localeService, (String)request.getLocale(), (String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be5\u9879\u76ee\u8be6\u60c5") : this.getAssistantAction(request.getLocale());
            }
        } else {
            action = this.projectFilterService.isStandardProject(project, request.getTenantId()) ? new Action(detail.getDataId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_STANDARD_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), "") : (JUMP_INFO_SEARCH.equalsIgnoreCase(type) ? Action.getNoSupportAction((LocaleService)this.localeService, (String)request.getLocale(), (String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be5\u9879\u76ee\u8be6\u60c5") : this.getAssistantAction(request.getLocale()));
        }
        return action;
    }

    private Action getTaskAction(PatternRequest request, String type) {
        List customTaskConfigList;
        Optional<CustomTaskConfig> customTaskConfigOptional;
        String jumpPageId;
        String tenantVersion = this.activityFilterService.tenantVersion(request.getIamUserToken(), request.getTenantId(), request.getLocale());
        Action action = new Action();
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(request.getTenantId(), tenantVersion);
        PatternDetail detail = request.getDetail();
        if (!(StringUtils.hasLength((String)detail.getTmActivityId()) && StringUtils.hasLength((String)detail.getTmPattern()) && StringUtils.hasLength((String)detail.getTmTaskId()) && StringUtils.hasLength((String)detail.getTmCategory()))) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(request.getLocale(), request.getIamUserToken(), detail.getDataId());
            detail.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
            detail.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
            detail.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
            detail.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
            if (digiwinAtmcBacklogDetail.getFinished().booleanValue()) {
                return Action.getNoSupportAction((LocaleService)this.localeService, (String)request.getLocale(), (String)"\u5df2\u5b8c\u6210\u4efb\u52a1\uff0c\u6682\u4e0d\u652f\u6301\u70b9\u51fb\u67e5\u770b");
            }
        }
        Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(detail.getTmTaskId(), detail.getTmActivityId())).findFirst();
        Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(detail.getTmPattern(), detail.getTmCategory())).findFirst();
        String string = optPageTaskRelationTaskIdAndActivityId.isPresent() ? optPageTaskRelationTaskIdAndActivityId.get().getPageId() : (jumpPageId = optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
        if ("uibotManualTask".equals(detail.getTmActivityId())) {
            jumpPageId = PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString();
        }
        if ((customTaskConfigOptional = (customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig()).stream().filter(customTaskConfig -> detail.getTmTaskId().equalsIgnoreCase(customTaskConfig.getTmTaskId()) && detail.getTmActivityId().equalsIgnoreCase(customTaskConfig.getTmActivityId())).findFirst()).isPresent()) {
            CustomTaskConfig customTaskConfig2 = customTaskConfigOptional.get();
            DigiwinAtmcBacklog digiwinAtmcBacklog = new DigiwinAtmcBacklog();
            digiwinAtmcBacklog.setTmPattern(detail.getTmPattern());
            digiwinAtmcBacklog.setTmTaskId(detail.getTmTaskId());
            digiwinAtmcBacklog.setTmCategory(detail.getTmCategory());
            digiwinAtmcBacklog.setTmActivityId(detail.getTmActivityId());
            digiwinAtmcBacklog.setTenantId(request.getTenantId());
            digiwinAtmcBacklog.setBacklogId(Long.valueOf(Long.parseLong(detail.getDataId())));
            String requestUrl = customTaskConfig2.getCustomTaskUrl(request.getLocale(), request.getIamUserToken(), digiwinAtmcBacklog);
            if (StringUtils.hasLength((String)requestUrl)) {
                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                action.setRequestUrl(requestUrl);
            } else {
                action = this.setJumpPageAction(action, jumpPageId, detail);
            }
        } else {
            action = this.setJumpPageAction(action, jumpPageId, detail);
        }
        if (action.getType() == null) {
            action = JUMP_INFO_SEARCH.equalsIgnoreCase(type) ? Action.getNoSupportAction((LocaleService)this.localeService, (String)request.getLocale(), (String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be5\u4efb\u52a1\u8be6\u60c5") : this.getAssistantAction(request.getLocale());
        }
        return action;
    }

    private Action getAssistantAction(String locale) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ASSISTANT.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return action;
    }

    private Action setJumpPageAction(Action action, String jumpPageId, PatternDetail detail) {
        if (StringUtils.hasLength((String)jumpPageId)) {
            action.setDataId(detail.getDataId());
            action.setJumpPageId(jumpPageId);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            HashMap<String, String> extraParamete = new HashMap<String, String>(2);
            extraParamete.put("tmActivityId", detail.getTmActivityId());
            extraParamete.put("tmTaskId", detail.getTmTaskId());
            action.setRawData(extraParamete);
        }
        return action;
    }
}

