/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.builder.cpcl;

import com.digiwin.mobile.mobileuibot.printer.builder.zpl.ZPLPrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.enums.PrinterCommandTypeEnum;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.model.CommandRequired;
import com.digiwin.mobile.mobileuibot.printer.model.ReportData;
import com.digiwin.mobile.mobileuibot.printer.model.ReportDetail;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
public class CPCLPrinterCommandBuilder
implements PrinterCommandBuilder {
    private byte[] graphBuffer = new byte[0];
    private double tcpLabelMaxHeightCm;
    private int tcpPrinterDpi = 203;
    private int copies;
    private int rotate;
    private int graphWidth;
    private int graphHeight;

    public String getPrinterType() {
        return PrinterCommandTypeEnum.CPCL.name();
    }

    public ReportDetail getReportFilePaths(ReportDetail report, String pdfUrl) {
        report.setBmpFilesPath((List)Lists.newArrayList((Object[])new String[]{pdfUrl}));
        report.setCopy(1);
        report.setHeight("");
        report.setWidth("");
        return report;
    }

    public List<String> buildPrintCommand(List<String> imagePaths) throws Exception {
        if (CollectionUtils.isEmpty(imagePaths)) {
            return Lists.newArrayList();
        }
        ReportData reportData = new ReportData();
        reportData.setPdfUrls(imagePaths);
        return this.printerCommandString(reportData);
    }

    private List<CommandRequired> getCommandBytes(ReportDetail report, String pdfUrl) throws Exception {
        ArrayList<CommandRequired> reportBytesCopy = new ArrayList<CommandRequired>();
        report = this.getReportFilePaths(report, pdfUrl);
        for (String path : report.getBmpFilesPath()) {
            BufferedImage originalBitmap = ImageIO.read(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
            originalBitmap = ZPLPrinterCommandBuilder.convertToGrayscale2((BufferedImage)originalBitmap);
            if (report.getHeight().isEmpty()) {
                report.setHeight(String.format("%.2f", (double)originalBitmap.getHeight() / 203.0 * 25.4));
            }
            if (report.getWidth().isEmpty()) {
                report.setWidth(String.format("%.2f", (double)originalBitmap.getWidth() / 203.0 * 25.4));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalBitmap, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            reportBytesCopy.add(new CommandRequired(report.getHeight(), report.getWidth(), imageBytes, report.getCopy()));
        }
        return reportBytesCopy;
    }

    private List<String> printerCommandString(ReportData reportData) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    this.graphBuffer = reportInfo.getBytes();
                    this.tcpLabelMaxHeightCm = Double.parseDouble(reportInfo.getHeight()) / 10.0;
                    this.copies = reportInfo.getCopy();
                    this.rotate = reportData.getRotate();
                    result.add(this.getCPCLCommand());
                }
            }
        } else {
            throw new Exception("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<byte[]> printerCommandByte(ReportData reportData) {
        throw new UnsupportedOperationException();
    }

    private List<List<CommandRequired>> getCommandBytes(ReportData reportData) throws Exception {
        ArrayList<List<CommandRequired>> reportBytesCopy = new ArrayList<List<CommandRequired>>();
        if (!reportData.getPdfUrls().isEmpty()) {
            for (String pdfUrl : reportData.getPdfUrls()) {
                reportBytesCopy.add(this.getCommandBytes(new ReportDetail(), pdfUrl));
            }
        } else {
            for (ReportDetail report : reportData.getData()) {
                reportBytesCopy.add(this.getCommandBytes(report, null));
            }
        }
        return reportBytesCopy;
    }

    private String getCPCLCommand() {
        String textHex = this.getBitmapHexData();
        int printHeight = (int)(this.tcpLabelMaxHeightCm / 2.54 * (double)this.tcpPrinterDpi);
        if (printHeight < this.graphHeight) {
            printHeight = this.graphHeight;
        }
        return String.format("! %d %d %d %d %d\r\nROTATE %d\r\nEG %d %d %d %d %s\r\nFORM\r\nPRINT\r\n", 0, this.tcpPrinterDpi, this.tcpPrinterDpi, printHeight, this.copies, this.rotate, this.rowRealBytesCount(), this.graphHeight, 0, 0, textHex);
    }

    private String getBitmapHexData() {
        StringBuilder sb = new StringBuilder();
        try (ByteArrayInputStream srcStream = new ByteArrayInputStream(this.graphBuffer);){
            BufferedImage bmp = ImageIO.read(srcStream);
            this.graphWidth = bmp.getWidth();
            this.graphHeight = bmp.getHeight();
            int loopWidth = 8 - bmp.getWidth() % 8;
            loopWidth = loopWidth == 8 ? bmp.getWidth() : (loopWidth += bmp.getWidth());
            for (int y = 0; y < bmp.getHeight(); ++y) {
                int bit = 128;
                int currentValue = 0;
                for (int x = 0; x < loopWidth; ++x) {
                    int intensity;
                    if (x < bmp.getWidth()) {
                        int color = bmp.getRGB(x, y);
                        int red = color >> 16 & 0xFF;
                        int green = color >> 8 & 0xFF;
                        int blue = color & 0xFF;
                        intensity = 255 - (red + green + blue) / 3;
                    } else {
                        intensity = 0;
                    }
                    if (intensity >= 128) {
                        currentValue |= bit;
                    }
                    if ((bit >>= 1) != 0) continue;
                    sb.append(String.format("%02X", currentValue));
                    bit = 128;
                    currentValue = 0;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }

    private int rowRealBytesCount() {
        return this.graphWidth % 8 > 0 ? this.graphWidth / 8 + 1 : this.graphWidth / 8;
    }

    public static void main(String[] args) throws Exception {
        ReportData reportData = new ReportData();
        reportData.setPdfUrls((List)Lists.newArrayList((Object[])new String[]{"C:\\Users\\wjw\\Downloads\\UserBasis001.bmp"}));
        List strings = new CPCLPrinterCommandBuilder().printerCommandString(reportData);
        System.out.println(strings);
    }
}

