/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.builder.zpl;

import com.digiwin.mobile.mobileuibot.printer.builder.zpl.ZPLPrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.enums.PrinterCommandTypeEnum;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.model.CommandRequired;
import com.digiwin.mobile.mobileuibot.printer.model.ReportData;
import com.digiwin.mobile.mobileuibot.printer.model.ReportDetail;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="prototype")
public class ZPLPrinterCommandBuilder
implements PrinterCommandBuilder {
    private static final Logger log = LoggerFactory.getLogger(ZPLPrinterCommandBuilder.class);
    private static List<KeyValuePair<Character, Integer>> compressDictionary = new ArrayList();
    private byte[] graphBuffer;
    private int graphWidth;
    private int graphHeight;
    private int graphWidthByte;
    private int graphHeightDpi;

    public ZPLPrinterCommandBuilder() {
        this.initCompressCode();
    }

    public String getPrinterType() {
        return PrinterCommandTypeEnum.ZPL.name();
    }

    public ReportDetail getReportFilePaths(ReportDetail report, String pdfUrl) {
        report.setBmpFilesPath((List)Lists.newArrayList((Object[])new String[]{pdfUrl}));
        report.setCopy(1);
        return report;
    }

    public List<String> buildPrintCommand(List<String> imagePaths) throws Exception {
        if (CollectionUtils.isEmpty(imagePaths)) {
            return Lists.newArrayList();
        }
        ReportData reportData = new ReportData();
        reportData.setPdfUrls(imagePaths);
        return this.printerCommandString(reportData);
    }

    private List<CommandRequired> getCommandBytes(ReportDetail report, String pdfUrl) {
        ArrayList<CommandRequired> reportBytesCopy = new ArrayList<CommandRequired>();
        report = this.getReportFilePaths(report, pdfUrl);
        for (String path : report.getBmpFilesPath()) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    BufferedImage sourceBmp = ImageIO.read(new File(path));
                    sourceBmp = ZPLPrinterCommandBuilder.convertToGrayscale2((BufferedImage)sourceBmp);
                    ImageIO.write((RenderedImage)sourceBmp, "BMP", stream);
                    reportBytesCopy.add(new CommandRequired(stream.toByteArray(), report.getCopy()));
                    sourceBmp.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("\u751f\u6210ZPL\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
        }
        return reportBytesCopy;
    }

    private List<String> printerCommandString(ReportData reportData) {
        ArrayList<String> result = new ArrayList<String>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    Map map = this.bmpToZplStr(reportInfo.getBytes());
                    result.add("^XA\n^LH0,0^LL" + this.graphHeight + "^PW" + this.graphWidth + "\n~DGR:Temp0.GRF," + map.get("totalBytes") + "," + map.get("rowBytes") + "," + map.get("textBitmap") + "\n^FO30,0^XGR:Temp0.GRF,1,1^FS\n^PQ" + reportInfo.getCopy() + "\n^XZ");
                }
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<byte[]> printerCommandByte(ReportData reportData) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private List<List<CommandRequired>> getCommandBytes(ReportData reportData) {
        ArrayList<List<CommandRequired>> reportBytesCopy = new ArrayList<List<CommandRequired>>();
        if (!reportData.getPdfUrls().isEmpty()) {
            for (String pdfUrl : reportData.getPdfUrls()) {
                reportBytesCopy.add(this.getCommandBytes(new ReportDetail(), pdfUrl));
            }
        } else {
            for (ReportDetail report : reportData.getData()) {
                reportBytesCopy.add(this.getCommandBytes(report, ""));
            }
        }
        return reportBytesCopy;
    }

    private int getRowSize() {
        return this.graphWidth + 31 >> 5 << 2;
    }

    private int getRowRealBytesCount() {
        return this.graphWidth % 8 > 0 ? this.graphWidth / 8 + 1 : this.graphWidth / 8;
    }

    private Map<String, Object> bmpToZplStr(byte[] bitmap) {
        try {
            this.graphBuffer = bitmap;
            byte[] bmpData = this.getBitmapData();
            String textHex = DatatypeConverter.printHexBinary((byte[])bmpData).replace("-", "");
            String textBitmap = this.compressLZ77(textHex);
            int totalBytes = this.graphHeight * this.getRowRealBytesCount();
            int rowBytes = this.getRowRealBytesCount();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("textBitmap", textBitmap);
            map.put("totalBytes", totalBytes);
            map.put("rowBytes", rowBytes);
            return map;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static BufferedImage convertToGrayscale2(BufferedImage original) {
        int width = original.getWidth();
        int height = original.getHeight();
        BufferedImage monoImage = new BufferedImage(width, height, 12);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(original.getRGB(x, y));
                int grayValue = (int)(0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue());
                boolean isBlack = grayValue < 128;
                monoImage.setRGB(x, y, isBlack ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
            }
        }
        return monoImage;
    }

    private BufferedImage convertToGrayscale(BufferedImage pimage) {
        BufferedImage source = null;
        if (pimage.getType() != 5) {
            source = new BufferedImage(pimage.getWidth(), pimage.getHeight(), 5);
            Graphics g = source.getGraphics();
            g.drawImage(pimage, 0, 0, null);
            g.dispose();
        } else {
            source = pimage;
        }
        byte[] sourceBuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
        BufferedImage destination = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        byte[] destinationBuffer = ((DataBufferByte)destination.getRaster().getDataBuffer()).getData();
        int sourceIndex = 0;
        int destinationIndex = 0;
        int pixelTotal = 0;
        byte destinationValue = 0;
        int pixelValue = 128;
        int height = source.getHeight();
        int width = source.getWidth();
        int threshold = 500;
        for (int y = 0; y < height; ++y) {
            sourceIndex = y * source.getWidth();
            destinationIndex = y * destination.getWidth();
            destinationValue = 0;
            pixelValue = 128;
            for (int x = 0; x < width; ++x) {
                pixelTotal = sourceBuffer[sourceIndex + 1] + sourceBuffer[sourceIndex + 2] + sourceBuffer[sourceIndex + 3];
                if (pixelTotal > threshold) {
                    destinationValue = (byte)(destinationValue + (byte)pixelValue);
                }
                if (pixelValue == 1) {
                    if (destinationIndex < destinationBuffer.length) {
                        destinationBuffer[destinationIndex] = destinationValue;
                    }
                    ++destinationIndex;
                    destinationValue = 0;
                    pixelValue = 128;
                } else {
                    pixelValue >>= 1;
                }
                sourceIndex += 4;
            }
            if (pixelValue == 128 || destinationIndex >= destinationBuffer.length) continue;
            destinationBuffer[destinationIndex] = destinationValue;
        }
        if (source != pimage) {
            source.flush();
        }
        return destination;
    }

    private byte[] getBitmapData() {
        ByteArrayInputStream srcStream = null;
        ByteArrayOutputStream dstStream = null;
        BufferedImage srcBmp = null;
        Image dstBmp = null;
        Object srcBuffer = null;
        byte[] dstBuffer = null;
        byte[] result = null;
        try {
            int i;
            srcStream = new ByteArrayInputStream(this.graphBuffer);
            srcBmp = ImageIO.read(srcStream);
            this.graphWidth = srcBmp.getWidth();
            this.graphHeight = srcBmp.getHeight();
            this.graphHeightDpi = srcBmp.getHeight();
            this.graphWidthByte = srcBmp.getWidth();
            dstBmp = ZPLPrinterCommandBuilder.convertToGrayscale2((BufferedImage)srcBmp);
            dstStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((Object)dstBmp), "BMP", dstStream);
            result = dstBuffer = dstStream.toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(dstBuffer);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int bfOffBits = buffer.getInt(10);
            result = new byte[this.graphHeight * this.getRowRealBytesCount()];
            for (i = 0; i < this.graphHeight; ++i) {
                int sindex = bfOffBits + (this.graphHeight - 1 - i) * this.getRowSize();
                int dindex = i * this.getRowRealBytesCount();
                System.arraycopy(dstBuffer, sindex, result, dindex, this.getRowRealBytesCount());
            }
            i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = (byte)(result[n] ^ 0xFF);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            if (srcStream != null) {
                try {
                    srcStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6e90\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            if (dstStream != null) {
                try {
                    dstStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u76ee\u6807\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            if (srcBmp != null) {
                srcBmp.flush();
            }
            if (dstBmp != null) {
                dstBmp.flush();
            }
        }
        return result;
    }

    private String compressLZ77(String text) {
        String result = "";
        char[] arrChar = text.toCharArray();
        int count = 1;
        for (int i = 1; i < text.length(); ++i) {
            if (arrChar[i - 1] == arrChar[i]) {
                ++count;
            } else {
                result = result + this.convertNumber(count) + arrChar[i - 1];
                count = 1;
            }
            if (i != text.length() - 1) continue;
            result = result + this.convertNumber(count) + arrChar[i];
        }
        return result;
    }

    private String decompressLZ77(String text) {
        String result = "";
        char[] arrChar = text.toCharArray();
        int count = 0;
        for (int i = 0; i < arrChar.length; ++i) {
            if (this.isHexChar(arrChar[i])) {
                result = result + new String(new char[]{arrChar[i]}, 0, count == 0 ? 1 : count);
                count = 0;
                continue;
            }
            int value = this.getCompressValue(arrChar[i]);
            count += value;
        }
        return result;
    }

    private int getCompressValue(char c) {
        int result = 0;
        for (KeyValuePair entry : compressDictionary) {
            if (c != ((Character)entry.getKey()).charValue()) continue;
            result = (Integer)entry.getValue();
        }
        return result;
    }

    private boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private String convertNumber(int count) {
        String result = "";
        if (count > 1) {
            block0: while (count > 0) {
                for (int i = compressDictionary.size() - 1; i >= 0; --i) {
                    if (count < (Integer)((KeyValuePair)compressDictionary.get(i)).getValue()) continue;
                    result = result + ((KeyValuePair)compressDictionary.get(i)).getKey();
                    count -= ((Integer)((KeyValuePair)compressDictionary.get(i)).getValue()).intValue();
                    continue block0;
                }
            }
        }
        return result;
    }

    private void initCompressCode() {
        int i;
        compressDictionary = new ArrayList();
        for (i = 0; i < 19; ++i) {
            compressDictionary.add(new KeyValuePair((Object)Character.valueOf((char)(71 + i)), (Object)(i + 1)));
        }
        for (i = 0; i < 20; ++i) {
            compressDictionary.add(new KeyValuePair((Object)Character.valueOf((char)(103 + i)), (Object)((i + 1) * 20)));
        }
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    public static void main(String[] args) {
        ReportData reportData = new ReportData();
        reportData.setPdfUrls((List)Lists.newArrayList((Object[])new String[]{"C:\\Users\\wjw\\Pictures\\lQLPDhsn8uDYAoPNAcLNAcKwqnyeWOJXelYCEiAOSED0AA_450_450.png"}));
        List strings = new ZPLPrinterCommandBuilder().printerCommandString(reportData);
        System.out.println(strings);
    }
}

