/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilter;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ProjectFilterRepositoryImpl
implements ProjectFilterRepository {
    public static final String COLLECTION_NAME = "projectFilter";
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    @Cacheable(cacheNames={"projectFilterList"}, cacheManager="systemCacheManager")
    public List<ProjectFilter> listProjectFilter() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        List<ProjectFilter> projectFilterList = this.mongoTemplate.find(query, ProjectFilter.class);
        projectFilterList = projectFilterList.stream().filter(projectFilter -> projectFilter.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
        return projectFilterList;
    }

    public List<ProjectFilter> upsertAll(List<ProjectFilter> projectFilterList) {
        ArrayList<ProjectFilter> filterList = new ArrayList<ProjectFilter>();
        if (CollectionUtils.isEmpty(projectFilterList)) {
            return filterList;
        }
        for (ProjectFilter projectFilter : projectFilterList) {
            filterList.add(this.upsert(projectFilter));
        }
        return filterList;
    }

    public ProjectFilter upsert(ProjectFilter projectFilter) {
        if (!StringUtils.hasLength((String)projectFilter.getTenantId())) {
            projectFilter.setTenantId(null);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)projectFilter.getAppCode())).addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)projectFilter.getTenantId())).addCriteria((CriteriaDefinition)Criteria.where((String)"content.tmTaskId").is((Object)projectFilter.getContent().getTmTaskId()));
        Update update = new Update();
        update.setOnInsert("createTime", (Object)DateTimeUtil.getTodayTimeUseDefaultPattern());
        update.set("updateTime", (Object)DateTimeUtil.getTodayTimeUseDefaultPattern());
        update.set("companyId", (Object)projectFilter.getCompanyId());
        update.set("systemId", (Object)projectFilter.getSystemId());
        update.set("tenantId", (Object)projectFilter.getTenantId());
        update.set("appCode", (Object)projectFilter.getAppCode());
        update.set("content", (Object)projectFilter.getContent());
        update.set("valid", (Object)projectFilter.getValid());
        update.set("envScopes", (Object)projectFilter.getEnvScopes());
        this.mongoTemplate.upsert(query, (UpdateDefinition)update, ProjectFilter.class);
        this.secondMongoTemplate.upsert(query, (UpdateDefinition)update, ProjectFilter.class);
        return (ProjectFilter)this.mongoTemplate.findOne(query, ProjectFilter.class);
    }

    public List<ProjectFilter> listProjectFilter(String appCode, String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        if (StringUtils.hasLength((String)tenantId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        }
        return this.mongoTemplate.find(query, ProjectFilter.class);
    }

    public List<ProjectFilter> deleteProjectFilter(String appCode, String tenantId, String tmTaskId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        if (StringUtils.hasLength((String)tenantId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        }
        if (StringUtils.hasLength((String)tmTaskId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"content.tmTaskId").is((Object)tmTaskId));
        }
        this.secondMongoTemplate.findAllAndRemove(query, ProjectFilter.class, COLLECTION_NAME);
        return this.mongoTemplate.findAllAndRemove(query, ProjectFilter.class, COLLECTION_NAME);
    }
}

