/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.hooks.MobileUiBotHooks;
import com.digiwin.mobile.mobileuibot.core.hooks.MobileUiBotHooksService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildSystemCloudHouseKeeperEditTaskStrategy")
public class ProjectDetailBuildSystemCloudHouseKeeperEditTaskStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildSystemCloudHouseKeeperEditTaskStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private MobileUiBotHooksService mobileUiBotHooksService;
    @Autowired
    private JsRuleService jsRuleService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        StopWatch stopWatch = new StopWatch("SystemCloudHouseKeeper Edit Task Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        List jsRuleList = this.jsRuleService.findByPageId(pageSetting.getPageId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)jsRuleList)) {
            ArrayList uiBotRuleList = new ArrayList(1);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties((Object)jsRule, (Object)uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            if (uiBotModel != null) {
                uiBotModel.setRules(uiBotRuleList);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map currentProjectTaskInfoMap = (Map)MapUtil.getOrDefault((Map)rawData, (String)"currentProjectTaskInfo", Collections.emptyMap());
        Map taskInfoMap = this.getInitData(apiRequest, currentProjectTaskInfoMap);
        List mobileUiBotHooksList = this.mobileUiBotHooksService.findByPageId(pageSetting.getPageId());
        Map<String, Map> hooksBySchema = mobileUiBotHooksList.stream().collect(Collectors.toMap(MobileUiBotHooks::getSchema, e -> e.getData().getInnerMap(), (a, b) -> a));
        stopWatch.start("Build SystemCloudHouseKeeper Edit Task Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    this.handleCustomGroup(customGroup, taskInfoMap, hooksBySchema, locale);
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = (List)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    buttonList.forEach(bottomButton -> {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getIsCheckButton().booleanValue()) {
                            Action action = bottomButton.getAction();
                            action.setRefreshPageId(apiRequest.getRefreshPageId());
                            rawData.put("actionId", "bm.pisc.attachment.join.relation.update");
                            rawData.put("taskInfoMap", taskInfoMap);
                            rawData.put("pageId", apiRequest.getPageId());
                            rawData.put("fromPageId", MapUtils.getString((Map)rawData, (Object)"fromPageId"));
                            action.setRawData((Object)rawData);
                        }
                    });
                    uiBotModel.getPageData().put((Object)schema, (Object)buttonList);
                    break;
                }
            }
        }
        UiBotPageData rawUiBotPageData = new UiBotPageData();
        rawUiBotPageData.put((Object)"task_info", (Object)taskInfoMap);
        uiBotModel.setRawUiBotPageData(rawUiBotPageData);
        stopWatch.stop();
        return uiBotModel;
    }

    private Map<String, Object> getInitData(ApiRequest apiRequest, Map<String, Object> currentProjectTaskInfo) {
        HashMap<String, Object> taskInfoMap = new HashMap<String, Object>(3);
        taskInfoMap.put("project_no", currentProjectTaskInfo.get("project_no"));
        taskInfoMap.put("task_no", currentProjectTaskInfo.get("task_no"));
        taskInfoMap.put("task_property", "1");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("query_condition", "ALL");
        parameterMap.put("source_type", "4");
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.attachment.join.relation.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"task_info")).filter(e -> CollectionUtils.isNotEmpty((Collection)e)).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
        }
        return Collections.emptyMap();
    }

    private void handleCustomGroup(CustomGroup customGroup, Map<String, Object> taskInfoMap, Map<String, Map<String, Object>> hooksBySchema, String locale) {
        CustomGroupContent customGroupContent = customGroup.getContent();
        List customGroupUiBotLayouts = customGroupContent.getLayout();
        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayouts) {
            String customGroupSchema = customGroupUiBotLayout.getSchema();
            switch (customGroupUiBotLayout.getType()) {
                case "INPUT_SINGLE": {
                    InputSingleText inputSingleText = InputSingleText.create((String)this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel()), (String)MapUtils.getString(taskInfoMap, (Object)customGroupSchema));
                    inputSingleText.setRequired(Boolean.valueOf(true));
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputSingleText);
                    break;
                }
                case "INPUT_NUMERIC": {
                    String unit = this.localeService.getLanguageValue(locale, customGroupSchema.equals("workload_qty") ? "\u65e5" : "\u5c0f\u65f6");
                    String value = MapUtils.getString(taskInfoMap, (Object)customGroupSchema);
                    value = StringUtils.isEmpty((CharSequence)value) ? "0" : value;
                    String defaultValue = new BigDecimal(value).stripTrailingZeros().toPlainString();
                    InputNumeric inputNumeric = InputNumeric.create((Integer)99999999, (Integer)0, (String)defaultValue, (String)this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel()), (Integer)InputNumericTypeEnum.INTEGERWITHUNIT.getValue(), (Boolean)false, (String)unit);
                    if (customGroupSchema.equals("plan_work_hours")) {
                        inputNumeric.setEnable(Boolean.valueOf(false));
                    }
                    if (customGroupSchema.equals("workload_qty")) {
                        inputNumeric.setHooks(hooksBySchema.get(customGroupSchema));
                    }
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputNumeric);
                    break;
                }
                case "WINDOW_MULTI_SELECT": {
                    InputWindowMultiSelect inputWindowMultiSelect = this.buildInputWindowMultiSelect(customGroupUiBotLayout, taskInfoMap, customGroupSchema, locale);
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputWindowMultiSelect);
                    break;
                }
                case "INPUT_CALENDAR": {
                    String dateValue = MapUtils.getString(taskInfoMap, (Object)customGroupSchema);
                    InputCalendar inputCalendar = this.buildInputCalendar(customGroupUiBotLayout, dateValue, locale);
                    inputCalendar.setHooks(hooksBySchema.get(customGroupSchema));
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputCalendar);
                }
            }
        }
    }

    private InputWindowMultiSelect buildInputWindowMultiSelect(UiBotLayout uiBotLayout, Map<String, Object> taskInfoMap, String schema, String locale) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setTitle(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        inputWindowMultiSelect.setRawData(this.buildInputWindowMultiSelectRawData());
        inputWindowMultiSelect.setType("WINDOW_SINGLE_SELECT");
        inputWindowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowMultiSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        inputWindowMultiSelect.setUseHasNext(Boolean.valueOf(false));
        List taskMemberInfoList = (List)MapUtil.getOrDefault(taskInfoMap, (String)"task_member_info", Collections.emptyList());
        inputWindowMultiSelect.setSelectIdList(taskMemberInfoList.stream().map(e -> MapUtils.getString((Map)e, (Object)"executor_no")).collect(Collectors.toList()));
        inputWindowMultiSelect.setTextList(taskMemberInfoList.stream().map(e -> MapUtils.getString((Map)e, (Object)"executor_name")).collect(Collectors.toList()));
        inputWindowMultiSelect.setRequired(Boolean.valueOf(true));
        return inputWindowMultiSelect;
    }

    private InputCalendar buildInputCalendar(UiBotLayout uiBotLayout, String dateValue, String locale) {
        uiBotLayout.setHeaderName(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        InputCalendar inputCalendar = InputCalendar.create((UiBotLayout)uiBotLayout, null, (String)locale);
        if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
            LocalDate localDate = DateTimeUtil.parseLocalDateUseDefaultPattern((String)dateValue);
            InputCalendarDate inputCalendarDate = InputCalendarDate.create((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth());
            inputCalendar.setMinDateSelectable(inputCalendarDate);
            inputCalendar.setDateValueList(Collections.singletonList(inputCalendarDate));
        }
        inputCalendar.setRequired(Boolean.valueOf(true));
        return inputCalendar;
    }

    private Map<String, Object> buildInputWindowMultiSelectRawData() {
        HashMap<String, Object> parasMap = new HashMap<String, Object>(2);
        parasMap.put("appid", "sch");
        parasMap.put("is_show_main_department", true);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.basc.app.auth.employee.get");
        requestMap.put("parameter", parasMap);
        HashMap<String, Object> rawDataMap = new HashMap<String, Object>(2);
        rawDataMap.put("requestParam", requestMap);
        rawDataMap.put("type", "isSCHEditTaskQueryEmployee");
        return rawDataMap;
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map taskInfoMap = (Map)rawData.get("taskInfoMap");
        for (ActionSubmitParam actionSubmitParam : apiRequestSubmit.getSubmitParams()) {
            switch (actionSubmitParam.getType()) {
                case "INPUT_SINGLE": {
                    InputSingleText inputSingleText = (InputSingleText)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputSingleText.class);
                    taskInfoMap.put(actionSubmitParam.getSchema(), inputSingleText.getText());
                    break;
                }
                case "INPUT_NUMERIC": {
                    InputNumeric inputNumeric = (InputNumeric)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputNumeric.class);
                    taskInfoMap.put(actionSubmitParam.getSchema(), inputNumeric.getText());
                    break;
                }
                case "WINDOW_MULTI_SELECT": {
                    InputWindowMultiSelect inputWindowMultiSelect = (InputWindowMultiSelect)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputWindowMultiSelect.class);
                    List selectDetailList = inputWindowMultiSelect.getSelectDetailList();
                    if (!CollectionUtils.isNotEmpty((Collection)selectDetailList)) break;
                    List taskMemberInfoList = selectDetailList.stream().map(e -> {
                        Map selectDetailItem = (Map)e;
                        HashMap taskMemberInfoItem = new HashMap(4);
                        taskMemberInfoItem.put("executor_no", selectDetailItem.get("employee_no"));
                        taskMemberInfoItem.put("executor_name", selectDetailItem.get("employee_name"));
                        taskMemberInfoItem.put("executor_department_no", selectDetailItem.get("department_no"));
                        taskMemberInfoItem.put("executor_department_name", selectDetailItem.get("department_name"));
                        return taskMemberInfoItem;
                    }).collect(Collectors.toList());
                    taskInfoMap.put(actionSubmitParam.getSchema(), taskMemberInfoList);
                    break;
                }
                case "INPUT_CALENDAR": {
                    InputCalendar inputCalendar = (InputCalendar)actionSubmitParam.getParams();
                    if (!StringUtils.isNotEmpty((CharSequence)inputCalendar.getInputText())) break;
                    taskInfoMap.put(actionSubmitParam.getSchema(), inputCalendar.getInputText().replaceAll("\\.", "-"));
                }
            }
        }
        HashMap<String, List<Map>> parameterMap = new HashMap<String, List<Map>>(2);
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));
        HashMap requestMap = new HashMap(2);
        requestMap.put("actionId", rawData.get("actionId"));
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() != 200 || StringUtils.isNotEmpty((CharSequence)resp.getErrorMessage())) {
            throw new ServiceException(resp.getErrorMessage());
        }
        List projectInfoList = Optional.ofNullable(resp.getResponse()).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"task_info", Collections.emptyList())).orElse(Collections.emptyList());
        String errorMsg = projectInfoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)MapUtils.getString((Map)e, (Object)"error_msg"))).findFirst().map(e -> MapUtils.getString((Map)e, (Object)"error_msg")).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            throw new ServiceException(errorMsg);
        }
        String fromPageId = MapUtils.getString((Map)rawData, (Object)"fromPageId");
        Integer type = Objects.equals(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString(), fromPageId) ? ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue() : ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue();
        Action action = new Action();
        action.setType(type);
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.name());
        action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u6210\u529f"));
        return ActionSubmitResult.create((boolean)true, (Action)action);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

