/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.cac.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacCurrentUserApp;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacResponse;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorizationResponse;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="digiwinCacProxyService")
public class DigiwinCacProxyServiceImpl
implements DigiwinCacProxyService {
    private static final Logger log = LoggerFactory.getLogger(DigiwinCacProxyServiceImpl.class);
    @Autowired
    private HttpService httpService;

    public DigiwinCacTenantAuthorizationResponse findTenantAuthorizations(String tenantId, String userToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/authorizations/tenants/{tenantId}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("tenantId", tenantId);
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinCacTenantAuthorizationResponse)responseEntity.getBody() : DigiwinCacTenantAuthorizationResponse.createEmpty();
    }

    public List<String> findAuthorizationsEnabledByUserIdAndTenantId(String tenantId, String userId, String userToken) {
        2 responseType;
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/authorizations/tenants/" + tenantId + "/users/" + userId + "/enabled";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        return responseEntity.getStatusCode().is2xxSuccessful() ? (List)responseEntity.getBody() : new ArrayList();
    }

    public Boolean useModuleByTenantIdAndUserId(String tenantId, String userId, String goodsCode, String moduleId, String userToken) {
        3 responseType;
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/authorizations/tenants/" + tenantId + "/users/" + userId + "/goods/" + goodsCode + "/module/" + moduleId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        return responseEntity.getStatusCode().is2xxSuccessful() ? (Boolean)((Map)responseEntity.getBody()).get("isSuccess") : Boolean.valueOf(false);
    }

    public List<DigiwinCacCurrentUserApp> findAuthorizationsCurrentUserApp(String userId, String userToken) {
        4 responseType;
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/authorizations/current/user/apps";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(userToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        return responseEntity.getStatusCode().is2xxSuccessful() ? (List)((DigiwinCacResponse)Objects.requireNonNull(responseEntity.getBody())).getData() : new ArrayList<DigiwinCacCurrentUserApp>();
    }

    public Map<String, Object> getAuthorizationsCurrentSimple(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/authorizations/current/simple";
        HashMap<String, Integer> bodyPayLoad = new HashMap<String, Integer>(2);
        bodyPayLoad.put("queryExpire", 0);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayLoad), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && ObjectUtils.isNotEmpty((Object)responseEntity.getBody()) ? (Map)responseEntity.getBody() : Collections.emptyMap();
    }

    public Boolean countingUserAdd(String countingId, String tenantId, String userId) {
        String url = AppContext.getApiUrlSetting().getCacUrl() + "/api/cac/v4" + "/counting/user/add";
        HashMap<String, String> bodyPayLoad = new HashMap<String, String>(3);
        bodyPayLoad.put("countingId", countingId);
        bodyPayLoad.put("tenantId", tenantId);
        bodyPayLoad.put("userId", userId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(bodyPayLoad), JSONObject.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && ((JSONObject)responseEntity.getBody()).getBoolean("isSuccess") != false;
    }
}

