/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.esp.callback;

import com.digiwin.mobile.mobileuibot.model.CallbackInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.DigiwinEspCallback;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.service.CallbackInfoRecordService;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DigiwinEspCallbackManager {
    private static final ConcurrentHashMap<String, DigiwinEspCallback> callbacks = new ConcurrentHashMap();
    private static DigiwinEspCallbackManager instance;
    @Autowired
    private CallbackInfoRecordService callbackInfoRecordService;

    @PostConstruct
    public void init() {
        instance = this;
    }

    public static void registerCallback(String reqId, DigiwinEspCallback callback) {
        long startTime = System.currentTimeMillis();
        long timeout = 120000L;
        while (true) {
            CallbackInfo callbackData;
            if (ObjectUtils.isNotEmpty((Object)(callbackData = DigiwinEspCallbackManager.instance.callbackInfoRecordService.getCallbacksDataById(reqId))) && Objects.equals("pending", callbackData.getStatus())) {
                callback.onDataReceived(callbackData.getCallbackData());
                DigiwinEspCallbackManager.instance.callbackInfoRecordService.updateCallbackStatus(reqId, "completed", null);
                callbacks.remove(reqId);
                break;
            }
            if (!callbacks.containsKey(reqId)) {
                callbacks.put(reqId, callback);
                DigiwinEspCallbackManager.instance.callbackInfoRecordService.insertCallbackData(reqId, "registered", "");
            }
            if (System.currentTimeMillis() - startTime > timeout) {
                callback.onDataReceived("{}");
                break;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void notifyDataReceived(String reqId, String data) {
        CallbackInfo callbackData;
        DigiwinEspCallback callback = (DigiwinEspCallback)callbacks.get(reqId);
        if (callback != null) {
            callback.onDataReceived(data);
        }
        if (ObjectUtils.isEmpty((Object)(callbackData = DigiwinEspCallbackManager.instance.callbackInfoRecordService.getCallbacksDataById(reqId)))) {
            DigiwinEspCallbackManager.instance.callbackInfoRecordService.insertCallbackData(reqId, "pending", data);
        } else {
            DigiwinEspCallbackManager.instance.callbackInfoRecordService.updateCallbackStatus(reqId, "pending", data);
        }
    }
}

