/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import com.digiwin.mobile.mobileuibot.common.currency.CurrencyUtil;
import com.digiwin.mobile.mobileuibot.common.currency.MagnitudeUnit;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DataObserveResult
implements Serializable {
    private static final long serialVersionUID = 2019013015209035321L;
    public static final int DEFAULT_VALUE_AXIS_EQUAL_PARTS_COUNT = 5;
    private String locale;
    private ChartTypeEnum chartTypeEnum;
    private Integer group;
    private Double minValue;
    private Double maxValue;
    private Double meanValue;
    private Double medianValue;
    private Double stdDeviation;
    private Double[] irregularValues;
    private Double preferredAxisMinValue;
    private Double preferredAxisMaxValue;
    private Double preferredAxisInterval;
    private AgileDataChartFieldDisplayFormat format;
    private Integer negativeValueAxisScaleCount;
    private Integer positiveValueAxisScaleCount;

    private DataObserveResult() {
    }

    public DataObserveResult(AgileDataChartValueField valueField) {
        this();
        this.format = valueField.getFormat();
    }

    public DataObserveResult(String locale, Integer groupNo, AgileDataChartFieldDisplayFormat format) {
        this();
        this.locale = locale;
        this.group = groupNo;
        this.format = format;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMeanValue(Double meanValue) {
        this.meanValue = meanValue;
    }

    public void setMedianValue(Double medianValue) {
        this.medianValue = medianValue;
    }

    public void setStdDeviation(Double stdDeviation) {
        this.stdDeviation = stdDeviation;
    }

    public void setPreferredAxisMinValue(Double preferredAxisMinValue) {
        this.preferredAxisMinValue = preferredAxisMinValue;
    }

    public void setPreferredAxisMaxValue(Double preferredAxisMaxValue) {
        this.preferredAxisMaxValue = preferredAxisMaxValue;
    }

    public void setPreferredAxisInterval(Double preferredAxisInterval) {
        this.preferredAxisInterval = Math.abs(preferredAxisInterval);
    }

    public void setNegativeValueAxisScaleCount(Integer negativeValueAxisScaleCount) {
        this.negativeValueAxisScaleCount = negativeValueAxisScaleCount;
    }

    public void setPositiveValueAxisScaleCount(Integer positiveValueAxisScaleCount) {
        this.positiveValueAxisScaleCount = positiveValueAxisScaleCount;
    }

    public boolean dataDistributionIsCentralized() {
        if (null == this.meanValue && null == this.stdDeviation) {
            return false;
        }
        double diff = this.stdDeviation / this.meanValue;
        return Math.abs(diff) <= 0.1;
    }

    public boolean dataDistributionIsDiscrete() {
        if (null == this.meanValue && null == this.stdDeviation) {
            return false;
        }
        double diff = this.stdDeviation / this.meanValue;
        return Math.abs(diff) >= 0.2;
    }

    public boolean dataDistributionIsModerate() {
        return !this.dataDistributionIsCentralized() && !this.dataDistributionIsDiscrete();
    }

    public boolean dataDistributionIsBetweenPlusAndMinusOne() {
        return this.getMinValue() >= -1.0 && this.getMaxValue() <= 1.0;
    }

    public boolean dataDistributionIsBetweenPlusAndMinusTen() {
        return this.getMinValue() >= -10.0 && this.getMaxValue() <= 10.0;
    }

    public List<String> calculatePreferredAxisDatas() {
        if (null == this.getPreferredAxisMinValue() || null == this.getPreferredAxisMaxValue() || null == this.getPreferredAxisInterval()) {
            return Collections.emptyList();
        }
        if (null != this.format) {
            return this.calculateValueAxisScalesByFormat(this.format);
        }
        return this.calculateValueAxisScalesByDefault();
    }

    public void tunePreferredAxisInterval() {
        if (null == this.getPreferredAxisInterval() || null == this.getPreferredAxisMinValue() || null == this.getPreferredAxisMaxValue() || null == this.getMinValue() || null == this.getMaxValue()) {
            return;
        }
        Double oldInterval = this.getPreferredAxisInterval();
        if (oldInterval < 1.0) {
            int minNegativeIntervalCnt = (int)Math.ceil((0.0 - this.getPreferredAxisMinValue()) / this.getPreferredAxisInterval());
            int minPositiveIntervalCnt = (int)Math.ceil(this.getPreferredAxisMaxValue() / this.getPreferredAxisInterval());
            this.setPreferredAxisMinValue(Double.valueOf(0.0 - (double)minNegativeIntervalCnt * oldInterval));
            this.setPreferredAxisMaxValue(Double.valueOf(0.0 + (double)minPositiveIntervalCnt * oldInterval));
            this.setNegativeValueAxisScaleCount(Integer.valueOf(minNegativeIntervalCnt));
            this.setPositiveValueAxisScaleCount(Integer.valueOf(minPositiveIntervalCnt));
            return;
        }
        Double newInterval = MathUtil.getFiveMultiplesRoundedValueByDigits((Double)oldInterval, (int)0);
        if (newInterval > 0.0) {
            this.setPreferredAxisInterval(newInterval);
        }
        if (Objects.equals(this.getMinValue(), this.getMaxValue())) {
            int minNegativeIntervalCnt = (int)Math.ceil((0.0 - this.getPreferredAxisMinValue()) / this.getPreferredAxisInterval());
            int minPositiveIntervalCnt = (int)Math.ceil(this.getPreferredAxisMaxValue() / this.getPreferredAxisInterval());
            this.setNegativeValueAxisScaleCount(Integer.valueOf(minNegativeIntervalCnt));
            this.setPositiveValueAxisScaleCount(Integer.valueOf(minPositiveIntervalCnt));
        } else if (this.getMaxValue() <= 0.0) {
            Double oldPreferredAxisMinValue = this.getPreferredAxisMinValue();
            int minNegativeIntervalCnt = (int)Math.ceil((this.getPreferredAxisMaxValue() - oldPreferredAxisMinValue) / this.getPreferredAxisInterval());
            Double newPreferredAxisMinValue = this.getPreferredAxisMaxValue() - (double)minNegativeIntervalCnt * this.getPreferredAxisInterval();
            this.setPreferredAxisMinValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)newPreferredAxisMinValue, (int)-1));
            this.setNegativeValueAxisScaleCount(Integer.valueOf(minNegativeIntervalCnt));
            this.setPositiveValueAxisScaleCount(Integer.valueOf(0));
        } else if (this.getMinValue() >= 0.0) {
            Double oldPreferredAxisMaxValue = this.getPreferredAxisMaxValue();
            int minPositiveIntervalCnt = (int)Math.ceil((oldPreferredAxisMaxValue - this.getPreferredAxisMinValue()) / this.getPreferredAxisInterval());
            Double newPreferredAxisMaxValue = this.getPreferredAxisMinValue() + (double)minPositiveIntervalCnt * this.getPreferredAxisInterval();
            this.setPreferredAxisMaxValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)newPreferredAxisMaxValue, (int)1));
            this.setNegativeValueAxisScaleCount(Integer.valueOf(0));
            this.setPositiveValueAxisScaleCount(Integer.valueOf(minPositiveIntervalCnt));
        } else {
            Double oldPreferredAxisMinValue = this.getPreferredAxisMinValue();
            Double oldPreferredAxisMaxValue = this.getPreferredAxisMaxValue();
            int minNegativeIntervalCnt = (int)Math.ceil((0.0 - oldPreferredAxisMinValue) / this.getPreferredAxisInterval());
            int minPositiveIntervalCnt = (int)Math.ceil(oldPreferredAxisMaxValue / this.getPreferredAxisInterval());
            Double newPreferredAxisMinValue = 0.0 - (double)minNegativeIntervalCnt * this.getPreferredAxisInterval();
            Double newPreferredAxisMaxValue = 0.0 + (double)minPositiveIntervalCnt * this.getPreferredAxisInterval();
            this.setPreferredAxisMinValue(newPreferredAxisMinValue);
            this.setPreferredAxisMaxValue(newPreferredAxisMaxValue);
            this.setNegativeValueAxisScaleCount(Integer.valueOf(minNegativeIntervalCnt));
            this.setPositiveValueAxisScaleCount(Integer.valueOf(minPositiveIntervalCnt));
        }
    }

    public void addSafeAreaToAxisScale(Double dataSetMin, Double dataSetMax) {
        Double axisInterval;
        if (Math.abs(dataSetMax - this.getPreferredAxisMaxValue()) < this.getPreferredAxisInterval()) {
            Double oldAxisMaxValue = this.getPreferredAxisMaxValue();
            axisInterval = this.getPreferredAxisInterval();
            this.setPreferredAxisMaxValue(Double.valueOf(oldAxisMaxValue + axisInterval));
        }
        if (Math.abs(dataSetMin - this.getPreferredAxisMinValue()) < this.getPreferredAxisInterval()) {
            Double oldAxisMinValue = this.getPreferredAxisMinValue();
            axisInterval = this.getPreferredAxisInterval();
            this.setPreferredAxisMinValue(Double.valueOf(oldAxisMinValue - axisInterval));
        }
    }

    @NotNull
    private List<String> calculateValueAxisScalesByDefault() {
        int n = 0;
        if (this.getPreferredAxisInterval() < 1.0) {
            n = MathUtil.getMinimumTimesToGreaterThanOne((Double)this.getPreferredAxisInterval());
        }
        if (n == 0) {
            n = AgileDataChartFieldDisplayFormat.DEFAULT_DECIMAL;
        }
        String axisScaleFormat = "%,." + n + "f";
        MagnitudeUnit magnitudeUnit = CurrencyUtil.getUnitOfMagnitudeByLocale((String)this.locale, (Double)MathUtil.getMaxValueByAbs((Double)this.getPreferredAxisMinValue(), (Double)this.getPreferredAxisMaxValue()));
        ArrayList<String> axisData = new ArrayList<String>();
        if (this.getPreferredAxisMinValue() > 0.0) {
            axisData.add(String.format(axisScaleFormat, 0.0));
        }
        double prevValue = 0.0;
        for (double i = this.getPreferredAxisMinValue().doubleValue(); i <= this.getPreferredAxisMaxValue(); i += this.getPreferredAxisInterval().doubleValue()) {
            if (prevValue < 0.0 && i > 0.0) {
                axisData.add(String.format(axisScaleFormat, 0.0));
            }
            String scaleString = String.valueOf(new BigDecimal(String.valueOf(i)));
            axisData.add(scaleString);
            prevValue = i;
        }
        if (this.getPreferredAxisMaxValue() < 0.0) {
            axisData.add(String.format(axisScaleFormat, 0.0));
        }
        return axisData;
    }

    private List<String> calculateValueAxisScalesByFormat(AgileDataChartFieldDisplayFormat format) {
        MagnitudeUnit magnitudeUnit = CurrencyUtil.getUnitOfMagnitudeByLocale((String)this.locale, (Double)MathUtil.getMaxValueByAbs((Double)this.getPreferredAxisMinValue(), (Double)this.getPreferredAxisMaxValue()));
        ArrayList<String> axisData = new ArrayList<String>();
        if (this.getPreferredAxisMinValue() > 0.0) {
            axisData.add(format.getFormattedString(Double.valueOf(0.0)));
        }
        double epsilon = 1.0E-9;
        double prevValue = 0.0;
        for (double i = this.getPreferredAxisMinValue().doubleValue(); i <= this.getPreferredAxisMaxValue(); i += this.getPreferredAxisInterval().doubleValue()) {
            if (prevValue < 0.0 && Math.abs(prevValue) > epsilon && i > 0.0) {
                axisData.add(format.getFormattedString(Double.valueOf(0.0)));
            }
            String scaleString = format.getFormattedString(Double.valueOf(new BigDecimal(String.valueOf(i)).doubleValue()));
            axisData.add(scaleString);
            prevValue = i;
        }
        if (this.getPreferredAxisMaxValue() < 0.0) {
            axisData.add(format.getFormattedString(Double.valueOf(0.0)));
        }
        return axisData;
    }

    public String getLocale() {
        return this.locale;
    }

    public ChartTypeEnum getChartTypeEnum() {
        return this.chartTypeEnum;
    }

    public Integer getGroup() {
        return this.group;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMeanValue() {
        return this.meanValue;
    }

    public Double getMedianValue() {
        return this.medianValue;
    }

    public Double getStdDeviation() {
        return this.stdDeviation;
    }

    public Double[] getIrregularValues() {
        return this.irregularValues;
    }

    public Double getPreferredAxisMinValue() {
        return this.preferredAxisMinValue;
    }

    public Double getPreferredAxisMaxValue() {
        return this.preferredAxisMaxValue;
    }

    public Double getPreferredAxisInterval() {
        return this.preferredAxisInterval;
    }

    public AgileDataChartFieldDisplayFormat getFormat() {
        return this.format;
    }

    public Integer getNegativeValueAxisScaleCount() {
        return this.negativeValueAxisScaleCount;
    }

    public Integer getPositiveValueAxisScaleCount() {
        return this.positiveValueAxisScaleCount;
    }
}

