/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.GrowthRateMeasurePresent;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.GrowthRateParams;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.MeasurePresent;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.NotSupportedMeasurePresent;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgileDataChartMeasurePresentJsonDeserializer
extends JsonDeserializer<MeasurePresent> {
    private static final Logger log = LoggerFactory.getLogger(AgileDataChartMeasurePresentJsonDeserializer.class);

    public MeasurePresent deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        log.debug("AgileDataChartMeasurePresentJsonDeserializer activated!!!");
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode formulationIdNode = node.get("formulationId");
        GrowthRateMeasurePresent measurePresent = null;
        if (formulationIdNode instanceof TextNode) {
            String formulationId = formulationIdNode.asText();
            if (Objects.equals("growth_rate", formulationId.toLowerCase())) {
                measurePresent = new GrowthRateMeasurePresent();
                measurePresent.setFormulationId(formulationId);
                JsonNode paramsNode = node.get("params");
                GrowthRateParams params = new GrowthRateParams().setApplyToField(paramsNode.get("applyToField").asText());
                measurePresent.setParams((Object)params);
                AgileDataChartFieldDisplayFormat format = new AgileDataChartFieldDisplayFormat();
                JsonNode formatNode = node.get("format");
                if (null == formatNode || formatNode.isEmpty()) {
                    format.setDecimal(AgileDataChartFieldDisplayFormat.DEFAULT_DECIMAL).setPercent("percent");
                } else {
                    format.setDecimal(Integer.valueOf(formatNode.get("decimal").asInt())).setPercent(formatNode.get("percent").asText());
                }
                measurePresent.setFormat(format);
            } else {
                measurePresent = new NotSupportedMeasurePresent();
            }
        }
        return measurePresent;
    }
}

