/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.BaseDataDoubleCombineSubmitActionParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseDataDoubleDocumentPageDefineAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotDoubleDocumentPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private GeneralDataSourceService generalDataSourceService;
    @Autowired
    private TmPageOperationService tmPageOperationService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    public List<PcUiBotDoubleDocumentPageDefine> analysis(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        this.handleMainDataSource(tmActivity, executeContext);
        this.replaceDslAndDataSources(tmActivity, executeContext.getPageCode());
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    private void replaceDslAndDataSources(PcUiBotTmActivity tmActivity, String pageCode) {
        Map dataSources;
        if (!Arrays.asList("DataEntry_pccProjectQuestionList").contains(tmActivity.getActivityId())) {
            return;
        }
        MobileDesignerConfig config = this.mobileDesignerConfigRepository.selectOneDsl(tmActivity.getActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (config == null) {
            return;
        }
        PcUiBotTmPage page = this.replaceDsl(pageCode, config);
        if (page != null) {
            tmActivity.setPages(page);
        }
        if ((dataSources = this.replaceDataSources(tmActivity.getDataSources(), config)) != null) {
            tmActivity.setDataSources(dataSources);
        }
    }

    public PcUiBotTmPage replaceDsl(String pageCode, MobileDesignerConfig config) {
        JSONObject pageJson = Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> {
            if ("browse-page-mobile".equals(pageCode)) {
                return r.getJSONObject("pageDslMobile");
            }
            if ("edit-page-mobile".equals(pageCode)) {
                return r.getJSONObject("detailDslMobile");
            }
            return null;
        }).orElse(null);
        if (pageJson == null) {
            return null;
        }
        PcUiBotTmPage page = (PcUiBotTmPage)JsonUtil.objectToJavaObject((Object)pageJson, PcUiBotTmPage.class);
        JSONObject dataSources = pageJson.getJSONObject("dataSources");
        if (dataSources == null || dataSources.isEmpty()) {
            return page;
        }
        dataSources.keySet().stream().findFirst().ifPresent(arg_0 -> ((PcUiBotTmPage)page).setDataSourceName(arg_0));
        return page;
    }

    private Map<String, PcUiBotTmQueryAction> replaceDataSources(Map<String, PcUiBotTmQueryAction> oldDataSources, MobileDesignerConfig config) {
        oldDataSources = Optional.ofNullable(oldDataSources).orElse(new HashMap());
        HashMap productNameMap = new HashMap();
        oldDataSources.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)value.getProductName())) {
                productNameMap.put(key, value.getProductName());
            }
        });
        HashMap tempDataSources = new HashMap();
        Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> r.getJSONObject("pageDslMobile")).map(r -> r.get((Object)"dataSources")).map(r -> (Map)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).ifPresent(tempDataSources::putAll);
        Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> r.getJSONObject("detailDslMobile")).map(r -> r.get((Object)"dataSources")).map(r -> (Map)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).ifPresent(tempDataSources::putAll);
        String productName = "";
        for (String string : tempDataSources.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)productNameMap.get(string)))) continue;
            productName = (String)productNameMap.get(string);
            break;
        }
        for (Map.Entry entry : tempDataSources.entrySet()) {
            String key3 = (String)entry.getKey();
            PcUiBotTmQueryAction value2 = (PcUiBotTmQueryAction)entry.getValue();
            if (oldDataSources.containsKey(key3)) continue;
            if ("DataEntry_pccProjectQuestionList".equals(Optional.ofNullable(config).map(MobileDesignerConfig::getTmActivityId).orElse("")) && "esp_bm.basc.project.question.detail.get".equals(value2.getActionId())) {
                value2.setProductName("BM-BASC");
            } else {
                value2.setProductName(productName);
            }
            oldDataSources.put(key3, value2);
        }
        return oldDataSources;
    }

    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, dataSources);
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                dataSourceDTO.setType("RECYCLE");
            }
        }
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                dataSourceDTO.setType("RECYCLE");
            }
        }
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmDataState dataState) {
        List tmDataViewQueryList = dataState.getDataViewQuerys();
        if (CollectionUtils.isEmpty((Collection)tmDataViewQueryList)) {
            return;
        }
        pageDefine.setDataViewQueryList(pageDefine.convertDataViewQueryList(tmDataViewQueryList));
        List dataViewQueryList = pageDefine.getDataViewQueryList();
        pageDefine.setDataSourceSet(null);
        PcUiBotDataViewQueryDTO dataViewQueryDefault = dataViewQueryList.stream().filter(dataView -> BooleanUtils.isTrue((Boolean)dataView.getIsDefault())).findFirst().orElse((PcUiBotDataViewQueryDTO)dataViewQueryList.get(0));
        dataViewQueryDefault.setIsDefault(Boolean.TRUE);
        String viewCode = dataViewQueryDefault.getViewCode();
        this.dataViewService.appendNecessaryData(viewCode, pageDefine, executeContext);
        if (!CollectionUtils.isEmpty((Collection)tmDataViewQueryList) && !CollectionUtils.isEmpty((Collection)pageDefine.getPageLayout())) {
            dataState.setPageLayout(pageDefine.getPageLayout());
        }
    }

    protected PcUiBotDoubleDocumentPageDefine createNewPageDefine() {
        return new PcUiBotDoubleDocumentPageDefine();
    }

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return oldExecuteContext.clone();
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        String mainDataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        if (pageDefine.isDefaultShow() && CollectionUtils.isNotEmpty(submitActions)) {
            ArrayList actionsList = new ArrayList();
            List tmpSubmitActions = this.analysisBaseDataSubmitActions(executeContext, mainDataSourceName, dataState, submitActions);
            if (CollectionUtils.isNotEmpty((Collection)tmpSubmitActions)) {
                actionsList.addAll(tmpSubmitActions);
            }
            if (actionsList.size() > 0) {
                ((PcUiBotSubmitAction)actionsList.get(0)).setDefaultAction(true);
            }
            pageDefine.setSubmitActions(actionsList);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        }
    }

    private List<PcUiBotSubmitAction> analysisBaseDataSubmitActions(PcUiBotExecuteContext executeContext, String mainDataSourceName, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        BaseDataDoubleCombineSubmitActionParser parser = (BaseDataDoubleCombineSubmitActionParser)SpringContextHolder.getBean(BaseDataDoubleCombineSubmitActionParser.class);
        parser.init(executeContext, dataState, mainDataSourceName);
        return parser.parse(submitActions);
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        if (null == executeContext.getIsRecycle() || BooleanUtils.isFalse((Boolean)executeContext.getIsRecycle())) {
            this.tmPageOperationService.createOperations(executeContext, (PcUiBotPageDefine)pageDefine, tmActivity, operations);
        }
    }

    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        pageDefine.setDatamap(tmActivity.getDatamap());
        pageDefine.setExplanation(tmPage.getExplanation());
        if (tmPage.getShowDataProperties() != null) {
            pageDefine.setShowDataProperties(tmPage.getShowDataProperties());
            pageDefine.getShowDataProperties().add("edit_type");
        }
        if (tmPage.getStatusFlag() != null) {
            pageDefine.setStatusFlag(tmPage.getStatusFlag());
        } else {
            pageDefine.setStatusFlag(Boolean.valueOf(false));
        }
        pageDefine.setDataSourceName(tmPage.getDataSourceName());
        if (("browse-page-mobile".equals(executeContext.getPageCode()) || "basic-data-mobile".equals(executeContext.getPageCode())) && ("DOUBLE-DOCUMENT".equals(executeContext.getCategory()) || "RECYCLE".equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(Boolean.valueOf(false));
            return;
        }
        if ("basic-data-mobile".equals(executeContext.getPageCode()) && ("SIGN-DOCUMENT".equals(executeContext.getCategory()) || "TREEDATA-SINGLE-DOCUMENT".equals(executeContext.getCategory()) || "SINGLE-DOCUMENT".equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(Boolean.valueOf(true));
            return;
        }
        if (("edit-page-mobile".equals(executeContext.getPageCode()) || "basic-data-mobile".equals(executeContext.getPageCode())) && "DOUBLE-DOCUMENT".equals(executeContext.getCategory())) {
            pageDefine.setCanEdit(Boolean.valueOf(true));
        }
    }
}

