/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.designer.uibot.support.PcUiBotOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataViewQuery;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmViewShowFields;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl.DataViewRawDslRenderService;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataViewOpenWindowDefineAnalyzer
extends PcUiBotOpenWindowDefineAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(DataViewOpenWindowDefineAnalyzer.class);
    @Resource
    private DataViewService dataViewService;

    public PcUiBotOpenWindowDefineDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmOperation tmOperation, Boolean isFlowEngine) {
        PcUiBotTmOperationOpenWindowDefine tmOperationOpenWindowDefine = tmOperation.getOpenWindowDefine();
        PcUiBotTmQueryAction allAction = tmOperationOpenWindowDefine.getAllAction();
        String viewCode = allAction.getViewCode();
        PcUiBotTmDataViewQuery tmDataViewQuery = this.dataViewService.queryDataView(viewCode, executeContext);
        if (tmDataViewQuery == null) {
            log.warn("TmDataViewQuery empty, viewCode: {}", (Object)viewCode);
            return super.analysis(executeContext, tmOperation, isFlowEngine);
        }
        PcUiBotTmQueryAction tmQueryAction = this.dataViewService.buildTmQueryAction(allAction, tmDataViewQuery);
        tmOperationOpenWindowDefine.setAllAction(tmQueryAction);
        PcUiBotOpenWindowDefineDTO openWindowDefine = super.analysis(executeContext, tmOperation, isFlowEngine);
        String dataSourceName = Optional.ofNullable(openWindowDefine.getAllAction()).map(PcUiBotPageDefine::getDataSourceSet).map(PcUiBotDataSourceSetDTO::getMainDatasource).orElse(null);
        PcUiBotTmViewShowFields viewShowFields = tmDataViewQuery.getViewShowFields();
        viewShowFields = DataViewRawDslRenderService.resetNameAndDslPath((String)dataSourceName, (PcUiBotTmViewShowFields)viewShowFields);
        openWindowDefine.setViewShowFields(viewShowFields);
        return openWindowDefine;
    }
}

