/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.BaseDataCombineSubmitActionParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkbenchPageDefineAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private GeneralDataSourceService generalDataSourceService;
    @Autowired
    private TmPageOperationService tmPageOperationService;

    public List<PcUiBotPageDefine> analysis(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityDefinitionOfWorkbench(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    private PcUiBotTmActivity getActivityDefinitionOfWorkbench(PcUiBotExecuteContext executeContext) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinitionOfWorkbench(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, dataSources);
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO pcUiBotDataSourceDTO : dataSourceSet.getDataSourceList()) {
                pcUiBotDataSourceDTO.setType("RECYCLE");
            }
        }
        for (Map.Entry<String, Object> entry : dataSources.entrySet()) {
            PcUiBotTmQueryAction queryAction = (PcUiBotTmQueryAction)entry.getValue();
            List list = queryAction.getSearchInfos();
            if (null == list || list.isEmpty()) continue;
            pageDefine.setSearchInfo((List)JsonUtil.objectToJavaObject((Object)list, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                dataSourceDTO.setType("RECYCLE");
            }
        }
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    protected PcUiBotPageDefine createNewPageDefine() {
        return new PcUiBotPageDefine();
    }

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return oldExecuteContext.clone();
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        String mainDataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        if (pageDefine.isDefaultShow() && !CollectionUtils.isEmpty(submitActions)) {
            ArrayList actionsList = new ArrayList();
            List tmpSubmitActions = this.analysisBaseDataSubmitActions(executeContext, mainDataSourceName, dataState, submitActions);
            if (!CollectionUtils.isEmpty((Collection)tmpSubmitActions)) {
                actionsList.addAll(tmpSubmitActions);
            }
            if (actionsList.size() > 0) {
                ((PcUiBotSubmitAction)actionsList.get(0)).setDefaultAction(true);
            }
            pageDefine.setSubmitActions(actionsList);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        }
    }

    private List<PcUiBotSubmitAction> analysisBaseDataSubmitActions(PcUiBotExecuteContext executeContext, String mainDataSourceName, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        BaseDataCombineSubmitActionParser parser = (BaseDataCombineSubmitActionParser)SpringContextHolder.getBean((String)"baseDataCombineSubmitActionParser");
        parser.init(executeContext, dataState, mainDataSourceName);
        return parser.parse(submitActions);
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
    }

    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        super.analysisBaseInfo(executeContext, pageDefine, tmActivity, tmPage);
    }
}

