/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryInfoSetService {
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    public void analysisLayoutDsl(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmDataState dataState) {
        UiBotPageLayout pageLayout = this.getPageLayout(dataState.getPageLayout());
        if (pageLayout == null) {
            return;
        }
        PcUiBotQueryInfo queryInfo = this.analysisComponentQueryInfo(executeContext, pageLayout.getBody());
        if (queryInfo == null) {
            return;
        }
        this.analysisComponentPaging(pageDefine, queryInfo);
    }

    private UiBotPageLayout getPageLayout(List<UiBotPageLayout> pageLayout) {
        if (CollectionUtils.isEmpty(pageLayout)) {
            return null;
        }
        String pageId = AppRequestContext.getContextEntity().getPageId();
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return this.uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        }
        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName((String)pageId);
        if (pageIdEnum == null) {
            return pageLayout.stream().filter(layout -> pageId.equals(layout.getPageId())).findFirst().orElse(null);
        }
        return this.uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
    }

    public PcUiBotQueryInfo analysisComponentQueryInfo(PcUiBotExecuteContext executeContext, List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        if (CollectionUtils.isEmpty(body)) {
            return null;
        }
        ArrayList listCmpt = Lists.newArrayList((Object[])new String[]{"DW_ZTB_VIEW_LIST", "DW_EDIT_CARD_LIST"});
        for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : body) {
            ZtbViewList ztbViewList;
            PcUiBotQueryInfo queryInfo;
            if (!listCmpt.contains(wrapper.getComponentType())) continue;
            if (wrapper.getData() instanceof EditCardList) {
                EditCardList editCardList = (EditCardList)wrapper.getData();
                queryInfo = editCardList.getQueryInfo();
                if (queryInfo == null || BooleanUtils.isTrue((Boolean)this.checkMultiDataSource(executeContext, (DataSource)Optional.ofNullable(editCardList.getCardListData()).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null)))) continue;
                return queryInfo;
            }
            if (!(wrapper.getData() instanceof ZtbViewList) || (queryInfo = (ztbViewList = (ZtbViewList)wrapper.getData()).getQueryInfo()) == null || BooleanUtils.isTrue((Boolean)this.checkMultiDataSource(executeContext, (DataSource)Optional.ofNullable(ztbViewList.getCardListData()).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null)))) continue;
            return queryInfo;
        }
        return null;
    }

    private Boolean checkMultiDataSource(PcUiBotExecuteContext executeContext, DataSource dataSource) {
        if (dataSource == null || StringUtils.isEmpty((CharSequence)dataSource.getActionId())) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)executeContext.getMainDataSourceName()) || StringUtils.isEmpty((CharSequence)dataSource.getActionName())) {
            return false;
        }
        if (Objects.equals(dataSource.getActionName(), executeContext.getMainDataSourceName())) {
            return false;
        }
        return true;
    }

    public void analysisComponentPaging(PcUiBotPageDefine pageDefine, PcUiBotQueryInfo queryInfo) {
        PcUiBotPageInfo pageInfo = Optional.ofNullable(queryInfo).orElse(new PcUiBotQueryInfo()).getPageInfo();
        if (pageInfo != null && pageInfo.getPageSize() != null) {
            pageDefine.setUseHasNext(Boolean.valueOf(true));
            pageDefine.setEnablePaging(Boolean.valueOf(true));
            pageDefine.setEnableBackEndPaging(Boolean.valueOf(true));
            PcUiBotPageInfo tempPageInfo = new PcUiBotPageInfo();
            tempPageInfo.setPageNo(Integer.valueOf(1));
            tempPageInfo.setPageSize(pageInfo.getPageSize());
            tempPageInfo.setPagingConfigOnList(true);
            pageDefine.setPageInfo(tempPageInfo);
            pageInfo.setPagingConfigOnList(true);
        }
    }

    public void buildLayoutDsl(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        UiBotPageLayout pageLayout = this.getPageLayout(pageDefine.getPageLayout());
        if (pageLayout == null) {
            return;
        }
        PcUiBotQueryInfo queryInfo = this.analysisComponentQueryInfo(executeContext, pageLayout.getBody());
        if (queryInfo == null) {
            return;
        }
        this.processQueryInfoData(executeContext, queryResultSet, pageDefine, queryInfo);
    }

    public void processQueryInfoData(PcUiBotExecuteContext executeContext, QueryResultSet dataResult, PcUiBotPageDefine pageDefine, PcUiBotQueryInfo queryInfo) {
        if (pageDefine == null || pageDefine.getUseHasNext() == null || !pageDefine.getUseHasNext().booleanValue()) {
            return;
        }
        if (pageDefine.getPageInfo() == null && (MapUtils.isEmpty((Map)pageDefine.getParameter()) || !pageDefine.getParameter().containsKey("page_size"))) {
            return;
        }
        if (dataResult == null || dataResult.getMainQueryResult() == null || dataResult.getMainQueryResult().getTotalResults() == null) {
            return;
        }
        PcUiBotPageInfo pageInfo = queryInfo.getPageInfo();
        if (pageDefine.getPageInfo() != null && pageDefine.getPageInfo().isPagingConfigOnList() && pageInfo == null) {
            return;
        }
        double totalResults = Math.round(dataResult.getMainQueryResult().getTotalResults().intValue());
        pageInfo.setTotalResults(Integer.valueOf((int)Math.floor(totalResults)));
        if (dataResult.getMainQueryResult().isHasNext() && pageInfo.getTotalResults() > 0) {
            pageInfo.setHasNext(true);
        } else {
            pageInfo.setHasNext(false);
        }
        pageInfo.setPageCountSize(Integer.valueOf(0));
        if (!CollectionUtils.isEmpty((Collection)dataResult.getMainQueryResult().getData())) {
            pageInfo.setPageCountSize(Integer.valueOf(dataResult.getMainQueryResult().getData().size()));
        }
    }
}

