/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabContentArea;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncConfig;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncResponseTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemContentEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DslPageDataSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryInfoSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.AbstractPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBaseDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBuilderUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DslPageBuilderBase<T extends PcUiBotPageDefine>
extends AbstractPageBuilder<T> {
    private static final String EDIT_TYPE_ADD = "add";
    @Autowired
    protected UiBotDesignerRenderService uiBotDesignerRenderService;
    @Autowired
    protected BusinessProcessPerformerImpl businessProcessPerformer;
    @Autowired
    protected DslPageDataSetService dslPageDataSetService;
    @Autowired
    private QueryInfoSetService queryInfoSetService;

    public void afterPropertiesSet() throws Exception {
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, ApiRequest apiRequest) {
        UiBotModel uiBotModel = this.createRawPage(executeContext, queryResultSet, pageDefine, apiRequest);
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if ("edit-page-mobile".equals(executeContext.getPageCode())) {
            this.handleRawBottomButton(executeContext, pageDefine, uiBotModel);
            this.addLayout(pageDefine, uiBotModel);
            UiBotDesignerRenderService.handleRawPageData((ApiRequest)apiRequest, (UiBotModel)uiBotModel);
        }
        this.bulidRanderData(apiRequest, executeContext, uiBotModel, pageDefine, null);
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength((String)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private void handleRawBottomButton(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel uiBotModel) {
        List pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty((Collection)pageLayout)) {
            return;
        }
        UiBotPageLayout mainPageLayout = this.uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        List bottom = mainPageLayout.getBottom();
        if (CollectionUtils.isEmpty((Collection)bottom)) {
            return;
        }
        BaseMobileComponentWrapper wrapper = (BaseMobileComponentWrapper)bottom.get(0);
        if (!(wrapper.getData() instanceof ButtonGroup)) {
            return;
        }
        ButtonGroup buttonGroup = (ButtonGroup)wrapper.getData();
        List contentGroup = buttonGroup.getContentGroup();
        if (CollectionUtils.isEmpty((Collection)contentGroup)) {
            return;
        }
        for (BaseMobileComponentWrapper componentWrapper : contentGroup) {
            UiBotAction submitAction;
            Button button = (Button)componentWrapper.getData();
            if (button == null || (submitAction = button.getSubmitAction()) == null || !"workflow-abort".equals(submitAction.getActionServiceIdName())) continue;
            this.buildSubmitActionParas(submitAction, executeContext, pageDefine, uiBotModel);
            submitAction.setId("workflow-abort");
            submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
            UiBotJumpAction uiBotJumpAction = submitAction.getJumpAction();
            if (uiBotJumpAction == null) {
                uiBotJumpAction = new UiBotJumpAction();
            }
            submitAction.setJumpAction(uiBotJumpAction);
            uiBotJumpAction.setBtnStyleType(submitAction.getDefaultAction() != false ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
            uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_WORKFLOW_ABORT.name());
            uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
            uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
            uiBotJumpAction.setRawData(this.buildRawData(submitAction, pageDefine.getDataSourceSet().getMainDatasource(), uiBotModel));
        }
    }

    private void buildSubmitActionParas(UiBotAction submitAction, PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel uiBotModel) {
        HashMap<String, String> paras = submitAction.getParas();
        if (paras == null) {
            paras = new HashMap<String, String>();
        }
        paras.put("comment", "");
        paras.put("serialNumber", this.getSerialNumber(pageDefine, uiBotModel));
        paras.put("performerId", executeContext.getAuthoredUser().getUserId());
        submitAction.setParas(paras);
    }

    private String getSerialNumber(T pageDefine, UiBotModel uiBotModel) {
        String serialNumber = "";
        String mainDatasource = pageDefine.getDataSourceSet().getMainDatasource();
        Object v = uiBotModel.getPageData().get((Object)mainDatasource);
        if (v instanceof Map) {
            serialNumber = (String)((Map)v).get("serial_number");
        } else if (v instanceof List && !CollectionUtils.isEmpty((Collection)((Collection)v))) {
            serialNumber = (String)((Map)((List)v).get(0)).get("serial_number");
        }
        return serialNumber;
    }

    private Map<String, Object> buildRawData(UiBotAction uiBotAction, String dataSourceName, UiBotModel uiBotModel) {
        return BottomButtonDigiwinAthena.assembleRawData((UiBotAction)uiBotAction, (String)dataSourceName, (Object)uiBotModel.getPageData().get((Object)dataSourceName), null, (String)uiBotAction.getId(), (String)"");
    }

    public UiBotModel createRawPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, ApiRequest apiRequest) {
        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
        executeContext.setIsDesigner(Boolean.valueOf(true));
        if (pageDefine == null || pageDefine.getDataSourceSet() == null || pageDefine.getDataSourceSet().getDataSourceList() == null) {
            return dynamicForm;
        }
        this.BuildRule(executeContext, pageDefine, dynamicForm, apiRequest);
        this.BuildLayout(executeContext, queryResultSet, pageDefine);
        this.BuildPageData(executeContext, queryResultSet, pageDefine, dynamicForm);
        this.BuildActions(pageDefine, dynamicForm.getPageData());
        PcUiBotBuilderUtils.BuildVariables((UiBotModel)dynamicForm);
        return dynamicForm;
    }

    private void addLayout(T pageDefine, UiBotModel uiBotModel) {
        UiBotQueryButton queryButton = (UiBotQueryButton)JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        uiBotLayout.setQueryButtons((List)Lists.newArrayList((Object[])new UiBotQueryButton[]{queryButton}));
        uiBotModel.addLayout(uiBotLayout);
    }

    private void BuildLayout(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine) {
        this.queryInfoSetService.buildLayoutDsl(executeContext, queryResultSet, pageDefine);
    }

    public void BuildActions(T pageDefine, UiBotPageData pageData) {
        if (this.requireRenderActions(pageDefine, (Map)pageData)) {
            String key = pageDefine.getDataSourceSet().getMainDatasource();
            for (PcUiBotSubmitAction action : pageDefine.getSubmitActions()) {
                if (action.getSubmitType() == null || key == null || key.equals(action.getSubmitType().getSchema())) continue;
                action.getSubmitType().setSchema(key);
            }
        }
        this.uiBotDesignerRenderService.buildCmptSubmitAction(pageDefine);
    }

    private void BuildPageData(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, UiBotModel dynamicForm) {
        this.dslPageDataSetService.getPageDataSet(executeContext, pageDefine, queryResultSet, dynamicForm);
        this.supplyPageData(dynamicForm, pageDefine);
    }

    private void supplyPageData(UiBotModel dynamicForm, PcUiBotPageDefine pageDefine) {
        if (pageDefine instanceof PcUiBotDoubleDocumentPageDefine) {
            PcUiBotBaseDataUtil.setManageStatusDefaultValue((PcUiBotExecuteContext)pageDefine.getExecuteContext(), (PcUiBotPageDefine)pageDefine, (UiBotModel)dynamicForm);
        }
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, T pageDefine, String componentType) {
        ComponentContext cmptContext = (ComponentContext)JsonUtil.objectToJavaObject((Object)apiRequest, ComponentContext.class);
        cmptContext.setPageDefine(pageDefine);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setExtendedFields(pageDefine.getExtendedFields());
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.DATA_ENTRY.name());
        mobilePageRawData.setDataKeys((List)Optional.ofNullable(pageDefine.getDataSourceSet()).map(PcUiBotDataSourceSetDTO::getFirstDataQuery).map(PcUiBotDataSourceDTO::getDataKeys).orElse(null));
        this.uiBotDesignerRenderService.buildMainPageHooksByPageDefine(pageDefine, cmptContext, uiBotModel, componentType);
        if (!this.checkIsExistTabs(pageDefine)) {
            UiBotQueryButton queryButton = (UiBotQueryButton)JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);
            List bodyCmptList = this.businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
            if (CollectionUtils.isEmpty((Collection)bodyCmptList)) {
                uiBotModel.getRenderData().addEmptyComponentToBody();
            } else {
                int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType((List)bodyCmptList);
                if (bodyContainerType == 1) {
                    SingleListContainer singleListContainer = new SingleListContainer();
                    singleListContainer.addAll(bodyCmptList);
                    uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
                } else {
                    uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
                }
                List bottomCmptList = this.businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (!CollectionUtils.isEmpty((Collection)bottomCmptList)) {
                    uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
                }
            }
        } else {
            BaseMobileComponent tabs = this.buildTabs(executeContext, uiBotModel, cmptContext, pageDefine, mobilePageRawData, componentType);
            uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper(tabs, "DW_" + tabs.returnComponentType()));
        }
    }

    private boolean checkIsExistTabs(T pageDefine) {
        if (!(pageDefine instanceof PcUiBotDoubleDocumentPageDefine)) {
            return false;
        }
        PcUiBotDoubleDocumentPageDefine pcUiBotDoubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine)pageDefine;
        return !CollectionUtils.isEmpty((Collection)pcUiBotDoubleDocumentPageDefine.getDataViewQueryList());
    }

    private BaseMobileComponent buildTabs(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ComponentContext cmptContext, T pageDefine, MobilePageRawData mobilePageRawData, String componentType) {
        int i;
        PcUiBotDoubleDocumentPageDefine doubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine)pageDefine;
        List dataViewQueryList = doubleDocumentPageDefine.getDataViewQueryList();
        UiBotQueryButton queryButton = (UiBotQueryButton)JsonUtil.objectToJavaObject((Object)doubleDocumentPageDefine, UiBotQueryButton.class);
        CustomTabController customTabController = new CustomTabController();
        customTabController.setSwipeable(Boolean.valueOf(true));
        customTabController.setTabAlign(Integer.valueOf(0));
        ArrayList<CustomTabControllerItem> items = new ArrayList<CustomTabControllerItem>(dataViewQueryList.size());
        customTabController.setTabLayoutType(CustomTabControllerItemLayoutTypeEnum.HORIZONTAL.getValue());
        customTabController.setTabItems(items);
        customTabController.setDefaultSelected(Integer.valueOf(0));
        for (i = 0; i < dataViewQueryList.size(); ++i) {
            if (!BooleanUtils.isTrue((Boolean)((PcUiBotDataViewQueryDTO)dataViewQueryList.get(i)).getIsDefault())) continue;
            customTabController.setDefaultSelected(Integer.valueOf(i));
        }
        for (i = 0; i < dataViewQueryList.size(); ++i) {
            CustomTabControllerItem item = new CustomTabControllerItem();
            items.add(item);
            item.setFlushType(Integer.valueOf(1));
            item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
            PcUiBotDataViewQueryDTO dataViewQueryDTO = (PcUiBotDataViewQueryDTO)dataViewQueryList.get(i);
            String tabTitle = dataViewQueryDTO.getViewName();
            item.setId(dataViewQueryDTO.getViewCode());
            item.setName(tabTitle);
            item.setLayoutType(CustomTabControllerItemLayoutTypeEnum.VERTICAL.getValue());
            item.setScrollable(Boolean.valueOf(true));
            CustomTabContentArea contentArea = new CustomTabContentArea();
            if (i == customTabController.getDefaultSelected()) {
                item.setContentArea(contentArea);
                item.setAsyncForData(Boolean.valueOf(false));
                List bodyCmptList = this.businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (CollectionUtils.isEmpty((Collection)bodyCmptList)) {
                    CustomTabContentContainer customTabContentContainer = CustomTabContentContainer.emptyContainerUnContainCustomGroup((String)cmptContext.getLocale());
                    customTabContentContainer.setContentCmptType("DW_" + customTabContentContainer.getContentCmptType());
                    contentArea.getBodyArea().add(customTabContentContainer);
                } else {
                    contentArea.getBodyArea().addAll(bodyCmptList.stream().map(r -> {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setMobilePath(r.getMobilePath());
                        container.setSchema(r.getSchema());
                        container.setContentCmptType(r.getComponentType());
                        container.setData((Object)r.getData());
                        return container;
                    }).collect(Collectors.toList()));
                }
                List bottomCmptList = this.businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (!CollectionUtils.isEmpty((Collection)bottomCmptList)) {
                    contentArea.getBottomArea().addAll(bottomCmptList.stream().map(r -> {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setMobilePath(r.getMobilePath());
                        container.setSchema(r.getSchema());
                        container.setContentCmptType(r.getComponentType());
                        container.setData((Object)r.getData());
                        return container;
                    }).collect(Collectors.toList()));
                }
                contentArea.resetSize();
                continue;
            }
            item.setContentArea(contentArea);
            item.setAsyncForData(Boolean.valueOf(true));
            contentArea.setSize(Integer.valueOf(0));
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("executeContext", executeContext);
            rawData.put("viewCode", dataViewQueryDTO.getViewCode());
            rawData.put("viewName", dataViewQueryDTO.getViewName());
            rawData.put("dataSourceSet", dataViewQueryDTO.getDataSourceSet());
            item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create((String)cmptContext.getIamUserToken(), (String)cmptContext.getLocale(), (String)cmptContext.getRequestId(), (String)(AppContext.getBaseUrl() + "/mobile/v1/uibot/dataView/show"), (String)cmptContext.getClientId(), (String)cmptContext.getTenantId(), rawData));
            item.setAsyncResponseType(CustomTabControllerItemAsyncResponseTypeEnum.UIBOTMODE.getType());
        }
        return customTabController;
    }

    private boolean requireRenderActions(T pageDefine, Map<String, Object> pageData) {
        if (pageDefine.getSubmitActions() == null) {
            return false;
        }
        PcUiBotDataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
        PcUiBotExecuteContext executeContext = pageDefine.getExecuteContext();
        if (null != executeContext && (PcUiBotPatternUtil.isBaseData((String)executeContext.getPattern()) || PcUiBotPatternUtil.isStatement((String)executeContext.getPattern()) || PcUiBotPatternUtil.isWorkBench((String)executeContext.getPattern()))) {
            return true;
        }
        if (null == dataSourceSetDTO || CollectionUtils.isEmpty((Collection)dataSourceSetDTO.getDataSourceList())) {
            return true;
        }
        if (CollectionUtils.isEmpty(pageData)) {
            return false;
        }
        for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSetDTO.getDataSourceList()) {
            Object dataObj = pageData.get(dataSourceDTO.getName());
            if (null == dataObj) continue;
            if (!(dataObj instanceof Collection)) {
                return true;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)dataObj))) continue;
            return true;
        }
        return false;
    }

    protected QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, T pageDefine) {
        if (pageDefine == null) {
            return null;
        }
        QueryResultSet queryResultSet = super.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        return queryResultSet;
    }
}

