/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.ProjectPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.TemplateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ProjectPageServiceImpl
implements ProjectPageService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ProjectPageServiceImpl.class);
    @Autowired
    private List<TemplateService<PcUiBotTaskPageDefine>> templateList;
    private final Map<String, TemplateService<PcUiBotTaskPageDefine>> templateContainer = new HashMap();
    @Autowired
    private ProjectPageDefineAnalyzer projectPageDefineAnalyzer;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    public void afterPropertiesSet() throws Exception {
        if (this.templateList != null) {
            for (TemplateService template : this.templateList) {
                if (this.templateContainer.containsKey(template.supportKey())) {
                    throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\uff0c\u8bf7\u91cd\u4fee\u6539\u4ee3\u7801\uff1a" + template.supportKey());
                }
                this.templateContainer.put(template.supportKey(), template);
            }
        }
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
        this.appendUserOrderConditions(executeContext, pageDefine);
        if ("project-detail-mobile".equals(executeContext.getPageCode())) {
            if (!CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions()) && executeContext.isShared() && !executeContext.isOwnerBacklog()) {
                pageDefine.setSubmitActions(new ArrayList());
                pageDefine.setSubmitType(null);
            }
            if (pageDefine.getFinished() != null && !pageDefine.getFinished().booleanValue() && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepAction((List)pageDefine.getSubmitActions()));
            }
        } else if (pageDefine.getFinished() != null && !pageDefine.getFinished().booleanValue() && "completed".equals(pageDefine.getDataStateCode())) {
            pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepWithdrawAction((List)pageDefine.getSubmitActions()));
        }
        UiBotModel uiBotModel = null;
        TemplateService templateService = this.getTemplate(executeContext, pageDefine.getVersion(), pageDefine.getIsDesignerDsl());
        if (templateService != null) {
            uiBotModel = templateService.createPage(apiRequest, executeContext, (PcUiBotPageDefine)pageDefine, (List)Lists.newArrayList((Object[])new PcUiBotTaskPageDefine[]{pageDefine}));
        }
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        return uiBotModel;
    }

    private void appendUserOrderConditions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        try {
            JSONObject orderSetting;
            if (executeContext.getIsDesigner() != null && executeContext.getIsDesigner().booleanValue()) {
                return;
            }
            if (executeContext.getOpenWindow() != null && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow().booleanValue())) {
                return;
            }
            if (pageDefine == null) {
                return;
            }
            String schema = pageDefine.getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            tmProjectId = StringUtils.hasText((String)executeContext.getTmProjectId()) ? executeContext.getTmProjectId() : "__uibot__";
            JSONObject userSetting = this.digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey((Object)"order") && !userSetting.containsKey((Object)schema)) {
                JSONObject setting = new JSONObject();
                setting.put(schema, (Object)userSetting);
                userSetting = setting;
            }
            if (userSetting != null && !userSetting.isEmpty() && (orderSetting = userSetting.getJSONObject(schema)).containsKey((Object)"order")) {
                pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
            }
            pageDefine.setUserSetting(userSetting);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, String backlogId, ApiRequest apiRequest) {
        TemplateService templateService;
        long start = System.currentTimeMillis();
        List pageDefineList = this.projectPageDefineAnalyzer.analysis(executeContext, backlogId, apiRequest);
        log.debug("[{}]\u89e3\u6790\u9875\u9762\u5b9a\u4e49\uff0ccost\uff1a{} ms", (Object)backlogId, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        UiBotModel uiBotModel = null;
        if (!CollectionUtils.isEmpty((Collection)pageDefineList) && (templateService = this.getTemplate(executeContext, ((PcUiBotTaskPageDefine)pageDefineList.get(0)).getVersion(), ((PcUiBotTaskPageDefine)pageDefineList.get(0)).getIsDesignerDsl())) != null) {
            uiBotModel = templateService.createTaskPage(apiRequest, executeContext, (PcUiBotPageDefine)pageDefineList.get(0), pageDefineList);
        }
        log.debug("[{}]\u521b\u5efa\u9875\u9762\uff0ccost\uff1a{} ms", (Object)backlogId, (Object)(System.currentTimeMillis() - start));
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        return uiBotModel;
    }

    private TemplateService<PcUiBotTaskPageDefine> getTemplate(PcUiBotExecuteContext executeContext, String version, Boolean isDesignerDsl) {
        String templateName = "webplatform-project-charge";
        return (TemplateService)this.templateContainer.get(templateName);
    }
}

